/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl.cli;

import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.CliRequests;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcResponseFactory;
import com.alipay.sofa.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

public class RemoveLearnersRequestProcessor
extends BaseCliRequestProcessor<CliRequests.RemoveLearnersRequest> {
    public RemoveLearnersRequestProcessor(Executor executor) {
        super(executor);
    }

    @Override
    protected String getPeerId(CliRequests.RemoveLearnersRequest request) {
        return request.getLeaderId();
    }

    @Override
    protected String getGroupId(CliRequests.RemoveLearnersRequest request) {
        return request.getGroupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.RemoveLearnersRequest request, RpcRequestClosure done) {
        List<PeerId> oldLearners = ctx.node.listLearners();
        ArrayList<PeerId> removeingLearners = new ArrayList<PeerId>(request.getLearnersCount());
        Iterator iterator = request.getLearnersList().iterator();
        while (iterator.hasNext()) {
            PeerId peer = new PeerId();
            String peerStr = (String)iterator.next();
            if (!peer.parse(peerStr)) {
                return RpcResponseFactory.newResponse(RaftError.EINVAL, "Fail to parse peer id %", peerStr);
            }
            removeingLearners.add(peer);
        }
        LOG.info("Receive RemoveLearnersRequest to {} from {}, removing {}", new Object[]{ctx.node.getNodeId(), done.getBizContext().getRemoteAddress(), removeingLearners});
        ctx.node.removeLearners(removeingLearners, status -> {
            if (!status.isOk()) {
                done.run(status);
            } else {
                CliRequests.LearnersOpResponse.Builder rb = CliRequests.LearnersOpResponse.newBuilder();
                for (PeerId peer : oldLearners) {
                    rb.addOldLearners(peer.toString());
                    if (removeingLearners.contains(peer)) continue;
                    rb.addNewLearners(peer.toString());
                }
                done.sendResponse((Message)rb.build());
            }
        });
        return null;
    }

    public String interest() {
        return CliRequests.RemoveLearnersRequest.class.getName();
    }
}

