/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.RpcRequests;

public class RpcResponseFactory {
    public static RpcRequests.ErrorResponse newResponse(Status st) {
        if (st == null) {
            return RpcResponseFactory.newResponse(0, "OK", new Object[0]);
        }
        return RpcResponseFactory.newResponse(st.getCode(), st.getErrorMsg(), new Object[0]);
    }

    public static RpcRequests.ErrorResponse newResponse(RaftError error, String fmt, Object ... args) {
        return RpcResponseFactory.newResponse(error.getNumber(), fmt, args);
    }

    public static RpcRequests.ErrorResponse newResponse(int code, String fmt, Object ... args) {
        RpcRequests.ErrorResponse.Builder builder = RpcRequests.ErrorResponse.newBuilder();
        builder.setErrorCode(code);
        if (fmt != null) {
            builder.setErrorMsg(String.format(fmt, args));
        }
        return builder.build();
    }
}

