/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft;

import com.alipay.sofa.jraft.util.FileOutputSignalHandler;
import com.alipay.sofa.jraft.util.MetricReporter;
import com.alipay.sofa.jraft.util.MetricThreadPoolExecutor;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolMetricsSignalHandler
extends FileOutputSignalHandler {
    private static Logger LOG = LoggerFactory.getLogger(ThreadPoolMetricsSignalHandler.class);
    private static final String DIR = SystemPropertyUtil.get("jraft.signal.thread.pool.metrics.dir", "");
    private static final String BASE_NAME = "thread_pool_metrics.log";

    @Override
    public void handle(String signalName) {
        try {
            File file = this.getOutputFile(DIR, BASE_NAME);
            LOG.info("Printing thread pools metrics with signal: {} to file: {}.", (Object)signalName, (Object)file);
            try (PrintStream out = new PrintStream(new FileOutputStream(file, true));){
                MetricReporter reporter = MetricReporter.forRegistry(MetricThreadPoolExecutor.metricRegistry()).outputTo(out).build();
                reporter.report();
            }
        }
        catch (IOException e) {
            LOG.error("Fail to print thread pools metrics.", (Throwable)e);
        }
    }
}

