/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import com.alipay.remoting.rpc.RpcConfigManager;
import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.RaftRpcServerFactory;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.ThreadPoolMetricSet;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    public static final int MIN_CLOSURE_EXECUTOR_POOL_SIZE = Integer.parseInt(System.getProperty("jraft.closure.threadpool.size.min", String.valueOf(Utils.cpus())));
    public static final int MAX_CLOSURE_EXECUTOR_POOL_SIZE = Integer.parseInt(System.getProperty("jraft.closure.threadpool.size.max", String.valueOf(Utils.cpus() * 100)));
    private static ThreadPoolExecutor CLOSURE_EXECUTOR = ThreadPoolUtil.newThreadPool("CLOSURE_EXECUTOR", true, MIN_CLOSURE_EXECUTOR_POOL_SIZE, MAX_CLOSURE_EXECUTOR_POOL_SIZE, 60L, new SynchronousQueue<Runnable>(), new NamedThreadFactory("JRaft-Closure-Executor-", true));
    private static final Pattern GROUP_ID_PATTER = Pattern.compile("^[a-zA-Z][a-zA-Z0-9\\-_]*$");
    public static final int RAFT_DATA_BUF_SIZE = Integer.parseInt(System.getProperty("jraft.byte_buf.size", "1024"));
    public static final String IP_ANY = "0.0.0.0";

    public static void verifyGroupId(String groupId) {
        if (StringUtils.isBlank((String)groupId)) {
            throw new IllegalArgumentException("Blank groupId");
        }
        if (!GROUP_ID_PATTER.matcher(groupId).matches()) {
            throw new IllegalArgumentException("Invalid group id, it should be started with character 'a'-'z' or 'A'-'Z',and followed with numbers, english alphabet, '-' or '_'. ");
        }
    }

    public static void registerClosureExecutorMetrics(MetricRegistry registry) {
        registry.register("raft-utils-closure-thread-pool", (Metric)new ThreadPoolMetricSet(CLOSURE_EXECUTOR));
    }

    public static Future<?> runClosureInThread(Closure done) {
        return Utils.runClosureInThread(done, Status.OK());
    }

    public static Future<?> runInThread(Runnable runnable) {
        return CLOSURE_EXECUTOR.submit(runnable);
    }

    public static Future<?> runClosureInThread(Closure done, Status status) {
        if (done == null) {
            return null;
        }
        return Utils.runInThread(() -> {
            try {
                done.run(status);
            }
            catch (Throwable t) {
                LOG.error("Fail to run done closure", t);
            }
        });
    }

    public static int closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return 0;
        }
        try {
            closeable.close();
            return 0;
        }
        catch (IOException e) {
            LOG.error("Fail to close", (Throwable)e);
            return RaftError.EIO.getNumber();
        }
    }

    public static int cpus() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static long getProcessId(long fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Long.parseLong(jvmName.substring(0, index));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public static ByteBuffer expandByteBuffer(ByteBuffer buf) {
        return Utils.expandByteBufferAtLeast(buf, RAFT_DATA_BUF_SIZE);
    }

    public static ByteBuffer allocate(int size) {
        return ByteBuffer.allocate(size);
    }

    public static ByteBuffer allocate() {
        return Utils.allocate(RAFT_DATA_BUF_SIZE);
    }

    public static ByteBuffer expandByteBufferAtLeast(ByteBuffer buf, int minLength) {
        int newCapacity = minLength > RAFT_DATA_BUF_SIZE ? minLength : RAFT_DATA_BUF_SIZE;
        ByteBuffer newBuf = ByteBuffer.allocate(buf.capacity() + newCapacity);
        buf.flip();
        newBuf.put(buf);
        return newBuf;
    }

    public static ByteBuffer expandByteBufferAtMost(ByteBuffer buf, int maxLength) {
        int newCapacity = maxLength > RAFT_DATA_BUF_SIZE || maxLength <= 0 ? RAFT_DATA_BUF_SIZE : maxLength;
        ByteBuffer newBuf = ByteBuffer.allocate(buf.capacity() + newCapacity);
        buf.flip();
        newBuf.put(buf);
        return newBuf;
    }

    public static long monotonicMs() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    public static long nowMs() {
        return System.currentTimeMillis();
    }

    public static long monotonicUs() {
        return TimeUnit.NANOSECONDS.toMicros(System.nanoTime());
    }

    public static byte[] getBytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static void ensureBoltPipeline() {
        if (RpcConfigManager.dispatch_msg_list_in_default_executor()) {
            System.setProperty("bolt.rpc.dispatch-msg-list-in-default-executor", "false");
            RaftRpcServerFactory.LOG.warn("JRaft SET {} to be false for replicator pipeline optimistic.", (Object)"bolt.rpc.dispatch-msg-list-in-default-executor");
        }
    }

    public static <T> T withLockObject(T obj) {
        return Requires.requireNonNull(obj, "obj");
    }
}

