/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import com.alipay.sofa.jraft.util.NonReentrantLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

public class ThreadId {
    private final Object data;
    private volatile NonReentrantLock lock = new NonReentrantLock();
    private final List<Integer> pendingErrors = Collections.synchronizedList(new ArrayList());
    private final OnError onError;

    public ThreadId(Object data, OnError onError) {
        this.data = data;
        this.onError = onError;
    }

    public Object getData() {
        return this.data;
    }

    public Object lock() {
        NonReentrantLock theLock = this.lock;
        if (theLock == null) {
            return null;
        }
        try {
            while (!theLock.tryLock(1L, TimeUnit.SECONDS)) {
                if (this.lock != null) continue;
                return null;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        if (this.lock == null) {
            theLock.unlock();
            return null;
        }
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        NonReentrantLock theLock = this.lock;
        if (theLock == null) {
            return;
        }
        try {
            ArrayList<Integer> errors;
            List<Integer> list = this.pendingErrors;
            synchronized (list) {
                errors = new ArrayList<Integer>(this.pendingErrors);
                this.pendingErrors.clear();
            }
            for (Integer code : errors) {
                if (this.onError == null) continue;
                this.onError.onError(this, this.data, code);
            }
        }
        finally {
            this.doUnlock(theLock);
        }
    }

    private void doUnlock(Lock theLock) {
        if (theLock != null) {
            try {
                theLock.unlock();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void join() {
        while (this.lock != null) {
            Thread.yield();
        }
    }

    public String toString() {
        return this.data.toString();
    }

    public void unlockAndDestroy() {
        NonReentrantLock theLock = this.lock;
        this.lock = null;
        if (theLock != null) {
            try {
                theLock.unlock();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setError(int errorCode) {
        NonReentrantLock theLock = this.lock;
        if (theLock == null) {
            return;
        }
        if (theLock.tryLock()) {
            try {
                if (this.onError == null) return;
                this.onError.onError(this, this.data, errorCode);
                return;
            }
            finally {
                this.doUnlock(theLock);
            }
        } else {
            this.pendingErrors.add(errorCode);
        }
    }

    public static interface OnError {
        public void onError(ThreadId var1, Object var2, int var3);
    }
}

