/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import com.alipay.sofa.jraft.util.Utils;
import java.nio.ByteBuffer;

public final class ByteBufferCollector {
    private ByteBuffer buffer;

    public int capacity() {
        return this.buffer != null ? this.buffer.capacity() : 0;
    }

    public void expandIfNecessary() {
        if (!this.hasRemaining()) {
            this.getBuffer(Utils.RAFT_DATA_BUF_SIZE);
        }
    }

    public void expandAtMost(int atMostBytes) {
        this.buffer = this.buffer == null ? Utils.allocate(atMostBytes) : Utils.expandByteBufferAtMost(this.buffer, atMostBytes);
    }

    public boolean hasRemaining() {
        return this.buffer != null && this.buffer.hasRemaining();
    }

    private ByteBufferCollector(int size) {
        if (size > 0) {
            this.buffer = Utils.allocate(size);
        }
    }

    public static ByteBufferCollector allocate(int size) {
        return new ByteBufferCollector(size);
    }

    public static ByteBufferCollector allocate() {
        return new ByteBufferCollector(Utils.RAFT_DATA_BUF_SIZE);
    }

    private ByteBuffer getBuffer(int expectSize) {
        if (this.buffer == null) {
            this.buffer = Utils.allocate(expectSize);
        } else if (this.buffer.remaining() < expectSize) {
            this.buffer = Utils.expandByteBufferAtLeast(this.buffer, expectSize);
        }
        return this.buffer;
    }

    public void put(ByteBuffer buf) {
        this.getBuffer(buf.remaining()).put(buf);
    }

    public void put(byte[] bs) {
        this.getBuffer(bs.length).put(bs);
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }
}

