/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.conf;

import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.util.Copiable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Configuration
implements Iterable<PeerId>,
Copiable<Configuration> {
    private List<PeerId> peers = new ArrayList<PeerId>();

    public Configuration() {
    }

    public Configuration(Iterable<PeerId> conf) {
        for (PeerId peer : conf) {
            this.peers.add(peer.copy());
        }
    }

    @Override
    public Configuration copy() {
        return new Configuration(this.peers);
    }

    public void reset() {
        this.peers.clear();
    }

    public boolean isEmpty() {
        return this.peers.isEmpty();
    }

    public int size() {
        return this.peers.size();
    }

    @Override
    public Iterator<PeerId> iterator() {
        return this.peers.iterator();
    }

    public Set<PeerId> getPeerSet() {
        return new HashSet<PeerId>(this.peers);
    }

    public List<PeerId> listPeers() {
        return new ArrayList<PeerId>(this.peers);
    }

    public List<PeerId> getPeers() {
        return this.peers;
    }

    public void setPeers(List<PeerId> peers) {
        this.peers.clear();
        for (PeerId peer : peers) {
            this.peers.add(peer.copy());
        }
    }

    public void appendPeers(Collection<PeerId> set) {
        this.peers.addAll(set);
    }

    public boolean addPeer(PeerId peer) {
        return this.peers.add(peer);
    }

    public boolean removePeer(PeerId peer) {
        return this.peers.remove(peer);
    }

    public boolean contains(PeerId peer) {
        return this.peers.contains(peer);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.peers == null ? 0 : this.peers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Configuration other = (Configuration)obj;
        if (this.peers == null) {
            return other.peers == null;
        }
        return this.peers.equals(other.peers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        List<PeerId> peers = this.listPeers();
        int i = 0;
        int size = peers.size();
        for (PeerId peer : peers) {
            sb.append(peer);
            if (i < size - 1) {
                sb.append(",");
            }
            ++i;
        }
        return sb.toString();
    }

    public boolean parse(String conf) {
        String[] peerStrs;
        if (conf == null) {
            return false;
        }
        this.reset();
        String[] stringArray = peerStrs = conf.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            PeerId peer = new PeerId();
            String peerStr = stringArray[i];
            if (!peer.parse(peerStr)) continue;
            this.addPeer(peer);
        }
        return true;
    }

    public void diff(Configuration rhs, Configuration included, Configuration excluded) {
        included.peers = new ArrayList<PeerId>(this.peers);
        included.peers.removeAll(rhs.peers);
        excluded.peers = new ArrayList<PeerId>(rhs.peers);
        excluded.peers.removeAll(this.peers);
    }
}

