/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.hessian.generic.util;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class ClassFilter {
    private static final Set<String> PKG_FILTER;
    private static final Set<String> NAME_FILTER;
    public static final String CLASS_NAME;

    public static boolean filter(String type) {
        return ClassFilter.doFilter(type, false);
    }

    public static boolean filterExcludeClass(String type) {
        return ClassFilter.doFilter(type, true);
    }

    private static boolean doFilter(String type, boolean excludeClass) {
        if (excludeClass && CLASS_NAME.equals(type)) {
            return false;
        }
        if (NAME_FILTER.contains(type)) {
            return true;
        }
        int index = -1;
        while ((index = type.indexOf(46, index + 1)) != -1) {
            String pkg = type.substring(0, index);
            if (!PKG_FILTER.contains(pkg)) continue;
            return true;
        }
        return false;
    }

    public static boolean nameFilter(String type) {
        if ("date".equals(type) || "object".equals(type)) {
            return false;
        }
        return NAME_FILTER.contains(type);
    }

    public static String encodeObjectAndDate(String type) {
        return type.replace(Object.class.getName(), "object").replace(Date.class.getName(), "date");
    }

    public static String decodeObjectAndDate(String type) {
        return type.replace("object", Object.class.getName()).replace("date", Date.class.getName());
    }

    public static boolean arrayFilter(Class clazz) {
        if (!clazz.isArray()) {
            return false;
        }
        String arrayType = ClassFilter.getArrayComponentName(clazz);
        return ClassFilter.nameFilter(arrayType);
    }

    public static boolean arrayFilter(String type) {
        int lastIndex = type.lastIndexOf(91);
        if (lastIndex == -1) {
            return false;
        }
        String arrayType = type.substring(lastIndex + 1);
        return ClassFilter.nameFilter(arrayType);
    }

    private static String getArrayComponentName(Class cl) {
        if (cl.isArray()) {
            return ClassFilter.getArrayComponentName(cl.getComponentType());
        }
        return cl.getName();
    }

    static {
        CLASS_NAME = Class.class.getName();
        PKG_FILTER = new HashSet<String>();
        PKG_FILTER.add("com.sun");
        PKG_FILTER.add("java");
        PKG_FILTER.add("javax");
        PKG_FILTER.add("org.ietf");
        PKG_FILTER.add("org.ogm");
        PKG_FILTER.add("org.w3c");
        PKG_FILTER.add("org.xml");
        PKG_FILTER.add("sunw.io");
        PKG_FILTER.add("sunw.util");
        NAME_FILTER = new HashSet<String>();
        NAME_FILTER.add("boolean");
        NAME_FILTER.add(Boolean.class.getName());
        NAME_FILTER.add("byte");
        NAME_FILTER.add(Byte.class.getName());
        NAME_FILTER.add("short");
        NAME_FILTER.add(Short.class.getName());
        NAME_FILTER.add("int");
        NAME_FILTER.add(Integer.class.getName());
        NAME_FILTER.add("long");
        NAME_FILTER.add(Long.class.getName());
        NAME_FILTER.add("float");
        NAME_FILTER.add(Float.class.getName());
        NAME_FILTER.add("double");
        NAME_FILTER.add(Double.class.getName());
        NAME_FILTER.add("char");
        NAME_FILTER.add(Character.class.getName());
        NAME_FILTER.add("void");
        NAME_FILTER.add(Void.class.getName());
        NAME_FILTER.add("string");
        NAME_FILTER.add(String.class.getName());
        NAME_FILTER.add("object");
        NAME_FILTER.add("date");
    }
}

