/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionSelectStrategy;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.util.GlobalSwitch;
import com.alipay.remoting.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;

public class RandomSelectStrategy
implements ConnectionSelectStrategy {
    private static final Logger logger = BoltLoggerFactory.getLogger("CommonDefault");
    private static final int MAX_TIMES = 5;
    private final Random random = new Random();
    private GlobalSwitch globalSwitch;

    public RandomSelectStrategy() {
    }

    public RandomSelectStrategy(GlobalSwitch globalSwitch) {
        this.globalSwitch = globalSwitch;
    }

    @Override
    public Connection select(List<Connection> conns) {
        try {
            if (conns == null) {
                return null;
            }
            int size = conns.size();
            if (size == 0) {
                return null;
            }
            Connection result = null;
            if (null != this.globalSwitch && this.globalSwitch.isOn(1)) {
                ArrayList<Connection> serviceStatusOnConns = new ArrayList<Connection>();
                for (Connection conn : conns) {
                    String serviceStatus = (String)conn.getAttribute("bolt.conn.service.status");
                    if (StringUtils.equals(serviceStatus, "off")) continue;
                    serviceStatusOnConns.add(conn);
                }
                if (serviceStatusOnConns.size() < 0) {
                    throw new Exception("No available connection when select in RandomSelectStrategy.");
                }
                result = this.randomGet(serviceStatusOnConns);
            } else {
                result = this.randomGet(conns);
            }
            return result;
        }
        catch (Throwable e) {
            logger.error("Choose connection failed using RandomSelectStrategy!", e);
            return null;
        }
    }

    private Connection randomGet(List<Connection> conns) {
        Connection result = null;
        int size = conns.size();
        int tries = 0;
        while (!(result != null && result.isFine() || tries++ >= 5)) {
            result = conns.get(this.random.nextInt(size));
        }
        if (result != null && !result.isFine()) {
            result = null;
        }
        return result;
    }
}

