/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.utils;

public class TimeWaitRunner {
    private final long waitTime;
    private final boolean runImmediately;
    private volatile long lastLogTime;

    public TimeWaitRunner(long waitTimeMills) {
        this.waitTime = waitTimeMills;
        this.runImmediately = false;
    }

    public TimeWaitRunner(long waitTimeMills, boolean runImmediately) {
        this.waitTime = waitTimeMills;
        this.runImmediately = runImmediately;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWithRunnable(Runnable runnable) {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.runImmediately) {
            runnable.run();
        } else if (currentTimeMillis > this.lastLogTime + this.waitTime) {
            TimeWaitRunner timeWaitRunner = this;
            synchronized (timeWaitRunner) {
                if (currentTimeMillis > this.lastLogTime + this.waitTime) {
                    this.lastLogTime = currentTimeMillis;
                    runnable.run();
                }
            }
        }
    }
}

