/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.config;

import com.alipay.sofa.common.config.ConfigKey;
import com.alipay.sofa.common.config.ConfigManager;
import com.alipay.sofa.common.config.ConfigSource;
import com.alipay.sofa.common.config.ManagementListener;
import com.alipay.sofa.common.utils.OrderComparator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigManger
implements ConfigManager {
    public static final Logger LOGGER = LoggerFactory.getLogger(DefaultConfigManger.class);
    private final List<ConfigSource> configSources = new LinkedList<ConfigSource>();
    private final List<ManagementListener> configListeners = new LinkedList<ManagementListener>();

    @Override
    public <T> T getOrDefault(ConfigKey<T> key) {
        return this.getConfig(key, key.getDefaultValue());
    }

    @Override
    public <T> T getOrCustomDefault(ConfigKey<T> key, T customDefault) {
        return this.getConfig(key, customDefault);
    }

    public <T> T getConfig(ConfigKey<T> key, T defaultValue) {
        T result = null;
        this.beforeConfigLoading(key);
        for (ConfigSource configSource : this.configSources) {
            result = configSource.getConfig(key);
            if (result == null) continue;
            this.onConfigLoaded(key, configSource);
            return result;
        }
        this.onLoadDefaultValue(key, defaultValue);
        return defaultValue;
    }

    private <T> void onLoadDefaultValue(ConfigKey<T> key, Object defaultValue) {
        for (ManagementListener configListener : this.configListeners) {
            configListener.onLoadDefaultValue(key, defaultValue);
        }
    }

    private <T> void beforeConfigLoading(ConfigKey<T> key) {
        for (ManagementListener configListener : this.configListeners) {
            configListener.beforeConfigLoading(key, this.configSources);
        }
    }

    private <T> void onConfigLoaded(ConfigKey<T> key, ConfigSource configSource) {
        for (ManagementListener configListener : this.configListeners) {
            configListener.afterConfigLoaded(key, configSource, this.configSources);
        }
    }

    @Override
    public void addConfigSource(ConfigSource configSource) {
        this.configSources.add(configSource);
        OrderComparator.sort(this.configSources);
    }

    @Override
    public void addConfigListener(ManagementListener configListener) {
        this.configListeners.add(configListener);
        OrderComparator.sort(this.configListeners);
    }

    List<ConfigSource> getConfigSources() {
        return this.configSources;
    }

    List<ManagementListener> getConfigListeners() {
        return this.configListeners;
    }
}

