/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.spring.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class BeanUtils {
    private static final Log logger = LogFactory.getLog(BeanUtils.class);
    private static final String[] EMPTY_BEAN_NAMES = new String[0];

    public static boolean isBeanPresent(ListableBeanFactory beanFactory, Class<?> beanClass) {
        return BeanUtils.isBeanPresent(beanFactory, beanClass, false);
    }

    public static boolean isBeanPresent(ListableBeanFactory beanFactory, Class<?> beanClass, boolean includingAncestors) {
        Object[] beanNames = BeanUtils.getBeanNames(beanFactory, beanClass, includingAncestors);
        return !ObjectUtils.isEmpty((Object[])beanNames);
    }

    public static boolean isBeanPresent(ListableBeanFactory beanFactory, String beanClassName, boolean includingAncestors) {
        boolean present = false;
        ClassLoader classLoader = beanFactory.getClass().getClassLoader();
        if (ClassUtils.isPresent((String)beanClassName, (ClassLoader)classLoader)) {
            Class beanClass = ClassUtils.resolveClassName((String)beanClassName, (ClassLoader)classLoader);
            present = BeanUtils.isBeanPresent(beanFactory, beanClass, includingAncestors);
        }
        return present;
    }

    public static boolean isBeanPresent(ListableBeanFactory beanFactory, String beanClassName) {
        return BeanUtils.isBeanPresent(beanFactory, beanClassName, false);
    }

    public static boolean isBeanPresent(BeanFactory beanFactory, String beanName, Class<?> beanClass) throws NullPointerException {
        return beanFactory.containsBean(beanName) && beanFactory.isTypeMatch(beanName, beanClass);
    }

    public static String[] getBeanNames(ConfigurableListableBeanFactory beanFactory, Class<?> beanClass) {
        return BeanUtils.getBeanNames(beanFactory, beanClass, false);
    }

    public static String[] getBeanNames(ConfigurableListableBeanFactory beanFactory, Class<?> beanClass, boolean includingAncestors) {
        BeanFactory parentBeanFactory;
        LinkedHashSet<String> beanNames = new LinkedHashSet<String>();
        beanNames.addAll(BeanUtils.doGetBeanNames(beanFactory, beanClass));
        if (includingAncestors && (parentBeanFactory = beanFactory.getParentBeanFactory()) instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory configurableListableBeanFactory = (ConfigurableListableBeanFactory)parentBeanFactory;
            String[] parentBeanNames = BeanUtils.getBeanNames(configurableListableBeanFactory, beanClass, includingAncestors);
            beanNames.addAll(Arrays.asList(parentBeanNames));
        }
        return StringUtils.toStringArray(beanNames);
    }

    public static String[] getBeanNames(ListableBeanFactory beanFactory, Class<?> beanClass) {
        return BeanUtils.getBeanNames(beanFactory, beanClass, false);
    }

    public static String[] getBeanNames(ListableBeanFactory beanFactory, Class<?> beanClass, boolean includingAncestors) {
        ListableBeanFactory actualBeanFactory;
        if (beanFactory instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)ConfigurableApplicationContext.class.cast(beanFactory);
            actualBeanFactory = applicationContext.getBeanFactory();
        } else {
            actualBeanFactory = beanFactory;
        }
        if (actualBeanFactory instanceof ConfigurableListableBeanFactory) {
            return BeanUtils.getBeanNames((ConfigurableListableBeanFactory)actualBeanFactory, beanClass, includingAncestors);
        }
        return EMPTY_BEAN_NAMES;
    }

    private static Class<?> getFactoryBeanType(ConfigurableListableBeanFactory beanFactory, BeanDefinition factoryBeanDefinition) {
        BeanDefinition actualFactoryBeanDefinition = factoryBeanDefinition;
        final ArrayList beanClasses = new ArrayList(1);
        ClassLoader classLoader = beanFactory.getBeanClassLoader();
        String factoryBeanClassName = actualFactoryBeanDefinition.getBeanClassName();
        if (StringUtils.isEmpty((Object)factoryBeanClassName)) {
            String factoryBeanName = factoryBeanDefinition.getFactoryBeanName();
            actualFactoryBeanDefinition = beanFactory.getBeanDefinition(factoryBeanName);
            factoryBeanClassName = actualFactoryBeanDefinition.getBeanClassName();
        }
        if (StringUtils.hasText((String)factoryBeanClassName)) {
            Class<?> factoryBeanClass = BeanUtils.resolveBeanType(factoryBeanClassName, classLoader);
            final String factoryMethodName = factoryBeanDefinition.getFactoryMethodName();
            ReflectionUtils.doWithMethods(factoryBeanClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    beanClasses.add(method.getReturnType());
                }
            }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

                public boolean matches(Method method) {
                    return factoryMethodName.equals(method.getName());
                }
            });
        }
        return beanClasses.isEmpty() ? null : (Class)beanClasses.get(0);
    }

    private static Class<?> resolveBeanType(ConfigurableListableBeanFactory beanFactory, BeanDefinition beanDefinition) {
        String beanClassName;
        String factoryBeanName = beanDefinition.getFactoryBeanName();
        ClassLoader classLoader = beanFactory.getBeanClassLoader();
        Class<?> beanType = null;
        if (StringUtils.hasText((String)factoryBeanName)) {
            beanType = BeanUtils.getFactoryBeanType(beanFactory, beanDefinition);
        }
        if (beanType == null && StringUtils.hasText((String)(beanClassName = beanDefinition.getBeanClassName()))) {
            beanType = BeanUtils.resolveBeanType(beanClassName, classLoader);
        }
        if (beanType == null && logger.isErrorEnabled()) {
            String message = beanDefinition + " can't be resolved bean type!";
            logger.error((Object)message);
        }
        return beanType;
    }

    protected static Set<String> doGetBeanNames(ConfigurableListableBeanFactory beanFactory, Class<?> beanType) {
        String[] allBeanNames = beanFactory.getBeanDefinitionNames();
        LinkedHashSet<String> beanNames = new LinkedHashSet<String>();
        for (String beanName : allBeanNames) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            Class<?> beanClass = BeanUtils.resolveBeanType(beanFactory, beanDefinition);
            if (beanClass == null || !ClassUtils.isAssignable(beanType, beanClass)) continue;
            beanNames.add(beanName);
        }
        return Collections.unmodifiableSet(beanNames);
    }

    public static Class<?> resolveBeanType(String beanClassName, ClassLoader classLoader) {
        Class beanType;
        block3: {
            if (!StringUtils.hasText((String)beanClassName)) {
                return null;
            }
            beanType = null;
            try {
                beanType = ClassUtils.resolveClassName((String)beanClassName, (ClassLoader)classLoader);
                beanType = ClassUtils.getUserClass((Class)beanType);
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block3;
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return beanType;
    }

    public static <T> T getOptionalBean(ListableBeanFactory beanFactory, Class<T> beanClass, boolean includingAncestors) throws BeansException {
        Object bean;
        block4: {
            Object[] beanNames = BeanUtils.getBeanNames(beanFactory, beanClass, includingAncestors);
            if (ObjectUtils.isEmpty((Object[])beanNames)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The bean [ class : " + beanClass.getName() + " ] can't be found "));
                }
                return null;
            }
            bean = null;
            try {
                bean = includingAncestors ? BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, beanClass) : beanFactory.getBean(beanClass);
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return (T)bean;
    }

    public static <T> T getOptionalBean(ListableBeanFactory beanFactory, Class<T> beanClass) throws BeansException {
        return BeanUtils.getOptionalBean(beanFactory, beanClass, false);
    }

    public static <T> T getBeanIfAvailable(BeanFactory beanFactory, String beanName, Class<T> beanType) throws BeansException {
        if (BeanUtils.isBeanPresent(beanFactory, beanName, beanType)) {
            return (T)beanFactory.getBean(beanName, beanType);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("The bean[name : %s , type : %s] can't be found in Spring BeanFactory", beanName, beanType.getName()));
        }
        return null;
    }

    public static <T> List<T> getSortedBeans(ListableBeanFactory beanFactory, Class<T> type) {
        Map beansOfType = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, type);
        ArrayList beansList = new ArrayList(beansOfType.values());
        AnnotationAwareOrderComparator.sort(beansList);
        return Collections.unmodifiableList(beansList);
    }

    public static <T> Map<String, T> sort(Map<String, T> beansMap) {
        Map<String, T> unmodifiableBeansMap = Collections.unmodifiableMap(beansMap);
        ArrayList<NamingBean<T>> namingBeans = new ArrayList<NamingBean<T>>(unmodifiableBeansMap.size());
        for (Map.Entry<String, T> entry : unmodifiableBeansMap.entrySet()) {
            String string = entry.getKey();
            T bean = entry.getValue();
            NamingBean<T> namingBean = new NamingBean<T>(string, bean);
            namingBeans.add(namingBean);
        }
        AnnotationAwareOrderComparator.sort(namingBeans);
        LinkedHashMap<String, Object> sortedBeansMap = new LinkedHashMap<String, Object>(beansMap.size());
        for (NamingBean namingBean : namingBeans) {
            sortedBeansMap.put(namingBean.name, namingBean.bean);
        }
        return sortedBeansMap;
    }

    static class NamingBean<T>
    extends AnnotationAwareOrderComparator
    implements Comparable<NamingBean>,
    Ordered {
        private final String name;
        private final T bean;

        NamingBean(String name, T bean) {
            this.name = name;
            this.bean = bean;
        }

        @Override
        public int compareTo(NamingBean o) {
            return this.compare(this, o);
        }

        public int getOrder() {
            return this.getOrder(this.bean);
        }
    }
}

