/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterImpl;
import java.lang.reflect.Method;
import java.util.function.ToDoubleFunction;

final class FieldWriterDoubleValueFunc
extends FieldWriterImpl {
    final ToDoubleFunction function;

    protected FieldWriterDoubleValueFunc(String fieldName, int ordinal, long features, String format, String label, Method method, ToDoubleFunction function) {
        super(fieldName, ordinal, features, format, label, Double.TYPE, Double.TYPE, null, method);
        this.function = function;
    }

    @Override
    public Object getFieldValue(Object object) {
        return this.function.applyAsDouble(object);
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, Object object) {
        double fieldValue = this.function.applyAsDouble(object);
        jsonWriter.writeDouble(fieldValue);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, Object object) {
        double value;
        try {
            value = this.function.applyAsDouble(object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeDouble(value);
        return true;
    }
}

