/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import java.io.Closeable;
import java.time.ZoneId;
import java.time.zone.ZoneRules;

public class IOUtils {
    public static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    public static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    public static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    public static final int OFFSET_0800_TOTAL_SECONDS = 28800;
    public static final ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
    public static final String SHANGHAI_ZONE_ID_NAME = "Asia/Shanghai";
    public static final ZoneId SHANGHAI_ZONE_ID = "Asia/Shanghai".equals(DEFAULT_ZONE_ID.getId()) ? DEFAULT_ZONE_ID : ZoneId.of("Asia/Shanghai");
    public static final ZoneRules SHANGHAI_ZONE_RULES = SHANGHAI_ZONE_ID.getRules();

    public static int stringSize(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    public static int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    public static void getChars(int i, int index, byte[] buf) {
        int r;
        int q;
        int p = index;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--p] = DigitOnes[r];
            buf[--p] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--p] = digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--p] = sign;
        }
    }

    public static void getChars(int i, int index, char[] buf) {
        int r;
        int q;
        int p = index;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--p] = (char)DigitOnes[r];
            buf[--p] = (char)DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--p] = (char)digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--p] = sign;
        }
    }

    public static void getChars(long i, int index, byte[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static void getChars(long i, int index, char[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = (char)DigitOnes[r];
            buf[--charPos] = (char)DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = (char)DigitOnes[r];
            buf[--charPos] = (char)DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = (char)digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int encodeUTF8(byte[] src, int offset, int len, byte[] dst, int dp) {
        int sl = offset + len;
        while (offset < sl) {
            byte b1;
            byte b0 = src[offset++];
            if ((b1 = src[offset++]) == 0 && b0 >= 0) {
                dst[dp++] = b0;
                continue;
            }
            int c = (b0 & 0xFF) << 0 | (b1 & 0xFF) << 8;
            if (c < 2048) {
                dst[dp++] = (byte)(0xC0 | c >> 6);
                dst[dp++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c >= 55296 && c < 57344) {
                int uc;
                int ip = offset - 1;
                if (c >= 55296 && c < 56320) {
                    if (sl - ip < 2) {
                        uc = -1;
                    } else {
                        b0 = src[ip + 1];
                        b1 = src[ip + 2];
                        char d = (char)((b0 & 0xFF) << 0 | (b1 & 0xFF) << 8);
                        if (d < '\udc00' || d >= '\ue000') return -1;
                        offset += 2;
                        uc = (c << 10) + d + -56613888;
                    }
                } else {
                    if (c >= 56320 && c < 57344) {
                        return -1;
                    }
                    uc = c;
                }
                if (uc < 0) {
                    dst[dp++] = 63;
                    continue;
                }
                dst[dp++] = (byte)(0xF0 | uc >> 18);
                dst[dp++] = (byte)(0x80 | uc >> 12 & 0x3F);
                dst[dp++] = (byte)(0x80 | uc >> 6 & 0x3F);
                dst[dp++] = (byte)(0x80 | uc & 0x3F);
                continue;
            }
            dst[dp++] = (byte)(0xE0 | c >> 12);
            dst[dp++] = (byte)(0x80 | c >> 6 & 0x3F);
            dst[dp++] = (byte)(0x80 | c & 0x3F);
        }
        return dp;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int encodeUTF8(char[] src, int offset, int len, byte[] dst, int dp) {
        int sl = offset + len;
        int dlASCII = dp + Math.min(len, dst.length);
        while (dp < dlASCII && src[offset] < '\u0080') {
            dst[dp++] = (byte)src[offset++];
        }
        while (true) {
            int c;
            block12: {
                int uc;
                block11: {
                    block13: {
                        if (offset >= sl) {
                            return dp;
                        }
                        if ((c = src[offset++]) < 128) {
                            dst[dp++] = (byte)c;
                            continue;
                        }
                        if (c < 2048) {
                            dst[dp++] = (byte)(0xC0 | c >> 6);
                            dst[dp++] = (byte)(0x80 | c & 0x3F);
                            continue;
                        }
                        if (c < 55296 || c >= 57344) break block12;
                        int ip = offset - 1;
                        if (c < 55296 || c >= 56320) break block13;
                        if (sl - ip < 2) {
                            uc = -1;
                            break block11;
                        } else {
                            char d = src[ip + 1];
                            if (d >= '\udc00' && d < '\ue000') {
                                uc = (c << 10) + d + -56613888;
                                break block11;
                            } else {
                                dst[dp++] = 63;
                                continue;
                            }
                        }
                    }
                    if (c >= 56320 && c < 57344) {
                        dst[dp++] = 63;
                        continue;
                    }
                    uc = c;
                }
                if (uc < 0) {
                    dst[dp++] = 63;
                    continue;
                }
                dst[dp++] = (byte)(0xF0 | uc >> 18);
                dst[dp++] = (byte)(0x80 | uc >> 12 & 0x3F);
                dst[dp++] = (byte)(0x80 | uc >> 6 & 0x3F);
                dst[dp++] = (byte)(0x80 | uc & 0x3F);
                ++offset;
                continue;
            }
            dst[dp++] = (byte)(0xE0 | c >> 12);
            dst[dp++] = (byte)(0x80 | c >> 6 & 0x3F);
            dst[dp++] = (byte)(0x80 | c & 0x3F);
        }
    }

    public static boolean isNumber(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (!(ch == '+' || ch == '-' ? i != 0 : ch < '0' || ch > '9')) continue;
            return false;
        }
        return true;
    }

    public static void close(Closeable x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int decodeUTF8(byte[] src, int off, int len, byte[] dst) {
        int sl = off + len;
        int dp = 0;
        while (off < sl) {
            byte b1;
            byte b0;
            if ((b0 = src[off++]) >= 0) {
                dst[dp++] = b0;
                dst[dp++] = 0;
                continue;
            }
            if (b0 >> 5 == -2 && (b0 & 0x1E) != 0) {
                if (off < sl) {
                    if (((b1 = src[off++]) & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b0 << 6 ^ b1 ^ 0xF80);
                    dst[dp++] = (byte)c;
                    dst[dp++] = (byte)(c >> 8);
                    continue;
                }
                dst[dp++] = b0;
                dst[dp++] = 0;
                break;
            }
            if (b0 >> 4 == -2) {
                if (off + 1 < sl) {
                    boolean isSurrogate;
                    b1 = src[off++];
                    byte b2 = src[off++];
                    if (b0 == -32 && (b1 & 0xE0) == 128 || (b1 & 0xC0) != 128 || (b2 & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b0 << 12 ^ b1 << 6 ^ (b2 ^ 0xFFFE1F80));
                    boolean bl = isSurrogate = c >= '\ud800' && c < '\ue000';
                    if (isSurrogate) {
                        return -1;
                    }
                    dst[dp++] = (byte)c;
                    dst[dp++] = (byte)(c >> 8);
                    continue;
                }
                return -1;
            }
            if (b0 >> 3 == -2) {
                if (off + 2 < sl) {
                    byte b2 = src[off++];
                    byte b3 = src[off++];
                    byte b4 = src[off++];
                    int uc = b0 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                        return -1;
                    }
                    char c = (char)((uc >>> 10) + 55232);
                    dst[dp++] = (byte)c;
                    dst[dp++] = (byte)(c >> 8);
                    c = (char)((uc & 0x3FF) + 56320);
                    dst[dp++] = (byte)c;
                    dst[dp++] = (byte)(c >> 8);
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return dp;
    }

    public static int decodeUTF8(byte[] src, int off, int len, char[] dst) {
        int sl = off + len;
        int dp = 0;
        int dlASCII = Math.min(len, dst.length);
        while (dp < dlASCII && src[off] >= 0) {
            dst[dp++] = (char)src[off++];
        }
        while (off < sl) {
            byte b3;
            byte b2;
            byte b1;
            if ((b1 = src[off++]) >= 0) {
                dst[dp++] = (char)b1;
                continue;
            }
            if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                if (off < sl) {
                    if (((b2 = src[off++]) & 0xC0) != 128) {
                        return -1;
                    }
                    dst[dp++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                    continue;
                }
                return -1;
            }
            if (b1 >> 4 == -2) {
                if (off + 1 < sl) {
                    boolean isSurrogate;
                    b2 = src[off++];
                    b3 = src[off++];
                    if (b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                    boolean bl = isSurrogate = c >= '\ud800' && c < '\ue000';
                    if (isSurrogate) {
                        return -1;
                    }
                    dst[dp++] = c;
                    continue;
                }
                return -1;
            }
            if (b1 >> 3 == -2) {
                if (off + 2 < sl) {
                    b2 = src[off++];
                    b3 = src[off++];
                    byte b4 = src[off++];
                    int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                        return -1;
                    }
                    dst[dp++] = (char)((uc >>> 10) + 55232);
                    dst[dp++] = (char)((uc & 0x3FF) + 56320);
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return dp;
    }

    public static int getShanghaiZoneOffsetTotalSeconds(long seconds) {
        long SECONDS_1991_09_15_02 = 684900000L;
        long SECONDS_1991_04_14_03 = 671598000L;
        long SECONDS_1990_09_16_02 = 653450400L;
        long SECONDS_1990_04_15_03 = 640148400L;
        long SECONDS_1989_09_17_02 = 622000800L;
        long SECONDS_1989_04_16_03 = 608698800L;
        long SECONDS_1988_09_11_02 = 589946400L;
        long SECONDS_1988_04_17_03 = 577249200L;
        long SECONDS_1987_09_13_02 = 558496800L;
        long SECONDS_1987_04_12_03 = 545194800L;
        long SECONDS_1986_09_14_02 = 527047200L;
        long SECONDS_1986_05_04_03 = 515559600L;
        long SECONDS_1949_05_28_00 = -649987200L;
        long SECONDS_1949_05_01_01 = -652316400L;
        long SECONDS_1948_10_01_00 = -670636800L;
        long SECONDS_1948_05_01_01 = -683852400L;
        long SECONDS_1947_11_01_00 = -699580800L;
        long SECONDS_1947_04_15_01 = -716857200L;
        long SECONDS_1946_10_01_00 = -733795200L;
        long SECONDS_1946_05_15_01 = -745801200L;
        long SECONDS_1945_09_02_00 = -767836800L;
        long SECONDS_1942_01_31_01 = -881017200L;
        long SECONDS_1941_11_02_00 = -888796800L;
        long SECONDS_1941_03_15_01 = -908838000L;
        long SECONDS_1940_10_13_00 = -922060800L;
        long SECONDS_1940_06_01_01 = -933634800L;
        long SECONDS_1919_10_01_00 = -1585872000L;
        long SECONDS_1919_04_13_01 = -1600642800L;
        long SECONDS_1901_01_01_00 = -2177452800L;
        int OFFSET_0900_TOTAL_SECONDS = 32400;
        int OFFSET_0800_TOTAL_SECONDS = 28800;
        int OFFSET_0543_TOTAL_SECONDS = 29143;
        int zoneOffsetTotalSeconds = seconds >= SECONDS_1991_09_15_02 ? 28800 : (seconds >= SECONDS_1991_04_14_03 ? 32400 : (seconds >= SECONDS_1990_09_16_02 ? 28800 : (seconds >= SECONDS_1990_04_15_03 ? 32400 : (seconds >= SECONDS_1989_09_17_02 ? 28800 : (seconds >= SECONDS_1989_04_16_03 ? 32400 : (seconds >= SECONDS_1988_09_11_02 ? 28800 : (seconds >= SECONDS_1988_04_17_03 ? 32400 : (seconds >= SECONDS_1987_09_13_02 ? 28800 : (seconds >= SECONDS_1987_04_12_03 ? 32400 : (seconds >= SECONDS_1986_09_14_02 ? 28800 : (seconds >= SECONDS_1986_05_04_03 ? 32400 : (seconds >= SECONDS_1949_05_28_00 ? 28800 : (seconds >= SECONDS_1949_05_01_01 ? 32400 : (seconds >= SECONDS_1948_10_01_00 ? 28800 : (seconds >= SECONDS_1948_05_01_01 ? 32400 : (seconds >= SECONDS_1947_11_01_00 ? 28800 : (seconds >= SECONDS_1947_04_15_01 ? 32400 : (seconds >= SECONDS_1946_10_01_00 ? 28800 : (seconds >= SECONDS_1946_05_15_01 ? 32400 : (seconds >= SECONDS_1945_09_02_00 ? 28800 : (seconds >= SECONDS_1942_01_31_01 ? 32400 : (seconds >= SECONDS_1941_11_02_00 ? 28800 : (seconds >= SECONDS_1941_03_15_01 ? 32400 : (seconds >= SECONDS_1940_10_13_00 ? 28800 : (seconds >= SECONDS_1940_06_01_01 ? 32400 : (seconds >= SECONDS_1919_10_01_00 ? 28800 : (seconds >= SECONDS_1919_04_13_01 ? 32400 : (seconds >= SECONDS_1901_01_01_00 ? 28800 : 29143))))))))))))))))))))))))))));
        return zoneOffsetTotalSeconds;
    }

    public static long utcSeconds(int year, int month, int dom, int hour, int minute, int second) {
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long total = 365 * year + ((year + 3) / 4 - (year + 99) / 100 + (year + 399) / 400) + (367 * month - 362) / 12 + (dom - 1);
        if (month > 2) {
            boolean leapYear;
            --total;
            boolean bl = leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
            if (!leapYear) {
                --total;
            }
        }
        long epochDay = total - 719528L;
        return epochDay * 86400L + (long)(hour * 3600) + (long)(minute * 60) + (long)second;
    }
}

