/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public interface FieldReaderList<T, V>
extends FieldReader<T> {
    @Override
    default public Type getFieldType() {
        return List.class;
    }

    @Override
    default public Class getFieldClass() {
        return List.class;
    }

    @Override
    public Type getItemType();

    default public List<V> createList() {
        return new ArrayList();
    }

    @Override
    default public ObjectReader<V> getItemObjectReader(JSONReader.Context ctx) {
        return ctx.getObjectReader(this.getItemType());
    }

    @Override
    default public void readFieldValue(JSONReader jsonReader, T object) {
        JSONReader.Context context = jsonReader.getContext();
        if (jsonReader.isJSONB()) {
            int entryCnt = jsonReader.startArray();
            Object[] array = new Object[entryCnt];
            ObjectReader<V> itemObjectReader = this.getItemObjectReader(context);
            for (int i = 0; i < entryCnt; ++i) {
                ObjectReader autoTypeReader = jsonReader.checkAutoType(this.getItemClass(), this.getItemClassHash(), this.getFeatures());
                array[i] = autoTypeReader != null ? autoTypeReader.readJSONBObject(jsonReader, this.getFieldType(), this.getFieldName(), 0L) : itemObjectReader.readJSONBObject(jsonReader, this.getFieldType(), this.getFieldName(), 0L);
            }
            List<Object> list = Arrays.asList(array);
            this.accept(object, list);
            return;
        }
        if (jsonReader.current() == '[') {
            JSONReader.Context ctx = context;
            ObjectReader<V> itemObjectReader = this.getItemObjectReader(ctx);
            List<V> list = this.createList();
            jsonReader.next();
            while (!jsonReader.nextIfMatch(']')) {
                list.add(itemObjectReader.readObject(jsonReader, null, null, 0L));
                if (!jsonReader.nextIfMatch(',')) continue;
            }
            this.accept(object, list);
            jsonReader.nextIfMatch(',');
            return;
        }
        ObjectReader objectReader = this.getObjectReader(jsonReader);
        long features = this.getFeatures();
        Object value = jsonReader.isJSONB() ? objectReader.readJSONBObject(jsonReader, null, null, features) : objectReader.readObject(jsonReader, null, null, features);
        this.accept(object, value);
    }

    @Override
    default public Object readFieldValue(JSONReader jsonReader) {
        if (jsonReader.isJSONB()) {
            int entryCnt = jsonReader.startArray();
            Object[] array = new Object[entryCnt];
            ObjectReader<V> itemObjectReader = this.getItemObjectReader(jsonReader.getContext());
            for (int i = 0; i < entryCnt; ++i) {
                array[i] = itemObjectReader.readObject(jsonReader, null, null, 0L);
            }
            return Arrays.asList(array);
        }
        if (jsonReader.current() == '[') {
            JSONReader.Context ctx = jsonReader.getContext();
            ObjectReader<V> itemObjectReader = this.getItemObjectReader(ctx);
            List<V> list = this.createList();
            jsonReader.next();
            while (!jsonReader.nextIfMatch(']')) {
                list.add(itemObjectReader.readObject(jsonReader, null, null, 0L));
                if (!jsonReader.nextIfMatch(',')) continue;
            }
            jsonReader.nextIfMatch(',');
            return list;
        }
        if (jsonReader.isString()) {
            Function typeConvert;
            String str = jsonReader.readString();
            Type itemType = this.getItemType();
            if (itemType instanceof Class && Number.class.isAssignableFrom((Class)itemType) && (typeConvert = jsonReader.getContext().getProvider().getTypeConvert((Type)((Object)String.class), itemType)) != null) {
                List<V> list = this.createList();
                if (str.indexOf(44) != -1) {
                    String[] items;
                    for (String item : items = str.split(",")) {
                        Object converted = typeConvert.apply(item);
                        list.add(converted);
                    }
                }
                return list;
            }
        }
        throw new JSONException(jsonReader.info("TODO : " + this.getClass()));
    }

    @Override
    default public ObjectReader checkObjectAutoType(JSONReader jsonReader) {
        if (jsonReader.nextIfMatch((byte)-110)) {
            boolean isSupportAutoType;
            long typeHash = jsonReader.readTypeHashCode();
            long features = this.getFeatures();
            Class fieldClass = this.getFieldClass();
            JSONReader.Context context = jsonReader.getContext();
            JSONReader.AutoTypeBeforeHandler autoTypeFilter = context.getContextAutoTypeBeforeHandler();
            if (autoTypeFilter != null) {
                Class<?> filterClass = autoTypeFilter.apply(typeHash, fieldClass, features);
                if (filterClass == null) {
                    String typeName = jsonReader.getString();
                    filterClass = autoTypeFilter.apply(typeName, fieldClass, features);
                }
                if (filterClass != null) {
                    return context.getObjectReader(fieldClass);
                }
            }
            if (!(isSupportAutoType = jsonReader.isSupportAutoType(features))) {
                throw new JSONException(jsonReader.info("autoType not support input " + jsonReader.getString()));
            }
            ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
            if (autoTypeObjectReader == null) {
                String typeName = jsonReader.getString();
                autoTypeObjectReader = context.getObjectReaderAutoType(typeName, fieldClass, features);
            }
            if (autoTypeObjectReader instanceof ObjectReaderImplList) {
                ObjectReaderImplList listReader = (ObjectReaderImplList)autoTypeObjectReader;
                autoTypeObjectReader = new ObjectReaderImplList(this.getFieldType(), fieldClass, listReader.instanceType, this.getItemType(), listReader.builder);
            }
            if (autoTypeObjectReader == null) {
                throw new JSONException(jsonReader.info("auotype not support : " + jsonReader.getString()));
            }
            return autoTypeObjectReader;
        }
        return null;
    }
}

