/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel;

import com.alibaba.csp.sentinel.AsyncEntry;
import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.CtEntry;
import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.Sph;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.context.NullContext;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slotchain.MethodResourceWrapper;
import com.alibaba.csp.sentinel.slotchain.ProcessorSlot;
import com.alibaba.csp.sentinel.slotchain.ProcessorSlotChain;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slotchain.SlotChainProvider;
import com.alibaba.csp.sentinel.slotchain.StringResourceWrapper;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class CtSph
implements Sph {
    private static final Object[] OBJECTS0 = new Object[0];
    private static volatile Map<ResourceWrapper, ProcessorSlotChain> chainMap = new HashMap<ResourceWrapper, ProcessorSlotChain>();
    private static final Object LOCK = new Object();

    private AsyncEntry asyncEntryWithNoChain(ResourceWrapper resourceWrapper, Context context) {
        AsyncEntry entry = new AsyncEntry(resourceWrapper, null, context);
        entry.initAsyncContext();
        entry.cleanCurrentEntryInLocal();
        return entry;
    }

    private AsyncEntry asyncEntryWithPriorityInternal(ResourceWrapper resourceWrapper, int count, boolean prioritized, Object ... args) throws BlockException {
        Context context = ContextUtil.getContext();
        if (context instanceof NullContext) {
            return this.asyncEntryWithNoChain(resourceWrapper, context);
        }
        if (context == null) {
            context = MyContextUtil.myEnter("sentinel_default_context", "", resourceWrapper.getType());
        }
        if (!Constants.ON) {
            return this.asyncEntryWithNoChain(resourceWrapper, context);
        }
        ProcessorSlot<Object> chain = this.lookProcessChain(resourceWrapper);
        if (chain == null) {
            return this.asyncEntryWithNoChain(resourceWrapper, context);
        }
        AsyncEntry asyncEntry = new AsyncEntry(resourceWrapper, chain, context);
        try {
            chain.entry(context, resourceWrapper, null, count, prioritized, args);
            asyncEntry.initAsyncContext();
            asyncEntry.cleanCurrentEntryInLocal();
        }
        catch (BlockException e1) {
            asyncEntry.exitForContext(context, count, args);
            throw e1;
        }
        catch (Throwable e1) {
            RecordLog.warn("Sentinel unexpected exception in asyncEntryInternal", e1);
            asyncEntry.cleanCurrentEntryInLocal();
        }
        return asyncEntry;
    }

    private AsyncEntry asyncEntryInternal(ResourceWrapper resourceWrapper, int count, Object ... args) throws BlockException {
        return this.asyncEntryWithPriorityInternal(resourceWrapper, count, false, args);
    }

    private Entry entryWithPriority(ResourceWrapper resourceWrapper, int count, boolean prioritized, Object ... args) throws BlockException {
        Context context = ContextUtil.getContext();
        if (context instanceof NullContext) {
            return new CtEntry(resourceWrapper, null, context);
        }
        if (context == null) {
            context = MyContextUtil.myEnter("sentinel_default_context", "", resourceWrapper.getType());
        }
        if (!Constants.ON) {
            return new CtEntry(resourceWrapper, null, context);
        }
        ProcessorSlot<Object> chain = this.lookProcessChain(resourceWrapper);
        if (chain == null) {
            return new CtEntry(resourceWrapper, null, context);
        }
        CtEntry e = new CtEntry(resourceWrapper, chain, context);
        try {
            chain.entry(context, resourceWrapper, null, count, prioritized, args);
        }
        catch (BlockException e1) {
            ((Entry)e).exit(count, args);
            throw e1;
        }
        catch (Throwable e1) {
            RecordLog.info("Sentinel unexpected exception", e1);
        }
        return e;
    }

    public Entry entry(ResourceWrapper resourceWrapper, int count, Object ... args) throws BlockException {
        return this.entryWithPriority(resourceWrapper, count, false, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProcessorSlot<Object> lookProcessChain(ResourceWrapper resourceWrapper) {
        ProcessorSlotChain chain = chainMap.get(resourceWrapper);
        if (chain == null) {
            Object object = LOCK;
            synchronized (object) {
                chain = chainMap.get(resourceWrapper);
                if (chain == null) {
                    if (chainMap.size() >= 6000) {
                        return null;
                    }
                    chain = SlotChainProvider.newSlotChain();
                    HashMap<ResourceWrapper, ProcessorSlotChain> newMap = new HashMap<ResourceWrapper, ProcessorSlotChain>(chainMap.size() + 1);
                    newMap.putAll(chainMap);
                    newMap.put(resourceWrapper, chain);
                    chainMap = newMap;
                }
            }
        }
        return chain;
    }

    public static int entrySize() {
        return chainMap.size();
    }

    static void resetChainMap() {
        chainMap.clear();
    }

    static Map<ResourceWrapper, ProcessorSlotChain> getChainMap() {
        return chainMap;
    }

    @Override
    public Entry entry(String name) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, EntryType.OUT);
        return this.entry(resource, 1, OBJECTS0);
    }

    @Override
    public Entry entry(Method method) throws BlockException {
        MethodResourceWrapper resource = new MethodResourceWrapper(method, EntryType.OUT);
        return this.entry(resource, 1, OBJECTS0);
    }

    @Override
    public Entry entry(Method method, EntryType type) throws BlockException {
        MethodResourceWrapper resource = new MethodResourceWrapper(method, type);
        return this.entry(resource, 1, OBJECTS0);
    }

    @Override
    public Entry entry(String name, EntryType type) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, type);
        return this.entry(resource, 1, OBJECTS0);
    }

    @Override
    public Entry entry(Method method, EntryType type, int count) throws BlockException {
        MethodResourceWrapper resource = new MethodResourceWrapper(method, type);
        return this.entry(resource, count, OBJECTS0);
    }

    @Override
    public Entry entry(String name, EntryType type, int count) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, type);
        return this.entry(resource, count, OBJECTS0);
    }

    @Override
    public Entry entry(Method method, int count) throws BlockException {
        MethodResourceWrapper resource = new MethodResourceWrapper(method, EntryType.OUT);
        return this.entry(resource, count, OBJECTS0);
    }

    @Override
    public Entry entry(String name, int count) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, EntryType.OUT);
        return this.entry(resource, count, OBJECTS0);
    }

    @Override
    public Entry entry(Method method, EntryType type, int count, Object ... args) throws BlockException {
        MethodResourceWrapper resource = new MethodResourceWrapper(method, type);
        return this.entry(resource, count, args);
    }

    @Override
    public Entry entry(String name, EntryType type, int count, Object ... args) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, type);
        return this.entry(resource, count, args);
    }

    @Override
    public AsyncEntry asyncEntry(String name, EntryType type, int count, Object ... args) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, type);
        return this.asyncEntryInternal(resource, count, args);
    }

    @Override
    public Entry entryWithPriority(String name, EntryType type, int count, boolean prioritized) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, type);
        return this.entryWithPriority(resource, count, prioritized, new Object[0]);
    }

    @Override
    public Entry entryWithPriority(String name, EntryType type, int count, boolean prioritized, Object ... args) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, type);
        return this.entryWithPriority(resource, count, prioritized, args);
    }

    private static final class MyContextUtil
    extends ContextUtil {
        private MyContextUtil() {
        }

        static Context myEnter(String name, String origin, EntryType type) {
            return MyContextUtil.trueEnter(name, origin);
        }
    }
}

