/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

public enum TypeCode {
    OBJECT(Object.class),
    BOOLEAN(Boolean.TYPE),
    CHAR(Character.TYPE),
    BYTE(Byte.TYPE),
    SHORT(Short.TYPE),
    INT(Integer.TYPE),
    LONG(Long.TYPE),
    FLOAT(Float.TYPE),
    DOUBLE(Double.TYPE);

    private final Class<?> type;

    private TypeCode(Class<?> type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    public static TypeCode forName(String name) {
        for (TypeCode typeCode : TypeCode.values()) {
            if (!typeCode.name().equalsIgnoreCase(name)) continue;
            return typeCode;
        }
        return OBJECT;
    }

    public static TypeCode forClass(Class<?> clazz) {
        for (TypeCode typeCode : TypeCode.values()) {
            if (typeCode.getType() != clazz) continue;
            return typeCode;
        }
        return OBJECT;
    }
}

