/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.NamedBeanHolder;
import org.springframework.beans.factory.config.RuntimeBeanNameReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.ManagedArray;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.NullBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BeanDefinitionValueResolver {
    private final AbstractAutowireCapableBeanFactory beanFactory;
    private final String beanName;
    private final BeanDefinition beanDefinition;
    private final TypeConverter typeConverter;

    public BeanDefinitionValueResolver(AbstractAutowireCapableBeanFactory beanFactory, String beanName, BeanDefinition beanDefinition, TypeConverter typeConverter) {
        this.beanFactory = beanFactory;
        this.beanName = beanName;
        this.beanDefinition = beanDefinition;
        this.typeConverter = typeConverter;
    }

    public BeanDefinitionValueResolver(AbstractAutowireCapableBeanFactory beanFactory, String beanName, BeanDefinition beanDefinition) {
        this.beanFactory = beanFactory;
        this.beanName = beanName;
        this.beanDefinition = beanDefinition;
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl();
        beanFactory.initBeanWrapper(beanWrapper);
        this.typeConverter = beanWrapper;
    }

    public @Nullable Object resolveValueIfNecessary(Object argName, @Nullable Object value) {
        if (value instanceof RuntimeBeanReference) {
            RuntimeBeanReference ref = (RuntimeBeanReference)value;
            return this.resolveReference(argName, ref);
        }
        if (value instanceof RuntimeBeanNameReference) {
            RuntimeBeanNameReference ref = (RuntimeBeanNameReference)value;
            String refName = ref.getBeanName();
            if (!this.beanFactory.containsBean(refName = String.valueOf(this.doEvaluate(refName)))) {
                throw new BeanDefinitionStoreException("Invalid bean name '" + refName + "' in bean reference for " + String.valueOf(argName));
            }
            return refName;
        }
        if (value instanceof BeanDefinitionHolder) {
            BeanDefinitionHolder bdHolder = (BeanDefinitionHolder)value;
            return this.resolveInnerBean(bdHolder.getBeanName(), bdHolder.getBeanDefinition(), (name, mbd) -> this.resolveInnerBeanValue(argName, (String)name, (RootBeanDefinition)mbd));
        }
        if (value instanceof BeanDefinition) {
            BeanDefinition bd = (BeanDefinition)value;
            return this.resolveInnerBean(null, bd, (name, mbd) -> this.resolveInnerBeanValue(argName, (String)name, (RootBeanDefinition)mbd));
        }
        if (value instanceof DependencyDescriptor) {
            DependencyDescriptor dependencyDescriptor = (DependencyDescriptor)value;
            LinkedHashSet autowiredBeanNames = new LinkedHashSet(2);
            Object result = this.beanFactory.resolveDependency(dependencyDescriptor, this.beanName, autowiredBeanNames, this.typeConverter);
            for (String autowiredBeanName : autowiredBeanNames) {
                if (!this.beanFactory.containsBean(autowiredBeanName)) continue;
                this.beanFactory.registerDependentBean(autowiredBeanName, this.beanName);
            }
            return result;
        }
        if (value instanceof ManagedArray) {
            ManagedArray managedArray = (ManagedArray)value;
            Class<?> elementType = managedArray.resolvedElementType;
            if (elementType == null) {
                String elementTypeName = managedArray.getElementTypeName();
                if (StringUtils.hasText((String)elementTypeName)) {
                    try {
                        managedArray.resolvedElementType = elementType = ClassUtils.forName((String)elementTypeName, (ClassLoader)this.beanFactory.getBeanClassLoader());
                    }
                    catch (Throwable ex) {
                        throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Error resolving array type for " + String.valueOf(argName), ex);
                    }
                } else {
                    elementType = Object.class;
                }
            }
            return this.resolveManagedArray(argName, (List)value, elementType);
        }
        if (value instanceof ManagedList) {
            ManagedList managedList = (ManagedList)value;
            return this.resolveManagedList(argName, managedList);
        }
        if (value instanceof ManagedSet) {
            ManagedSet managedSet = (ManagedSet)value;
            return this.resolveManagedSet(argName, managedSet);
        }
        if (value instanceof ManagedMap) {
            ManagedMap managedMap = (ManagedMap)value;
            return this.resolveManagedMap(argName, managedMap);
        }
        if (value instanceof ManagedProperties) {
            ManagedProperties original = (ManagedProperties)value;
            Properties copy = new Properties();
            original.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(propKey, propValue) -> {
                TypedStringValue typedStringValue;
                if (propKey instanceof TypedStringValue) {
                    typedStringValue = (TypedStringValue)propKey;
                    propKey = this.evaluate(typedStringValue);
                }
                if (propValue instanceof TypedStringValue) {
                    typedStringValue = (TypedStringValue)propValue;
                    propValue = this.evaluate(typedStringValue);
                }
                if (propKey == null || propValue == null) {
                    throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Error converting Properties key/value pair for " + String.valueOf(argName) + ": resolved to null");
                }
                copy.put(propKey, propValue);
            }));
            return copy;
        }
        if (value instanceof TypedStringValue) {
            TypedStringValue typedStringValue = (TypedStringValue)value;
            Object valueObject = this.evaluate(typedStringValue);
            try {
                Class<?> resolvedTargetType = this.resolveTargetType(typedStringValue);
                if (resolvedTargetType != null) {
                    return this.typeConverter.convertIfNecessary(valueObject, resolvedTargetType);
                }
                return valueObject;
            }
            catch (Throwable ex) {
                throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Error converting typed String value for " + String.valueOf(argName), ex);
            }
        }
        if (value instanceof NullBean) {
            return null;
        }
        return this.evaluate(value);
    }

    public <T> T resolveInnerBean(@Nullable String innerBeanName, BeanDefinition innerBd, BiFunction<String, RootBeanDefinition, T> resolver) {
        String nameToUse = innerBeanName != null ? innerBeanName : "(inner bean)#" + ObjectUtils.getIdentityHexString((Object)innerBd);
        return resolver.apply(nameToUse, this.beanFactory.getMergedBeanDefinition(nameToUse, innerBd, this.beanDefinition));
    }

    protected @Nullable Object evaluate(TypedStringValue value) {
        Object result = this.doEvaluate(value.getValue());
        if (!ObjectUtils.nullSafeEquals((Object)result, (Object)value.getValue())) {
            value.setDynamic();
        }
        return result;
    }

    protected @Nullable Object evaluate(@Nullable Object value) {
        if (value instanceof String) {
            String str = (String)value;
            return this.doEvaluate(str);
        }
        if (value instanceof String[]) {
            String[] values = (String[])value;
            boolean actuallyResolved = false;
            @Nullable Object[] resolvedValues = new Object[values.length];
            for (int i2 = 0; i2 < values.length; ++i2) {
                String originalValue = values[i2];
                Object resolvedValue = this.doEvaluate(originalValue);
                if (resolvedValue != originalValue) {
                    actuallyResolved = true;
                }
                resolvedValues[i2] = resolvedValue;
            }
            return actuallyResolved ? resolvedValues : values;
        }
        return value;
    }

    private @Nullable Object doEvaluate(@Nullable String value) {
        return this.beanFactory.evaluateBeanDefinitionString(value, this.beanDefinition);
    }

    protected @Nullable Class<?> resolveTargetType(TypedStringValue value) throws ClassNotFoundException {
        if (value.hasTargetType()) {
            return value.getTargetType();
        }
        return value.resolveTargetType(this.beanFactory.getBeanClassLoader());
    }

    private @Nullable Object resolveReference(Object argName, RuntimeBeanReference ref) {
        try {
            Object bean2;
            Class<?> beanType = ref.getBeanType();
            String resolvedName = String.valueOf(this.doEvaluate(ref.getBeanName()));
            if (ref.isToParent()) {
                BeanFactory parent = this.beanFactory.getParentBeanFactory();
                if (parent == null) {
                    throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Cannot resolve reference to bean " + String.valueOf(ref) + " in parent factory: no parent factory available");
                }
                bean2 = beanType != null ? (parent.containsBean(resolvedName) ? parent.getBean(resolvedName, beanType) : parent.getBean(beanType)) : parent.getBean(resolvedName);
            } else {
                if (beanType != null) {
                    if (this.beanFactory.containsBean(resolvedName)) {
                        bean2 = this.beanFactory.getBean(resolvedName, beanType);
                    } else {
                        NamedBeanHolder namedBean = this.beanFactory.resolveNamedBean(beanType);
                        bean2 = namedBean.getBeanInstance();
                        resolvedName = namedBean.getBeanName();
                    }
                } else {
                    bean2 = this.beanFactory.getBean(resolvedName);
                }
                this.beanFactory.registerDependentBean(resolvedName, this.beanName);
            }
            if (bean2 instanceof NullBean) {
                bean2 = null;
            }
            return bean2;
        }
        catch (BeansException ex) {
            throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Cannot resolve reference to bean '" + ref.getBeanName() + "' while setting " + String.valueOf(argName), (Throwable)((Object)ex));
        }
    }

    private @Nullable Object resolveInnerBeanValue(Object argName, String innerBeanName, RootBeanDefinition mbd) {
        try {
            Object innerBean;
            String actualInnerBeanName = innerBeanName;
            if (mbd.isSingleton()) {
                actualInnerBeanName = this.adaptInnerBeanName(innerBeanName);
            }
            this.beanFactory.registerContainedBean(actualInnerBeanName, this.beanName);
            String[] dependsOn = mbd.getDependsOn();
            if (dependsOn != null) {
                for (String dependsOnBean : dependsOn) {
                    this.beanFactory.registerDependentBean(dependsOnBean, actualInnerBeanName);
                    this.beanFactory.getBean(dependsOnBean);
                }
            }
            if ((innerBean = this.beanFactory.createBean(actualInnerBeanName, mbd, null)) instanceof FactoryBean) {
                FactoryBean factoryBean = (FactoryBean)innerBean;
                boolean synthetic = mbd.isSynthetic();
                innerBean = this.beanFactory.getObjectFromFactoryBean(factoryBean, null, actualInnerBeanName, !synthetic);
            }
            if (innerBean instanceof NullBean) {
                innerBean = null;
            }
            return innerBean;
        }
        catch (BeansException ex) {
            throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Cannot create inner bean '" + innerBeanName + "' " + (String)(mbd.getBeanClassName() != null ? "of type [" + mbd.getBeanClassName() + "] " : "") + "while setting " + String.valueOf(argName), (Throwable)((Object)ex));
        }
    }

    private String adaptInnerBeanName(String innerBeanName) {
        Object actualInnerBeanName = innerBeanName;
        int counter = 0;
        String prefix = innerBeanName + "#";
        while (this.beanFactory.isBeanNameInUse((String)actualInnerBeanName)) {
            actualInnerBeanName = prefix + ++counter;
        }
        return actualInnerBeanName;
    }

    private Object resolveManagedArray(Object argName, List<?> ml, Class<?> elementType) {
        Object resolved = Array.newInstance(elementType, ml.size());
        for (int i2 = 0; i2 < ml.size(); ++i2) {
            Array.set(resolved, i2, this.resolveValueIfNecessary(new KeyedArgName(argName, i2), ml.get(i2)));
        }
        return resolved;
    }

    private List<?> resolveManagedList(Object argName, List<?> ml) {
        ArrayList<Object> resolved = new ArrayList<Object>(ml.size());
        for (int i2 = 0; i2 < ml.size(); ++i2) {
            resolved.add(this.resolveValueIfNecessary(new KeyedArgName(argName, i2), ml.get(i2)));
        }
        return resolved;
    }

    private Set<?> resolveManagedSet(Object argName, Set<?> ms) {
        LinkedHashSet resolved = CollectionUtils.newLinkedHashSet((int)ms.size());
        int i2 = 0;
        for (Object m : ms) {
            resolved.add(this.resolveValueIfNecessary(new KeyedArgName(argName, i2), m));
            ++i2;
        }
        return resolved;
    }

    private Map<?, ?> resolveManagedMap(Object argName, Map<?, ?> mm) {
        LinkedHashMap resolved = CollectionUtils.newLinkedHashMap((int)mm.size());
        mm.forEach((key, value) -> {
            Object resolvedKey = this.resolveValueIfNecessary(argName, key);
            Object resolvedValue = this.resolveValueIfNecessary(new KeyedArgName(argName, key), value);
            resolved.put(resolvedKey, resolvedValue);
        });
        return resolved;
    }

    private static class KeyedArgName {
        private final Object argName;
        private final Object key;

        public KeyedArgName(Object argName, Object key) {
            this.argName = argName;
            this.key = key;
        }

        public String toString() {
            return String.valueOf(this.argName) + " with key [" + String.valueOf(this.key) + "]";
        }
    }
}

