/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.aot;

import java.util.Set;
import org.springframework.ai.chat.messages.AbstractMessage;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class SpringAiCoreRuntimeHints
implements RuntimeHintsRegistrar {
    public void registerHints(@NonNull RuntimeHints hints, @Nullable ClassLoader classLoader) {
        Set<Class<SystemMessage>> chatTypes = Set.of(AbstractMessage.class, AssistantMessage.class, ToolResponseMessage.class, Message.class, MessageType.class, UserMessage.class, SystemMessage.class);
        for (Class<SystemMessage> c : chatTypes) {
            hints.reflection().registerType(c, new MemberCategory[0]);
        }
        Set<Class<ToolDefinition>> toolTypes = Set.of(ToolCallback.class, ToolDefinition.class);
        for (Class<ToolDefinition> c : toolTypes) {
            hints.reflection().registerType(c, new MemberCategory[0]);
        }
        for (String r : Set.of("embedding/embedding-model-dimensions.properties")) {
            hints.resources().registerResource((Resource)new ClassPathResource(r));
        }
    }
}

