/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.window;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;

public class Dimensions {
    public static final Pattern DIMENSIONS_PATTERN = Pattern.compile("([0-9]+)x([0-9]+)");
    private String dimensions;
    private int width;
    private int height;

    public Dimensions(WebDriverConfiguration configuration) {
        this.dimensions = this.getDimensions(configuration);
        if (this.dimensions != null) {
            this.setDimensions(this.dimensions);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isFullscreenSet() {
        return this.dimensions != null && (this.dimensions.equals("full") || this.dimensions.equals("fullscreen") || this.dimensions.equals("max"));
    }

    public boolean areDimensionsPositive() {
        return this.width > 0 && this.height > 0;
    }

    private String getDimensions(WebDriverConfiguration configuration) {
        String dimensions = null;
        if (configuration.getDimensions() != null) {
            dimensions = configuration.getDimensions().toLowerCase().trim();
        }
        return dimensions;
    }

    private void setDimensions(String dimensions) {
        Matcher m = DIMENSIONS_PATTERN.matcher(dimensions);
        if (m.matches()) {
            this.width = Integer.valueOf(m.group(1));
            this.height = Integer.valueOf(m.group(2));
        }
    }
}

