/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.binary.handler.EdgeDriverBinaryHandler;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class EdgeDriverFactory
extends AbstractWebDriverFactory<EdgeDriver>
implements Configurator<EdgeDriver, WebDriverConfiguration>,
Instantiator<EdgeDriver, WebDriverConfiguration>,
Destructor<EdgeDriver> {
    private static final String BROWSER_CAPABILITIES = new BrowserCapabilitiesList.Edge().getReadableName();

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(EdgeDriver instance) {
        instance.quit();
    }

    public EdgeDriver createInstance(WebDriverConfiguration configuration) {
        Capabilities edgeCapabilities = this.getCapabilities(configuration, true);
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{Capabilities.class}, new Object[]{edgeCapabilities}, EdgeDriver.class);
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_CAPABILITIES;
    }

    public Capabilities getCapabilities(WebDriverConfiguration configuration, boolean performValidations) {
        DesiredCapabilities capabilities = new DesiredCapabilities(configuration.getCapabilities());
        capabilities.setPlatform(Platform.ANY);
        capabilities.setBrowserName(DesiredCapabilities.edge().getBrowserName());
        new EdgeDriverBinaryHandler(capabilities).checkAndSetBinary(true);
        return capabilities;
    }
}

