/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;
import org.infinispan.query.core.impl.Log;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
@Scope(value=Scopes.GLOBAL)
public final class QueryCache {
    private static final Log log = (Log)LogFactory.getLog(QueryCache.class, Log.class);
    public static final String QUERY_CACHE_NAME = "___query_cache";
    private static final long MAX_ENTRIES = 200L;
    private static final long ENTRY_LIFESPAN = 300L;
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    InternalCacheRegistry internalCacheRegistry;
    private volatile Cache<QueryCacheKey, Object> lazyCache;

    public <T> T get(String cacheName, String queryString, List<FieldAccumulator> accumulators, Object queryTypeDiscriminator, QueryCreator<T> queryCreator) {
        QueryCacheKey key = new QueryCacheKey(cacheName, queryString, accumulators, queryTypeDiscriminator);
        return this.getOptionalCache(true).map(c -> c.computeIfAbsent((Object)key, (SerializableFunction & Serializable)k -> queryCreator.create(k.queryString, k.accumulators))).orElse(null);
    }

    public void clear() {
        log.debug("Clearing query cache for all caches");
        this.getOptionalCache(false).ifPresent(Cache::clear);
    }

    public void clear(String cacheName) {
        log.debugf("Clearing query cache for cache %s", cacheName);
        this.getOptionalCache(false).ifPresent(c -> c.keySet().removeIf(k -> k.cacheName.equals(cacheName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Cache<QueryCacheKey, Object>> getOptionalCache(boolean createIfAbsent) {
        Cache<QueryCacheKey, Object> cache = this.lazyCache;
        if (createIfAbsent && cache == null) {
            QueryCache queryCache = this;
            synchronized (queryCache) {
                if (this.lazyCache == null) {
                    this.internalCacheRegistry.registerInternalCache(QUERY_CACHE_NAME, this.getQueryCacheConfig().build(), EnumSet.noneOf(InternalCacheRegistry.Flag.class));
                    this.lazyCache = this.cacheManager.getCache(QUERY_CACHE_NAME);
                }
                cache = this.lazyCache;
            }
        }
        return Optional.ofNullable(cache);
    }

    private ConfigurationBuilder getQueryCacheConfig() {
        ConfigurationBuilder cfgBuilder = new ConfigurationBuilder();
        cfgBuilder.clustering().cacheMode(CacheMode.LOCAL).transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL).expiration().maxIdle(300L, TimeUnit.SECONDS).memory().maxCount(200L);
        return cfgBuilder;
    }

    private static final class QueryCacheKey {
        final String cacheName;
        final String queryString;
        final List<FieldAccumulator> accumulators;
        final Object queryTypeDiscriminator;

        QueryCacheKey(String cacheName, String queryString, List<FieldAccumulator> accumulators, Object queryTypeDiscriminator) {
            this.cacheName = cacheName;
            this.queryString = queryString;
            this.accumulators = accumulators;
            this.queryTypeDiscriminator = queryTypeDiscriminator;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof QueryCacheKey)) {
                return false;
            }
            QueryCacheKey other = (QueryCacheKey)obj;
            return this.cacheName.equals(other.cacheName) && this.queryString.equals(other.queryString) && (this.accumulators != null ? this.accumulators.equals(other.accumulators) : other.accumulators == null) && this.queryTypeDiscriminator.equals(other.queryTypeDiscriminator);
        }

        public int hashCode() {
            int result = this.cacheName.hashCode();
            result = 31 * result + this.queryString.hashCode();
            result = 31 * result + (this.accumulators != null ? this.accumulators.hashCode() : 0);
            result = 31 * result + this.queryTypeDiscriminator.hashCode();
            return result;
        }

        public String toString() {
            return "QueryCacheKey{cacheName='" + this.cacheName + '\'' + ", queryString='" + this.queryString + '\'' + ", accumulators=" + this.accumulators + ", queryTypeDiscriminator=" + this.queryTypeDiscriminator + '}';
        }
    }

    @FunctionalInterface
    public static interface QueryCreator<Q> {
        public Q create(String var1, List<FieldAccumulator> var2);
    }
}

