/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.BaseStream;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheStream;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.filter.CacheFilters;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.query.core.impl.BaseEmbeddedQuery;
import org.infinispan.query.core.impl.QueryEngine;
import org.infinispan.query.core.impl.eventfilter.IckleFilterAndConverter;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.dsl.QueryFactory;

public final class EmbeddedQuery<T>
extends BaseEmbeddedQuery<T> {
    private final QueryEngine<?> queryEngine;
    private IckleFilterAndConverter<?, ?> filter;

    public EmbeddedQuery(QueryEngine<?> queryEngine, QueryFactory queryFactory, AdvancedCache<?, ?> cache, String queryString, Map<String, Object> namedParameters, String[] projection, long startOffset, int maxResults, LocalQueryStatistics queryStatistics) {
        super(queryFactory, cache, queryString, namedParameters, projection, startOffset, maxResults, queryStatistics);
        this.queryEngine = queryEngine;
    }

    @Override
    public void resetQuery() {
        super.resetQuery();
        this.filter = null;
    }

    @Override
    protected void recordQuery(Long time) {
        this.queryStatistics.nonIndexedQueryExecuted(this.queryString, time);
    }

    private IckleFilterAndConverter<?, ?> createFilter() {
        if (this.filter == null) {
            this.filter = this.queryEngine.createAndWireFilter(this.queryString, this.namedParameters);
            this.filter.getObjectFilter();
        }
        return this.filter;
    }

    @Override
    protected Comparator<Comparable<?>[]> getComparator() {
        return this.createFilter().getObjectFilter().getComparator();
    }

    @Override
    protected CloseableIterator<ObjectFilter.FilterResult> getInternalIterator() {
        IckleFilterAndConverter<?, ?> ickleFilter = this.createFilter();
        CacheStream entryStream = this.cache.cacheEntrySet().stream();
        if (this.timeout > 0L) {
            entryStream = entryStream.timeout(this.timeout, TimeUnit.NANOSECONDS);
        }
        CacheStream resultStream = CacheFilters.filterAndConvertToValue((CacheStream)entryStream, ickleFilter);
        if (this.timeout > 0L) {
            resultStream = resultStream.timeout(this.timeout, TimeUnit.NANOSECONDS);
        }
        return Closeables.iterator((BaseStream)resultStream);
    }

    @Override
    public String toString() {
        return "EmbeddedQuery{queryString=" + this.queryString + ", namedParameters=" + this.namedParameters + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + ", timeout=" + this.timeout + '}';
    }
}

