/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.service;

import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.system.authorization.api.event.UserModifiedEvent;
import org.hswebframework.web.system.authorization.api.event.UserStateChangedEvent;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RemoveUserTokenWhenUserDisabled {
    private static final Logger log = LoggerFactory.getLogger(RemoveUserTokenWhenUserDisabled.class);
    private final UserTokenManager userTokenManager;

    @EventListener
    public void handleStateChangeEvent(UserModifiedEvent event) {
        if (event.getUserEntity().getStatus() != null && event.getUserEntity().getStatus() != 1) {
            event.async((Publisher)Mono.just((Object)event.getUserEntity().getId()).flatMap(arg_0 -> ((UserTokenManager)this.userTokenManager).signOutByUserId(arg_0)));
        }
    }

    @EventListener
    public void handleStateChangeEvent(UserStateChangedEvent event) {
        if (event.getState() != 1) {
            event.async((Publisher)Flux.fromIterable((Iterable)event.getUserIdList()).flatMap(arg_0 -> ((UserTokenManager)this.userTokenManager).signOutByUserId(arg_0)));
        }
    }

    public RemoveUserTokenWhenUserDisabled(UserTokenManager userTokenManager) {
        this.userTokenManager = userTokenManager;
    }
}

