/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.oauth2.server.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.hswebframework.web.oauth2.server.ScopePredicate;
import org.springframework.util.StringUtils;

public class OAuth2ScopeUtils {
    public static ScopePredicate createScopePredicate(String scopeStr) {
        if (StringUtils.isEmpty((Object)scopeStr)) {
            return (permission, action) -> false;
        }
        String[] scopes = scopeStr.split("[ ,\n]");
        HashMap<String, Set> actions = new HashMap<String, Set>();
        for (String scope : scopes) {
            String[] permissions = scope.split("[:]");
            String per = permissions[0];
            Set acts = actions.computeIfAbsent(per, k -> new HashSet());
            acts.addAll(Arrays.asList(permissions).subList(1, permissions.length));
        }
        if (actions.containsKey("*")) {
            return (permission, action) -> true;
        }
        return (permission, action) -> Optional.ofNullable(actions.get(permission)).map(acts -> action.length == 0 || acts.contains("*") || acts.containsAll(Arrays.asList(action))).orElse(false);
    }
}

