/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.oauth2.server.impl;

import java.time.Duration;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.token.AuthenticationUserToken;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.authorization.token.redis.RedisUserTokenManager;
import org.hswebframework.web.oauth2.ErrorType;
import org.hswebframework.web.oauth2.OAuth2Exception;
import org.hswebframework.web.oauth2.server.AccessToken;
import org.hswebframework.web.oauth2.server.AccessTokenManager;
import org.hswebframework.web.oauth2.server.impl.RedisAccessToken;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedisAccessTokenManager
implements AccessTokenManager {
    private final ReactiveRedisOperations<String, RedisAccessToken> tokenRedis;
    private final UserTokenManager userTokenManager;
    private int tokenExpireIn = 7200;
    private int refreshExpireIn = 2592000;

    public RedisAccessTokenManager(ReactiveRedisOperations<String, RedisAccessToken> tokenRedis, UserTokenManager userTokenManager) {
        this.tokenRedis = tokenRedis;
        this.userTokenManager = userTokenManager;
    }

    public RedisAccessTokenManager(ReactiveRedisConnectionFactory connectionFactory) {
        ReactiveRedisTemplate redis;
        this.tokenRedis = redis = new ReactiveRedisTemplate(connectionFactory, RedisSerializationContext.newSerializationContext().key(RedisSerializer.string()).value(RedisSerializer.java()).hashKey(RedisSerializer.string()).hashValue(RedisSerializer.java()).build());
        this.userTokenManager = new RedisUserTokenManager((ReactiveRedisOperations)redis);
    }

    @Override
    public Mono<Authentication> getAuthenticationByToken(String accessToken) {
        return this.userTokenManager.getByToken(accessToken).filter(token -> token instanceof AuthenticationUserToken).map(t -> ((AuthenticationUserToken)t).getAuthentication());
    }

    private String createTokenRedisKey(String clientId, String token) {
        return "oauth2-token:" + clientId + ":" + token;
    }

    private String createUserTokenRedisKey(RedisAccessToken token) {
        return this.createUserTokenRedisKey(token.getClientId(), token.getAuthentication().getUser().getId());
    }

    private String createUserTokenRedisKey(String clientId, String userId) {
        return "oauth2-user-tokens:" + clientId + ":" + userId;
    }

    private String createRefreshTokenRedisKey(String clientId, String token) {
        return "oauth2-refresh-token:" + clientId + ":" + token;
    }

    private String createSingletonTokenRedisKey(String clientId) {
        return "oauth2-" + clientId + "-token";
    }

    private Mono<RedisAccessToken> doCreateAccessToken(String clientId, Authentication authentication, boolean singleton) {
        String token = DigestUtils.md5Hex((String)UUID.randomUUID().toString());
        String refresh = DigestUtils.md5Hex((String)UUID.randomUUID().toString());
        RedisAccessToken accessToken = new RedisAccessToken(clientId, token, refresh, System.currentTimeMillis(), authentication, singleton);
        return this.storeToken(accessToken).thenReturn((Object)accessToken);
    }

    private Mono<Void> storeAuthToken(RedisAccessToken token) {
        if (token.isSingleton()) {
            return this.userTokenManager.signIn(token.getAccessToken(), this.createTokenType(token.getClientId()), token.getAuthentication().getUser().getId(), (long)this.tokenExpireIn * 1000L).then();
        }
        return this.userTokenManager.signIn(token.getAccessToken(), this.createTokenType(token.getClientId()), token.getAuthentication().getUser().getId(), (long)this.tokenExpireIn * 1000L, token.getAuthentication()).then();
    }

    private Mono<Void> storeToken(RedisAccessToken token) {
        return Flux.merge((Publisher[])new Publisher[]{this.storeAuthToken(token), this.tokenRedis.opsForValue().set((Object)this.createUserTokenRedisKey(token), (Object)token, Duration.ofSeconds(this.tokenExpireIn)), this.tokenRedis.opsForValue().set((Object)this.createTokenRedisKey(token.getClientId(), token.getAccessToken()), (Object)token, Duration.ofSeconds(this.tokenExpireIn)), this.tokenRedis.opsForValue().set((Object)this.createRefreshTokenRedisKey(token.getClientId(), token.getRefreshToken()), (Object)token, Duration.ofSeconds(this.refreshExpireIn))}).then();
    }

    private Mono<AccessToken> doCreateSingletonAccessToken(String clientId, Authentication authentication) {
        String redisKey = this.createSingletonTokenRedisKey(clientId);
        return this.tokenRedis.opsForValue().get((Object)redisKey).flatMap(token -> this.tokenRedis.getExpire((Object)redisKey).map(duration -> token.toAccessToken((int)(duration.toMillis() / 1000L)))).switchIfEmpty(Mono.defer(() -> this.doCreateAccessToken(clientId, authentication, true).flatMap(redisAccessToken -> this.tokenRedis.opsForValue().set((Object)redisKey, redisAccessToken, Duration.ofSeconds(this.tokenExpireIn)).thenReturn((Object)redisAccessToken.toAccessToken(this.tokenExpireIn)))));
    }

    @Override
    public Mono<AccessToken> createAccessToken(String clientId, Authentication authentication, boolean singleton) {
        return singleton ? this.doCreateSingletonAccessToken(clientId, authentication) : this.doCreateAccessToken(clientId, authentication, false).map(token -> token.toAccessToken(this.tokenExpireIn));
    }

    @Override
    public Mono<AccessToken> refreshAccessToken(String clientId, String refreshToken) {
        String redisKey = this.createRefreshTokenRedisKey(clientId, refreshToken);
        return this.tokenRedis.opsForValue().get((Object)redisKey).switchIfEmpty(Mono.error(() -> new OAuth2Exception(ErrorType.EXPIRED_REFRESH_TOKEN))).flatMap(token -> {
            if (!token.getClientId().equals(clientId)) {
                return Mono.error((Throwable)((Object)new OAuth2Exception(ErrorType.ILLEGAL_CLIENT_ID)));
            }
            String accessToken = DigestUtils.md5Hex((String)UUID.randomUUID().toString());
            token.setAccessToken(accessToken);
            token.setCreateTime(System.currentTimeMillis());
            return ((Mono)this.storeToken((RedisAccessToken)token).as(result -> {
                if (token.isSingleton()) {
                    return this.userTokenManager.signOutByToken(token.getAccessToken()).then(this.tokenRedis.opsForValue().set((Object)this.createSingletonTokenRedisKey(clientId), token, Duration.ofSeconds(this.tokenExpireIn)).then(result));
                }
                return result;
            })).thenReturn((Object)token.toAccessToken(this.tokenExpireIn));
        });
    }

    @Override
    public Mono<Void> removeToken(String clientId, String token) {
        return Flux.merge((Publisher[])new Publisher[]{this.userTokenManager.signOutByToken(token), this.tokenRedis.delete((Object[])new String[]{this.createSingletonTokenRedisKey(clientId)}), this.tokenRedis.delete((Object[])new String[]{this.createTokenRedisKey(clientId, token)})}).then();
    }

    @Override
    public Mono<Void> cancelGrant(String clientId, String userId) {
        Mono removeRefreshToken = this.tokenRedis.opsForValue().get((Object)this.createUserTokenRedisKey(clientId, userId)).flatMap(t -> this.tokenRedis.opsForValue().delete((Object)this.createRefreshTokenRedisKey(t.getClientId(), t.getRefreshToken()))).then();
        Mono removeAccessToken = this.userTokenManager.getByUserId(userId).flatMap(token -> {
            if (!this.createTokenType(clientId).equals(token.getType())) {
                return Mono.empty();
            }
            return this.tokenRedis.opsForValue().get((Object)this.createTokenRedisKey(clientId, token.getToken())).flatMap(t -> this.tokenRedis.delete((Object[])new String[]{this.createTokenRedisKey(t.getClientId(), t.getAccessToken())}).then(this.tokenRedis.opsForValue().delete((Object)this.createRefreshTokenRedisKey(t.getClientId(), t.getRefreshToken())))).then(this.userTokenManager.signOutByToken(token.getToken()));
        }).then();
        return Flux.merge((Publisher[])new Publisher[]{removeRefreshToken, removeAccessToken}).then();
    }

    private String createTokenType(String clientId) {
        return "oauth2-" + clientId;
    }

    public int getTokenExpireIn() {
        return this.tokenExpireIn;
    }

    public void setTokenExpireIn(int tokenExpireIn) {
        this.tokenExpireIn = tokenExpireIn;
    }

    public int getRefreshExpireIn() {
        return this.refreshExpireIn;
    }

    public void setRefreshExpireIn(int refreshExpireIn) {
        this.refreshExpireIn = refreshExpireIn;
    }
}

