/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.oauth2.server.credential;

import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.ReactiveAuthenticationManager;
import org.hswebframework.web.oauth2.server.AccessToken;
import org.hswebframework.web.oauth2.server.AccessTokenManager;
import org.hswebframework.web.oauth2.server.OAuth2Client;
import org.hswebframework.web.oauth2.server.credential.ClientCredentialGranter;
import org.hswebframework.web.oauth2.server.credential.ClientCredentialRequest;
import org.hswebframework.web.oauth2.server.event.OAuth2GrantedEvent;
import org.springframework.context.ApplicationEventPublisher;
import reactor.core.publisher.Mono;

public class DefaultClientCredentialGranter
implements ClientCredentialGranter {
    private final ReactiveAuthenticationManager authenticationManager;
    private final AccessTokenManager accessTokenManager;
    private final ApplicationEventPublisher eventPublisher;

    @Override
    public Mono<AccessToken> requestToken(ClientCredentialRequest request) {
        OAuth2Client client = request.getClient();
        return this.authenticationManager.getByUserId(client.getUserId()).flatMap(auth -> this.accessTokenManager.createAccessToken(client.getClientId(), (Authentication)auth, true).flatMap(token -> new OAuth2GrantedEvent(client, (AccessToken)token, (Authentication)auth, "*", "client_credentials", request.getParameters()).publish(this.eventPublisher).onErrorResume(err -> this.accessTokenManager.removeToken(client.getClientId(), token.getAccessToken()).then(Mono.error((Throwable)err))).thenReturn(token)));
    }

    public DefaultClientCredentialGranter(ReactiveAuthenticationManager authenticationManager, AccessTokenManager accessTokenManager, ApplicationEventPublisher eventPublisher) {
        this.authenticationManager = authenticationManager;
        this.accessTokenManager = accessTokenManager;
        this.eventPublisher = eventPublisher;
    }
}

