/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.oauth2.server.auth;

import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.ReactiveAuthenticationSupplier;
import org.hswebframework.web.authorization.basic.web.ReactiveUserTokenParser;
import org.hswebframework.web.authorization.token.ParsedToken;
import org.hswebframework.web.oauth2.server.AccessTokenManager;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ReactiveOAuth2AccessTokenParser
implements ReactiveUserTokenParser,
ReactiveAuthenticationSupplier {
    private final AccessTokenManager accessTokenManager;

    public Mono<ParsedToken> parseToken(ServerWebExchange exchange) {
        String[] typeAndToken;
        String token = (String)exchange.getRequest().getQueryParams().getFirst((Object)"access_token");
        if (StringUtils.isEmpty((Object)token) && StringUtils.hasText((String)(token = exchange.getRequest().getHeaders().getFirst("Authorization"))) && (typeAndToken = token.split("[ ]")).length == 2 && typeAndToken[0].equalsIgnoreCase("bearer")) {
            token = typeAndToken[1];
        }
        if (StringUtils.hasText((String)token)) {
            return Mono.just((Object)ParsedToken.of((String)"oauth2", (String)token));
        }
        return Mono.empty();
    }

    public Mono<Authentication> get(String userId) {
        return Mono.empty();
    }

    public Mono<Authentication> get() {
        return Mono.deferWithContext(context -> context.getOrEmpty(ParsedToken.class).filter(token -> "oauth2".equals(token.getType())).map(t -> this.accessTokenManager.getAuthenticationByToken(t.getToken())).orElse(Mono.empty()));
    }

    public ReactiveOAuth2AccessTokenParser(AccessTokenManager accessTokenManager) {
        this.accessTokenManager = accessTokenManager;
    }
}

