/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.setting;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Optional;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.authorization.setting.SettingValueHolder;
import org.hswebframework.web.authorization.setting.UserSettingPermission;
import org.hswebframework.web.dict.EnumDict;

public class StringSourceSettingHolder
implements SettingValueHolder {
    private String value;
    private UserSettingPermission permission;

    public static SettingValueHolder of(String value, UserSettingPermission permission) {
        if (value == null) {
            return SettingValueHolder.NULL;
        }
        return new StringSourceSettingHolder(value, permission);
    }

    @Override
    public <T> Optional<List<T>> asList(Class<T> t) {
        return this.getNativeValue().map(v -> JSON.parseArray((String)v, (Class)t));
    }

    protected <T> T convert(String value, Class<T> t) {
        if (t.isEnum()) {
            T val;
            if (EnumDict.class.isAssignableFrom(t) && null != (val = EnumDict.find(t, (Object)value).orElse(null))) {
                return val;
            }
            for (T enumConstant : t.getEnumConstants()) {
                if (!((Enum)enumConstant).name().equalsIgnoreCase(value)) continue;
                return enumConstant;
            }
        }
        return (T)JSON.parseObject((String)value, t);
    }

    @Override
    public <T> Optional<T> as(Class<T> t) {
        if (t == String.class) {
            return this.asString();
        }
        if (Long.class == t || Long.TYPE == t) {
            return this.asLong();
        }
        if (Integer.class == t || Integer.TYPE == t) {
            return this.asInt();
        }
        if (Double.class == t || Double.TYPE == t) {
            return this.asDouble();
        }
        return this.getNativeValue().map(v -> this.convert((String)v, t));
    }

    @Override
    public Optional<String> asString() {
        return this.getNativeValue();
    }

    @Override
    public Optional<Long> asLong() {
        return this.getNativeValue().map(StringUtils::toLong);
    }

    @Override
    public Optional<Integer> asInt() {
        return this.getNativeValue().map(StringUtils::toInt);
    }

    @Override
    public Optional<Double> asDouble() {
        return this.getNativeValue().map(StringUtils::toDouble);
    }

    private Optional<String> getNativeValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public Optional<Object> getValue() {
        return Optional.ofNullable(this.value);
    }

    public StringSourceSettingHolder(String value, UserSettingPermission permission) {
        this.value = value;
        this.permission = permission;
    }

    @Override
    public UserSettingPermission getPermission() {
        return this.permission;
    }
}

