/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.events;

import java.util.Optional;
import java.util.function.Function;
import org.hswebframework.web.authorization.events.AuthorizationEvent;
import org.hswebframework.web.event.DefaultAsyncEvent;

public abstract class AbstractAuthorizationEvent
extends DefaultAsyncEvent
implements AuthorizationEvent {
    private static final long serialVersionUID = -3027505108916079214L;
    protected String username;
    protected String password;
    private final transient Function<String, Object> parameterGetter;

    public AbstractAuthorizationEvent(String username, String password, Function<String, Object> parameterGetter) {
        if (username == null || password == null || parameterGetter == null) {
            throw new NullPointerException();
        }
        this.username = username;
        this.password = password;
        this.parameterGetter = parameterGetter;
    }

    public <T> Optional<T> getParameter(String name) {
        return Optional.ofNullable(this.parameterGetter.apply(name));
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

