/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.ReactiveAuthenticationSupplier;
import org.hswebframework.web.authorization.simple.SimpleAuthentication;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ReactiveAuthenticationHolder {
    private static final List<ReactiveAuthenticationSupplier> suppliers = new CopyOnWriteArrayList<ReactiveAuthenticationSupplier>();

    private static Mono<Authentication> get(Function<ReactiveAuthenticationSupplier, Mono<Authentication>> function) {
        return Flux.merge((Iterable)suppliers.stream().map(function).collect(Collectors.toList())).collectList().filter(CollectionUtils::isNotEmpty).map(all -> {
            if (all.size() == 1) {
                return (Authentication)all.get(0);
            }
            SimpleAuthentication authentication = new SimpleAuthentication();
            for (Authentication auth : all) {
                authentication.merge(auth);
            }
            return authentication;
        });
    }

    public static Mono<Authentication> get() {
        return ReactiveAuthenticationHolder.get(Supplier::get);
    }

    public static Mono<Authentication> get(String userId) {
        return ReactiveAuthenticationHolder.get((ReactiveAuthenticationSupplier supplier) -> supplier.get(userId));
    }

    public static void addSupplier(ReactiveAuthenticationSupplier supplier) {
        suppliers.add(supplier);
    }

    public static void setSupplier(ReactiveAuthenticationSupplier supplier) {
        suppliers.clear();
        suppliers.add(supplier);
    }
}

