/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.PartitionManager;
import org.drools.spi.PropagationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionTaskManager {
    protected static transient Logger logger = LoggerFactory.getLogger(PartitionTaskManager.class);
    private PartitionTask task = null;

    public PartitionTaskManager(PartitionManager manager, InternalWorkingMemory workingMemory) {
        this.task = new PartitionTask(manager, workingMemory);
    }

    public boolean enqueue(Action action) {
        return this.task.enqueue(action);
    }

    private static class YieldAction
    implements Action {
        public static final YieldAction INSTANCE = new YieldAction();

        private YieldAction() {
        }

        public void execute(InternalWorkingMemory workingMemory) {
        }

        public int getPriority() {
            return 0;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public int compareTo(Action o) {
            return this.getPriority() - o.getPriority();
        }
    }

    public static class LeftTupleRetractAction
    extends LeftTupleAction {
        public LeftTupleRetractAction() {
        }

        public LeftTupleRetractAction(LeftTuple leftTuple, PropagationContext context, LeftTupleSink sink, int priority) {
            super(leftTuple, context, sink, priority);
        }

        public void execute(InternalWorkingMemory workingMemory) {
            this.sink.assertLeftTuple(this.leftTuple, this.context, workingMemory);
        }
    }

    public static class LeftTupleAssertAction
    extends LeftTupleAction {
        public LeftTupleAssertAction() {
        }

        public LeftTupleAssertAction(LeftTuple leftTuple, PropagationContext context, LeftTupleSink sink, int priority) {
            super(leftTuple, context, sink, priority);
        }

        public void execute(InternalWorkingMemory workingMemory) {
            this.sink.assertLeftTuple(this.leftTuple, this.context, workingMemory);
        }
    }

    public static abstract class LeftTupleAction
    implements Action,
    Externalizable {
        protected LeftTuple leftTuple;
        protected PropagationContext context;
        protected LeftTupleSink sink;
        protected int priority;

        public LeftTupleAction() {
            this.priority = 0;
        }

        public LeftTupleAction(LeftTuple leftTuple, PropagationContext context, LeftTupleSink sink, int priority) {
            this.leftTuple = leftTuple;
            this.context = context;
            this.sink = sink;
            this.priority = priority;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.leftTuple = (LeftTuple)in.readObject();
            this.context = (PropagationContext)in.readObject();
            this.sink = (LeftTupleSink)in.readObject();
            this.priority = in.readInt();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.leftTuple);
            out.writeObject(this.context);
            out.writeObject(this.sink);
            out.writeInt(this.priority);
        }

        public int getPriority() {
            return this.priority;
        }

        public int compareTo(Action o) {
            return this.getPriority() - o.getPriority();
        }

        public abstract void execute(InternalWorkingMemory var1);
    }

    public static class FactAssertAction
    extends FactAction {
        private static final long serialVersionUID = 510L;

        FactAssertAction() {
        }

        public FactAssertAction(InternalFactHandle handle, PropagationContext context, ObjectSink sink, int priority) {
            super(handle, context, sink, priority);
        }

        public void execute(InternalWorkingMemory workingMemory) {
            this.sink.assertObject(this.handle, this.context, workingMemory);
        }
    }

    public static abstract class FactAction
    implements Action,
    Externalizable {
        protected InternalFactHandle handle;
        protected PropagationContext context;
        protected ObjectSink sink;
        protected int priority;

        public FactAction() {
            this.priority = 0;
        }

        public FactAction(InternalFactHandle handle, PropagationContext context, ObjectSink sink, int priority) {
            this.handle = handle;
            this.context = context;
            this.sink = sink;
            this.priority = priority;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.handle = (InternalFactHandle)in.readObject();
            this.context = (PropagationContext)in.readObject();
            this.sink = (ObjectSink)in.readObject();
            this.priority = in.readInt();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.handle);
            out.writeObject(this.context);
            out.writeObject(this.sink);
            out.writeInt(this.priority);
        }

        public int getPriority() {
            return this.priority;
        }

        public int compareTo(Action o) {
            return this.getPriority() - o.getPriority();
        }

        public abstract void execute(InternalWorkingMemory var1);

        public String toString() {
            return this.getClass().getSimpleName() + "( part=" + this.sink.getPartitionId() + " sink=" + this.sink + " )";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Action
    extends Externalizable,
    Comparable<Action> {
        public static final int PRIORITY_HIGH = 10;
        public static final int PRIORITY_NORMAL = 0;
        public static final int PRIORITY_LOW = -10;

        public int getPriority();

        public void execute(InternalWorkingMemory var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PartitionTask
    implements Runnable,
    Comparable<PartitionTask> {
        protected static transient Logger logger = LoggerFactory.getLogger(PartitionTask.class);
        private int priority;
        private PartitionManager manager;
        private BlockingQueue<Action> queue = new PriorityBlockingQueue<Action>();
        private InternalWorkingMemory workingMemory;
        private AtomicBoolean enqueued;
        private AtomicBoolean isYieldAdded;

        public PartitionTask(PartitionManager manager, InternalWorkingMemory workingMemory) {
            this.manager = manager;
            this.workingMemory = workingMemory;
            this.priority = 0;
            this.enqueued = new AtomicBoolean(false);
            this.isYieldAdded = new AtomicBoolean(false);
        }

        public boolean enqueue(Action action) {
            boolean result = this.queue.add(action);
            this.addToExecutorQueue();
            return result;
        }

        @Override
        public void run() {
            try {
                Action action = (Action)this.queue.poll();
                if (action != null) {
                    action.execute(this.workingMemory);
                }
                this.enqueued.set(false);
                this.addToExecutorQueue();
            }
            catch (Exception e) {
                logger.error("*******************************************************************************************************");
                logger.error("Partition task manager caught an unexpected exception: " + e.getMessage());
                logger.error("Drools is capturing the exception to avoid thread death. Please report stack trace to development team.");
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addToExecutorQueue() {
            AtomicBoolean atomicBoolean = this.isYieldAdded;
            synchronized (atomicBoolean) {
                if (this.manager.isOnHold() && !this.queue.isEmpty() && this.isYieldAdded.compareAndSet(false, true)) {
                    this.queue.add(YieldAction.INSTANCE);
                }
            }
            if (!this.queue.isEmpty() && this.enqueued.compareAndSet(false, true)) {
                Action head = (Action)this.queue.peek();
                int priority = 10;
                while (head != null && head instanceof YieldAction) {
                    this.isYieldAdded.compareAndSet(true, false);
                    priority = 0;
                    this.queue.remove();
                    head = (Action)this.queue.peek();
                }
                if (head != null) {
                    this.setPriority(priority);
                    this.manager.execute(this);
                } else {
                    this.enqueued.compareAndSet(true, false);
                }
            }
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean isEnqueued() {
            return this.enqueued.get();
        }

        private void setPriority(int priority) {
            this.priority = priority;
        }

        @Override
        public int compareTo(PartitionTask o) {
            return this.getPriority() - o.getPriority();
        }

        public String toString() {
            return "PartitionTask( priority=" + this.priority + " action=" + this.queue.peek() + " )";
        }
    }
}

