/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;

public class MemoryUtil {
    public static final MemoryStats permGenStats;

    private MemoryUtil() {
    }

    static {
        MemoryPoolMXBean permGenBean = null;
        for (MemoryPoolMXBean mx : ManagementFactory.getMemoryPoolMXBeans()) {
            if (mx.getName() == null || !mx.getName().contains("Perm")) continue;
            permGenBean = mx;
            break;
        }
        permGenStats = new MemoryStats(permGenBean);
    }

    public static class MemoryStats {
        private final MemoryPoolMXBean memoryBean;

        public MemoryStats(MemoryPoolMXBean memoryBean) {
            this.memoryBean = memoryBean;
        }

        public boolean isUsageThresholdExceeded(int threshold) {
            MemoryUsage memoryUsage = this.getMemoryUsage();
            return memoryUsage != null && memoryUsage.getUsed() * 100L / memoryUsage.getMax() >= (long)threshold;
        }

        private MemoryUsage getMemoryUsage() {
            return this.memoryBean != null ? this.memoryBean.getUsage() : ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        }
    }
}

