/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.components.aop.util;

import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.util.StringValueResolver;

public class Scopifier
extends BeanDefinitionVisitor {
    private final boolean proxyTargetClass;
    private final BeanDefinitionRegistry registry;
    private final String scope;
    private final boolean scoped;

    public static BeanDefinitionHolder createScopedProxy(String beanName, BeanDefinition definition, BeanDefinitionRegistry registry, boolean proxyTargetClass) {
        BeanDefinitionHolder proxyHolder = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)new BeanDefinitionHolder(definition, beanName), (BeanDefinitionRegistry)registry, (boolean)proxyTargetClass);
        registry.registerBeanDefinition(beanName, proxyHolder.getBeanDefinition());
        return proxyHolder;
    }

    public Scopifier(BeanDefinitionRegistry registry, String scope, boolean proxyTargetClass, boolean scoped) {
        super(new StringValueResolver(){

            public String resolveStringValue(String value) {
                return value;
            }
        });
        this.registry = registry;
        this.proxyTargetClass = proxyTargetClass;
        this.scope = scope;
        this.scoped = scoped;
    }

    protected Object resolveValue(Object value) {
        BeanDefinition definition = null;
        String beanName = null;
        if (value instanceof BeanDefinition) {
            definition = (BeanDefinition)value;
            beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)definition, (BeanDefinitionRegistry)this.registry);
        } else if (value instanceof BeanDefinitionHolder) {
            BeanDefinitionHolder holder = (BeanDefinitionHolder)value;
            definition = holder.getBeanDefinition();
            beanName = holder.getBeanName();
        }
        if (definition != null) {
            boolean scopeChangeRequiresProxy;
            boolean nestedScoped = this.scope.equals(definition.getScope());
            boolean bl = scopeChangeRequiresProxy = !this.scoped && nestedScoped;
            if (scopeChangeRequiresProxy) {
                return Scopifier.createScopedProxy(beanName, definition, this.registry, this.proxyTargetClass);
            }
        }
        value = super.resolveValue(value);
        return value;
    }
}

