/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.repository;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RepositoryType {
    CONTENT("Content repository", "content.repository", "stream"),
    PROVENANCE("Provenance repository", "provenance.repository", "block"),
    FLOWFILE("Flowfile repository", "flowfile.repository", "stream");

    private static final Logger logger;
    private final String name;
    private final String packagePath;
    private final String encryptionProcess;

    private RepositoryType(String name, String packagePath, String encryptionProcess) {
        this.name = name;
        this.packagePath = packagePath;
        this.encryptionProcess = encryptionProcess;
    }

    public String getName() {
        return this.name;
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public String getEncryptionProcess() {
        return this.encryptionProcess;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("Repository", (Object)this.name);
        builder.append("Package path", (Object)this.packagePath);
        builder.append("Encryption process", (Object)this.encryptionProcess);
        return builder.toString();
    }

    public static RepositoryType determineType(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            throw new IllegalArgumentException("The input cannot be null or empty");
        }
        String lowercaseInput = input.toLowerCase().trim();
        if (lowercaseInput.contains("content")) {
            return CONTENT;
        }
        if (lowercaseInput.contains("prov")) {
            return PROVENANCE;
        }
        if (lowercaseInput.contains("flow")) {
            return FLOWFILE;
        }
        String msg = "Could not determine repository type from '" + input + "'";
        logger.error(msg);
        throw new IllegalArgumentException(msg);
    }

    static {
        logger = LoggerFactory.getLogger(RepositoryType.class);
    }
}

