/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.repository;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.codec.binary.Hex;

public abstract class RepositoryObjectEncryptionMetadata
implements Serializable {
    public String keyId;
    public String algorithm;
    public byte[] ivBytes;
    public String version;
    public int cipherByteLength;
    private transient int length = 0;

    public String toString() {
        String sb = "Repository Object Encryption Metadata Key ID: " + this.keyId + " Algorithm: " + this.algorithm + " IV: " + Hex.encodeHexString((byte[])this.ivBytes) + " Version: " + this.version + " Cipher text length: " + this.cipherByteLength + " Serialized byte length: " + this.length();
        return sb;
    }

    public int length() {
        if (this.length == 0) {
            try {
                ByteArrayOutputStream temp = new ByteArrayOutputStream(512);
                ObjectOutputStream oos = new ObjectOutputStream(temp);
                oos.writeObject(this);
                this.length = temp.size();
            }
            catch (IOException e) {
                throw new AssertionError((Object)"This is unreachable code");
            }
        }
        return this.length;
    }
}

