/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import aQute.lib.osgi.Analyzer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.osgiplugin.EclipseOsgiPlugin;
import org.apache.maven.plugin.eclipse.osgiplugin.ExplodedPlugin;
import org.apache.maven.plugin.eclipse.osgiplugin.PackagedPlugin;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class EclipseToMavenMojo
extends AbstractMojo
implements Contextualizable {
    private static final Pattern DEPLOYTO_PATTERN = Pattern.compile("(.+)::(.+)::(.+)");
    private static final Pattern VERSION_PATTERN = Pattern.compile("(([0-9]+\\.)+[0-9]+)");
    private PlexusContainer container;
    private ArtifactRepository localRepository;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactFactory artifactFactory;
    protected ArtifactInstaller installer;
    private ArtifactDeployer deployer;
    private File eclipseDir;
    protected InputHandler inputHandler;
    private boolean stripQualifier;
    private String deployTo;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.eclipseDir == null) {
            String eclipseDirString;
            this.getLog().info((CharSequence)Messages.getString("EclipseToMavenMojo.eclipseDirectoryPrompt"));
            try {
                eclipseDirString = this.inputHandler.readLine();
            }
            catch (IOException e) {
                throw new MojoFailureException(Messages.getString("EclipseToMavenMojo.errorreadingfromstandardinput"));
            }
            this.eclipseDir = new File(eclipseDirString);
        }
        if (!this.eclipseDir.isDirectory()) {
            throw new MojoFailureException(Messages.getString("EclipseToMavenMojo.directoydoesnotexist", this.eclipseDir.getAbsolutePath()));
        }
        File pluginDir = new File(this.eclipseDir, "plugins");
        if (!pluginDir.isDirectory()) {
            throw new MojoFailureException(Messages.getString("EclipseToMavenMojo.plugindirectorydoesnotexist", pluginDir.getAbsolutePath()));
        }
        File[] files = pluginDir.listFiles();
        ArtifactRepository remoteRepo = this.resolveRemoteRepo();
        if (remoteRepo != null) {
            this.getLog().info((CharSequence)Messages.getString("EclipseToMavenMojo.remoterepositorydeployto", this.deployTo));
        }
        HashMap plugins = new HashMap();
        HashMap models = new HashMap();
        for (int j = 0; j < files.length; ++j) {
            File file = files[j];
            this.getLog().info((CharSequence)Messages.getString("EclipseToMavenMojo.processingfile", file.getAbsolutePath()));
            this.processFile(file, plugins, models);
        }
        int i = 1;
        Iterator it = plugins.keySet().iterator();
        while (it.hasNext()) {
            this.getLog().info((CharSequence)Messages.getString("EclipseToMavenMojo.processingplugin", new Object[]{new Integer(i++), new Integer(plugins.keySet().size())}));
            String key = (String)it.next();
            EclipseOsgiPlugin plugin = (EclipseOsgiPlugin)plugins.get(key);
            Model model = (Model)models.get(key);
            this.writeArtifact(plugin, model, remoteRepo);
        }
    }

    protected void processFile(File file, Map plugins, Map models) throws MojoExecutionException, MojoFailureException {
        EclipseOsgiPlugin plugin = this.getEclipsePlugin(file);
        if (plugin == null) {
            this.getLog().warn((CharSequence)Messages.getString("EclipseToMavenMojo.skippingfile", file.getAbsolutePath()));
            return;
        }
        Model model = this.createModel(plugin);
        if (model == null) {
            return;
        }
        this.processPlugin(plugin, model, plugins, models);
    }

    protected void processPlugin(EclipseOsgiPlugin plugin, Model model, Map plugins, Map models) throws MojoExecutionException, MojoFailureException {
        plugins.put(this.getKey(model), plugin);
        models.put(this.getKey(model), model);
    }

    protected String getKey(Model model) {
        return model.getGroupId() + "." + model.getArtifactId();
    }

    private String getKey(Dependency dependency) {
        return dependency.getGroupId() + "." + dependency.getArtifactId();
    }

    protected void resolveVersionRanges(Model model, Map models) throws MojoFailureException {
        Iterator it = model.getDependencies().iterator();
        while (it.hasNext()) {
            Dependency dep = (Dependency)it.next();
            if (dep.getVersion().indexOf("[") <= -1 && dep.getVersion().indexOf("(") <= -1) continue;
            String key = this.getKey(model);
            Model dependencyModel = (Model)models.get(this.getKey(dep));
            if (dependencyModel != null) {
                dep.setVersion(dependencyModel.getVersion());
                continue;
            }
            throw new MojoFailureException(Messages.getString("EclipseToMavenMojo.unabletoresolveversionrange", new Object[]{dep, key}));
        }
    }

    private EclipseOsgiPlugin getEclipsePlugin(File file) throws MojoExecutionException {
        if (file.isDirectory()) {
            return new ExplodedPlugin(file);
        }
        if (file.getName().endsWith(".jar")) {
            try {
                return new PackagedPlugin(file);
            }
            catch (IOException e) {
                throw new MojoExecutionException(Messages.getString("EclipseToMavenMojo.unabletoaccessjar", file.getAbsolutePath()), (Exception)e);
            }
        }
        return null;
    }

    private Model createModel(EclipseOsgiPlugin plugin) throws MojoExecutionException {
        String requireBundle;
        String name;
        String version;
        String bundleName;
        try {
            if (!plugin.hasManifest()) {
                this.getLog().warn((CharSequence)Messages.getString("EclipseToMavenMojo.plugindoesnothavemanifest", plugin));
                return null;
            }
            Analyzer analyzer = new Analyzer();
            Map bundleSymbolicNameHeader = analyzer.parseHeader(plugin.getManifestAttribute("Bundle-SymbolicName"));
            bundleName = (String)bundleSymbolicNameHeader.keySet().iterator().next();
            version = plugin.getManifestAttribute("Bundle-Version");
            if (bundleName == null || version == null) {
                this.getLog().error((CharSequence)Messages.getString("EclipseToMavenMojo.unabletoreadbundlefrommanifest"));
                return null;
            }
            version = this.osgiVersionToMavenVersion(version);
            name = plugin.getManifestAttribute("Bundle-Name");
            requireBundle = plugin.getManifestAttribute("Require-Bundle");
        }
        catch (IOException e) {
            throw new MojoExecutionException(Messages.getString("EclipseToMavenMojo.errorprocessingplugin", plugin), (Exception)e);
        }
        Dependency[] deps = this.parseDependencies(requireBundle);
        String groupId = this.createGroupId(bundleName);
        String artifactId = this.createArtifactId(bundleName);
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(groupId);
        model.setArtifactId(artifactId);
        model.setName(name);
        model.setVersion(version);
        model.setProperties(plugin.getPomProperties());
        if (groupId.startsWith("org.eclipse")) {
            License license = new License();
            license.setName("Eclipse Public License - v 1.0");
            license.setUrl("http://www.eclipse.org/org/documents/epl-v10.html");
            model.addLicense(license);
        }
        if (deps.length > 0) {
            for (int k = 0; k < deps.length; ++k) {
                model.getDependencies().add(deps[k]);
            }
        }
        return model;
    }

    private void writeArtifact(EclipseOsgiPlugin plugin, Model model, ArtifactRepository remoteRepo) throws MojoExecutionException {
        OutputStreamWriter fw = null;
        ProjectArtifactMetadata metadata = null;
        File pomFile = null;
        Artifact pomArtifact = this.artifactFactory.createArtifact(model.getGroupId(), model.getArtifactId(), model.getVersion(), null, "pom");
        Artifact artifact = this.artifactFactory.createArtifact(model.getGroupId(), model.getArtifactId(), model.getVersion(), null, "jar");
        try {
            pomFile = File.createTempFile("pom-", ".xml");
            fw = new OutputStreamWriter((OutputStream)new FileOutputStream(pomFile), "UTF-8");
            model.setModelEncoding("UTF-8");
            pomFile.deleteOnExit();
            new MavenXpp3Writer().write((Writer)fw, model);
            metadata = new ProjectArtifactMetadata(pomArtifact, pomFile);
            pomArtifact.addMetadata((ArtifactMetadata)metadata);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException(Messages.getString("EclipseToMavenMojo.errorwritingtemporarypom", e.getMessage()), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fw);
                throw throwable;
            }
        }
        IOUtil.close((Writer)fw);
        try {
            File jarFile = plugin.getJarFile();
            if (remoteRepo != null) {
                this.deployer.deploy(pomFile, pomArtifact, remoteRepo, this.localRepository);
                this.deployer.deploy(jarFile, artifact, remoteRepo, this.localRepository);
            } else {
                this.installer.install(pomFile, pomArtifact, this.localRepository);
                this.installer.install(jarFile, artifact, this.localRepository);
            }
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(Messages.getString("EclipseToMavenMojo.errordeployartifacttorepository"), (Exception)((Object)e));
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException(Messages.getString("EclipseToMavenMojo.errorinstallartifacttorepository"), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException(Messages.getString("EclipseToMavenMojo.errorgettingjarfileforplugin", plugin), (Exception)e);
        }
        finally {
            pomFile.delete();
        }
    }

    protected String osgiVersionToMavenVersion(String version) {
        return this.osgiVersionToMavenVersion(version, null, this.stripQualifier);
    }

    protected String osgiVersionToMavenVersion(String version, String forcedQualifier, boolean stripQualifier) {
        if (stripQualifier && StringUtils.countMatches((String)version, (String)".") > 2) {
            version = StringUtils.substring((String)version, (int)0, (int)version.lastIndexOf("."));
        } else if (StringUtils.countMatches((String)version, (String)".") > 2) {
            int lastDot = version.lastIndexOf(".");
            version = StringUtils.isNotEmpty((String)forcedQualifier) ? StringUtils.substring((String)version, (int)0, (int)lastDot) + "-" + forcedQualifier : StringUtils.substring((String)version, (int)0, (int)lastDot) + "-" + StringUtils.substring((String)version, (int)(lastDot + 1), (int)version.length());
        }
        return version;
    }

    private ArtifactRepository resolveRemoteRepo() throws MojoFailureException, MojoExecutionException {
        if (this.deployTo != null) {
            ArtifactRepositoryLayout repoLayout;
            Matcher matcher = DEPLOYTO_PATTERN.matcher(this.deployTo);
            if (!matcher.matches()) {
                throw new MojoFailureException((Object)this.deployTo, Messages.getString("EclipseToMavenMojo.invalidsyntaxforrepository"), Messages.getString("EclipseToMavenMojo.invalidremoterepositorysyntax"));
            }
            String id = matcher.group(1).trim();
            String layout = matcher.group(2).trim();
            String url = matcher.group(3).trim();
            try {
                repoLayout = (ArtifactRepositoryLayout)this.container.lookup(ArtifactRepositoryLayout.ROLE, layout);
            }
            catch (ComponentLookupException e) {
                throw new MojoExecutionException(Messages.getString("EclipseToMavenMojo.cannotfindrepositorylayout", layout), (Exception)((Object)e));
            }
            return this.artifactRepositoryFactory.createDeploymentArtifactRepository(id, url, repoLayout, true);
        }
        return null;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    protected String createGroupId(String bundleName) {
        int i = bundleName.lastIndexOf(".");
        if (i > 0) {
            return bundleName.substring(0, i);
        }
        return bundleName;
    }

    protected String createArtifactId(String bundleName) {
        int i = bundleName.lastIndexOf(".");
        if (i > 0) {
            return bundleName.substring(i + 1);
        }
        return bundleName;
    }

    protected Dependency[] parseDependencies(String requireBundle) {
        if (requireBundle == null) {
            return new Dependency[0];
        }
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        Analyzer analyzer = new Analyzer();
        Map requireBundleHeader = analyzer.parseHeader(requireBundle);
        Iterator iter = requireBundleHeader.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String bundleName = (String)entry.getKey();
            Map attributes = (Map)entry.getValue();
            String version = (String)attributes.get("Bundle-Version".toLowerCase());
            boolean optional = "optional".equals(attributes.get("resolution:"));
            if (version == null) {
                this.getLog().info((CharSequence)Messages.getString("EclipseToMavenMojo.missingversionforbundle", bundleName));
                version = "[0,)";
            }
            version = this.fixBuildNumberSeparator(version);
            Dependency dep = new Dependency();
            dep.setGroupId(this.createGroupId(bundleName));
            dep.setArtifactId(this.createArtifactId(bundleName));
            dep.setVersion(version);
            dep.setOptional(optional);
            dependencies.add(dep);
        }
        return dependencies.toArray(new Dependency[dependencies.size()]);
    }

    protected String fixBuildNumberSeparator(String versionRange) {
        if (versionRange == null) {
            return null;
        }
        StringBuffer newVersionRange = new StringBuffer();
        Matcher matcher = VERSION_PATTERN.matcher(versionRange);
        while (matcher.find()) {
            String group = matcher.group();
            if (StringUtils.countMatches((String)group, (String)".") > 2) {
                int lastDot = group.lastIndexOf(".");
                group = StringUtils.substring((String)group, (int)0, (int)lastDot) + "-" + StringUtils.substring((String)group, (int)(lastDot + 1), (int)group.length());
            }
            matcher.appendReplacement(newVersionRange, group);
        }
        matcher.appendTail(newVersionRange);
        return newVersionRange.toString();
    }
}

