/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.util.Set;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.PreExecute;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.UserGroupInformation;

public class UpdateInputAccessTimeHook {
    private static final String LAST_ACCESS_TIME = "lastAccessTime";

    public static class PreExec
    implements PreExecute {
        @Override
        public void run(SessionState sess, Set<ReadEntity> inputs, Set<WriteEntity> outputs, UserGroupInformation ugi) throws Exception {
            Hive db;
            try {
                db = Hive.get(sess.getConf());
            }
            catch (HiveException e) {
                Object db2 = null;
                return;
            }
            int lastAccessTime = (int)(System.currentTimeMillis() / 1000L);
            for (ReadEntity re : inputs) {
                Entity.Type typ = re.getType();
                switch (typ) {
                    case TABLE: {
                        Table t = db.getTable(re.getTable().getTableName());
                        t.setLastAccessTime(lastAccessTime);
                        db.alterTable(t.getDbName() + "." + t.getTableName(), t, null);
                        break;
                    }
                    case PARTITION: {
                        Partition p = re.getPartition();
                        Table t = db.getTable(p.getTable().getTableName());
                        p = db.getPartition(t, p.getSpec(), false);
                        p.setLastAccessTime(lastAccessTime);
                        db.alterPartition(t.getTableName(), p, null);
                        t.setLastAccessTime(lastAccessTime);
                        db.alterTable(t.getDbName() + "." + t.getTableName(), t, null);
                        break;
                    }
                }
            }
        }
    }
}

