/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionLoadStats;
import org.apache.hadoop.hbase.client.StatisticTrackable;
import org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ServerStatisticTracker
implements StatisticTrackable {
    private final ConcurrentHashMap<ServerName, ServerStatistics> stats = new ConcurrentHashMap();

    @Override
    public void updateRegionStats(ServerName server, byte[] region, RegionLoadStats currentStats) {
        ((ServerStatistics)CollectionUtils.computeIfAbsent(this.stats, (Object)server, ServerStatistics::new)).update(region, currentStats);
    }

    public ServerStatistics getStats(ServerName server) {
        return this.stats.get(server);
    }

    public static ServerStatisticTracker create(Configuration conf) {
        if (!conf.getBoolean("hbase.client.backpressure.enabled", false)) {
            return null;
        }
        return new ServerStatisticTracker();
    }

    @VisibleForTesting
    ServerStatistics getServerStatsForTesting(ServerName server) {
        return this.stats.get(server);
    }
}

