/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.CorrelateCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public abstract class CommonExecCorrelate
extends ExecNodeBase<RowData>
implements SingleTransformationTranslator<RowData> {
    public static final String CORRELATE_TRANSFORMATION = "correlate";
    public static final String FIELD_NAME_JOIN_TYPE = "joinType";
    public static final String FIELD_NAME_FUNCTION_CALL = "functionCall";
    public static final String FIELD_NAME_CONDITION = "condition";
    @JsonProperty(value="joinType")
    private final FlinkJoinType joinType;
    @JsonProperty(value="functionCall")
    private final RexCall invocation;
    @JsonProperty(value="condition")
    @Nullable
    private final RexNode condition;
    private final Class<?> operatorBaseClass;
    private final boolean retainHeader;

    public CommonExecCorrelate(int id, ExecNodeContext context, ReadableConfig persistedConfig, FlinkJoinType joinType, RexCall invocation, @Nullable RexNode condition, Class<?> operatorBaseClass, boolean retainHeader, List<InputProperty> inputProperties, RowType outputType, String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.joinType = (FlinkJoinType)Preconditions.checkNotNull((Object)joinType);
        this.invocation = (RexCall)Preconditions.checkNotNull((Object)invocation);
        this.condition = condition;
        this.operatorBaseClass = (Class)Preconditions.checkNotNull(operatorBaseClass);
        this.retainHeader = retainHeader;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        CodeGeneratorContext ctx = new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader()).setOperatorBaseClass(this.operatorBaseClass);
        return CorrelateCodeGenerator.generateCorrelateTransformation(config, ctx, inputTransform, (RowType)inputEdge.getOutputType(), this.invocation, JavaScalaConversionUtil.toScala(Optional.ofNullable(this.condition)), (RowType)this.getOutputType(), this.joinType, inputTransform.getParallelism(), this.retainHeader, this.getClass().getSimpleName(), this.createTransformationMeta(CORRELATE_TRANSFORMATION, config));
    }
}

