/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Arrays;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.NestedLoopJoinCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class BatchExecNestedLoopJoin
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData> {
    private final FlinkJoinType joinType;
    private final RexNode condition;
    private final boolean leftIsBuild;
    private final boolean singleRowJoin;

    public BatchExecNestedLoopJoin(ReadableConfig tableConfig, FlinkJoinType joinType, RexNode condition, boolean leftIsBuild, boolean singleRowJoin, InputProperty leftInputProperty, InputProperty rightInputProperty, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecNestedLoopJoin.class), ExecNodeContext.newPersistedConfig(BatchExecNestedLoopJoin.class, tableConfig), Arrays.asList(leftInputProperty, rightInputProperty), (LogicalType)outputType, description);
        this.joinType = (FlinkJoinType)Preconditions.checkNotNull((Object)joinType);
        this.condition = (RexNode)Preconditions.checkNotNull((Object)condition);
        this.leftIsBuild = leftIsBuild;
        this.singleRowJoin = singleRowJoin;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge leftInputEdge = this.getInputEdges().get(0);
        ExecEdge rightInputEdge = this.getInputEdges().get(1);
        Transformation<?> leftInputTransform = leftInputEdge.translateToPlan(planner);
        Transformation<?> rightInputTransform = rightInputEdge.translateToPlan(planner);
        RowType leftType = (RowType)leftInputEdge.getOutputType();
        RowType rightType = (RowType)rightInputEdge.getOutputType();
        CodeGenOperatorFactory<RowData> operator = new NestedLoopJoinCodeGenerator(new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader()), this.singleRowJoin, this.leftIsBuild, leftType, rightType, (RowType)this.getOutputType(), this.joinType, this.condition).gen();
        int parallelism = leftInputTransform.getParallelism();
        if (this.leftIsBuild) {
            parallelism = rightInputTransform.getParallelism();
        }
        long manageMem = 0L;
        if (!this.singleRowJoin) {
            manageMem = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_EXTERNAL_BUFFER_MEMORY)).getBytes();
        }
        return ExecNodeUtil.createTwoInputTransformation(leftInputTransform, rightInputTransform, this.createTransformationName(config), this.createTransformationDescription(config), operator, InternalTypeInfo.of((LogicalType)this.getOutputType()), parallelism, manageMem);
    }
}

