/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.tuple.Tuple12;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.TableFunction;

public class JavaUserDefinedTableFunctions {

    public static class JavaTableFuncTuple12
    extends TableFunction<Tuple12<String, String, String, String, String, String, Integer, Integer, Integer, Integer, Integer, Integer>> {
        private static final long serialVersionUID = -8258882510989374448L;

        public void eval(String str) {
            this.collect(Tuple12.of((Object)(str + "_a"), (Object)(str + "_b"), (Object)(str + "_c"), (Object)(str + "_d"), (Object)(str + "_e"), (Object)(str + "_f"), (Object)str.length(), (Object)(str.length() + 1), (Object)(str.length() + 2), (Object)(str.length() + 3), (Object)(str.length() + 4), (Object)(str.length() + 5)));
        }
    }

    public static class NonDeterministicTableFunc
    extends TableFunction<String> {
        Random random = new Random();

        public void eval(String str) {
            String[] values = str.split("#");
            this.collect(values[this.random.nextInt(values.length)]);
        }

        public boolean isDeterministic() {
            return false;
        }
    }

    public static class StringSplit
    extends TableFunction<String> {
        public void eval() {
            String[] strs;
            for (String str : strs = new String[]{"a", "b", "c"}) {
                this.eval(str);
            }
        }

        public void eval(String str) {
            this.eval(str, ",");
        }

        public void eval(String str, String separatorChars) {
            this.eval(str, separatorChars, 0);
        }

        public void eval(String str, String separatorChars, int startIndex) {
            if (str != null) {
                String[] strs = StringUtils.split((String)str, (String)separatorChars);
                if (startIndex < 0) {
                    startIndex = 0;
                }
                for (int i = startIndex; i < strs.length; ++i) {
                    this.collect(strs[i]);
                }
            }
        }

        public void eval(byte[] varbinary) {
            if (varbinary != null) {
                this.eval(new String(varbinary, StandardCharsets.UTF_8));
            }
        }

        public TypeInformation<String> getResultType() {
            return Types.STRING;
        }
    }

    public static class JavaTableFunc1
    extends TableFunction<Integer> {
        public void eval(String ... strs) {
            int sum = 0;
            if (strs != null) {
                for (String str : strs) {
                    sum += str == null ? 0 : str.length();
                }
            }
            this.collect(sum);
        }
    }

    public static class JavaVarsArgTableFunc0
    extends TableFunction<String> {
        public void eval(String ... strs) {
            for (String s : strs) {
                this.collect(s);
            }
        }

        public void eval(int val, String str) {
            for (int i = 0; i < val; ++i) {
                this.collect(str);
            }
        }
    }

    public static class JavaTableFunc0
    extends TableFunction<Long> {
        public void eval(@DataTypeHint(value="DATE") Integer a, Long b, @DataTypeHint(value="TIMESTAMP(0)") TimestampData c) {
            this.collect(a.longValue());
            this.collect(b);
            this.collect(c.getMillisecond());
        }
    }
}

