/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Map;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.LookupJoinITCase$;
import org.apache.flink.table.planner.runtime.utils.InMemoryLookupableTableSource$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$TestAddWithOpen$;
import org.apache.flink.table.runtime.functions.table.fullcache.inputformat.FullCacheTestInputFormat;
import org.apache.flink.table.runtime.functions.table.lookup.LookupCacheManager;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\teg\u0001B\u0001\u0003\u0001M\u0011\u0001\u0003T8pWV\u0004(j\\5o\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0007gR\u0014X-Y7\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003\u0015)H/\u001b7t\u0013\tIbCA\tTiJ,\u0017-\\5oOR+7\u000f\u001e\"bg\u0016D\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0012Y\u0016<\u0017mY=UC\ndWmU8ve\u000e,\u0007CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"a\u0002\"p_2,\u0017M\u001c\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005I1-Y2iKRK\b/\u001a\t\u0003K}r!A\n\u001f\u000f\u0005\u001dJdB\u0001\u00157\u001d\tICG\u0004\u0002+g9\u00111F\r\b\u0003YEr!!\f\u0019\u000e\u00039R!a\f\n\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA\b\u0011\u0013\tia\"\u0003\u0002\f\u0019%\u0011QGC\u0001\nG>tg.Z2u_JL!a\u000e\u001d\u0002\rM|WO]2f\u0015\t)$\"\u0003\u0002;w\u00051An\\8lkBT!a\u000e\u001d\n\u0005ur\u0014!\u0004'p_.,\bo\u00149uS>t7O\u0003\u0002;w%\u0011\u0001)\u0011\u0002\u0010\u0019>|7.\u001e9DC\u000eDW\rV=qK*\u0011QH\u0010\u0005\u0006\u0007\u0002!\t\u0001R\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0015;\u0005\n\u0005\u0002G\u00015\t!\u0001C\u0003\u001c\u0005\u0002\u0007A\u0004C\u0003$\u0005\u0002\u0007A\u0005C\u0004K\u0001\t\u0007I\u0011A&\u0002\t\u0011\fG/Y\u000b\u0002\u0019B\u0019QJ\u0015+\u000e\u00039S!a\u0014)\u0002\u0013%lW.\u001e;bE2,'BA)\u001f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003':\u0013A\u0001T5tiB\u0011Q\u000bW\u0007\u0002-*\u0011q\u000bD\u0001\u0006if\u0004Xm]\u0005\u00033Z\u00131AU8x\u0011\u0019Y\u0006\u0001)A\u0005\u0019\u0006)A-\u0019;bA!9Q\f\u0001b\u0001\n\u0003Y\u0015\u0001\u00043bi\u0006<\u0016\u000e\u001e5Ok2d\u0007BB0\u0001A\u0003%A*A\u0007eCR\fw+\u001b;i\u001dVdG\u000e\t\u0005\bC\u0002\u0011\r\u0011\"\u0001L\u0003!)8/\u001a:ECR\f\u0007BB2\u0001A\u0003%A*A\u0005vg\u0016\u0014H)\u0019;bA!9Q\r\u0001b\u0001\n\u0003Y\u0015\u0001E;tKJ$\u0015\r^1XSRDg*\u001e7m\u0011\u00199\u0007\u0001)A\u0005\u0019\u0006\tRo]3s\t\u0006$\u0018mV5uQ:+H\u000e\u001c\u0011\t\u000b%\u0004A\u0011\t6\u0002\r\t,gm\u001c:f)\u0005Y\u0007CA\u000fm\u0013\tigD\u0001\u0003V]&$\bF\u00015p!\t\u00018/D\u0001r\u0015\t\u0011\b#A\u0003kk:LG/\u0003\u0002uc\n1!)\u001a4pe\u0016DQA\u001e\u0001\u0005B)\fQ!\u00194uKJD#!\u001e=\u0011\u0005AL\u0018B\u0001>r\u0005\u0015\te\r^3s\u0011\u0015a\b\u0001\"\u0003~\u0003E\u0019'/Z1uK2{wn[;q)\u0006\u0014G.\u001a\u000b\u0007Wz\f\t\"a\t\t\r}\\\b\u0019AA\u0001\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0005\u0003\u0002\u0004\u0005-a\u0002BA\u0003\u0003\u000f\u0001\"!\f\u0010\n\u0007\u0005%a$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\tyA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0013q\u0002B\u0002&|\u0001\u0004\t\u0019\u0002E\u0003\u0002\u0016\u0005}AK\u0004\u0003\u0002\u0018\u0005mabA\u0017\u0002\u001a%\tq$C\u0002\u0002\u001ey\tq\u0001]1dW\u0006<W-C\u0002T\u0003CQ1!!\b\u001f\u0011%\t)c\u001fI\u0001\u0002\u0004\t9#A\bm_>\\W\u000f\u001d+ie\u0016\u001c\bn\u001c7e!\ri\u0012\u0011F\u0005\u0004\u0003Wq\"aA%oi\"9\u0011q\u0006\u0001\u0005\n\u0005E\u0012aI2sK\u0006$X\rT8pWV\u0004H+\u00192mK^KG\u000f[\"p[B,H/\u001a3D_2,XN\u001c\u000b\u0006W\u0006M\u0012Q\u0007\u0005\b\u007f\u00065\u0002\u0019AA\u0001\u0011\u001dQ\u0015Q\u0006a\u0001\u0003'Aq!!\u000f\u0001\t\u0013\tY$A\bde\u0016\fG/Z*dC:$\u0016M\u00197f)\u0015Y\u0017QHA \u0011\u001dy\u0018q\u0007a\u0001\u0003\u0003AqASA\u001c\u0001\u0004\t\u0019\u0002\u0003\u0004\u0002D\u0001!\tA[\u0001\u0016i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197fQ\u0011\t\t%a\u0012\u0011\u0007A\fI%C\u0002\u0002LE\u0014A\u0001V3ti\"1\u0011q\n\u0001\u0005\u0002)\f!\u0005^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQV#gMR5mi\u0016\u0014\b\u0006BA'\u0003\u000fBa!!\u0016\u0001\t\u0003Q\u0017a\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\",FMZ#rk\u0006dg)\u001b7uKJDC!a\u0015\u0002H!1\u00111\f\u0001\u0005\u0002)\f!\u0005^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWm\u00148D_:\u001cH/\u00198u\u0017\u0016L\b\u0006BA-\u0003\u000fBa!!\u0019\u0001\t\u0003Q\u0017A\t;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001dVdG.\u00192mK.+\u0017\u0010\u000b\u0003\u0002`\u0005\u001d\u0003BBA4\u0001\u0011\u0005!.A\u0011uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRD\u0007+^:i\t><h\u000e\u000b\u0003\u0002f\u0005\u001d\u0003BBA7\u0001\u0011\u0005!.A\u0014uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDgj\u001c8FcV\fGNR5mi\u0016\u0014\b\u0006BA6\u0003\u000fBa!a\u001d\u0001\t\u0003Q\u0017A\t;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001bVdG/\u001b$jK2$7\u000f\u000b\u0003\u0002r\u0005\u001d\u0003BBA=\u0001\u0011\u0005!.A\u0013uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]6+H\u000e^5LKf4\u0015.\u001a7eg\"\"\u0011qOA$\u0011\u0019\ty\b\u0001C\u0001U\u00061C/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\\'vYRL7*Z=GS\u0016dGm\u001d\u001a)\t\u0005u\u0014q\t\u0005\u0007\u0003\u000b\u0003A\u0011\u00016\u0002iQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK>sW*\u001e7uS.+\u0017PR5fY\u0012\u001cx+\u001b;i\u0007>t7\u000f^1oi.+\u0017\u0010\u000b\u0003\u0002\u0004\u0006\u001d\u0003BBAF\u0001\u0011\u0005!.\u0001\u001euKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]6+H\u000e^5LKf4\u0015.\u001a7eg^KG\u000f[*ue&twmQ8ogR\fg\u000e^&fs\"\"\u0011\u0011RA$\u0011\u0019\t\t\n\u0001C\u0001U\u00069C/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\\'vYRL7i\u001c8ti\u0006tGoS3zQ\u0011\ty)a\u0012\t\r\u0005]\u0005\u0001\"\u0001k\u0003e!Xm\u001d;MK\u001a$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3)\t\u0005U\u0015q\t\u0005\u0007\u0003;\u0003A\u0011\u00016\u0002MQ,7\u000f\u001e'fMRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001dVdG.\u00192mK.+\u0017\u0010\u000b\u0003\u0002\u001c\u0006\u001d\u0003BBAR\u0001\u0011\u0005!.\u0001\u0015uKN$H*\u001a4u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\\'vYR\\U-\u001f$jK2$7\u000f\u000b\u0003\u0002\"\u0006\u001d\u0003BBAU\u0001\u0011\u0005!.A\u0019uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]6+H\u000e^5LKf4\u0015.\u001a7eg^KG\u000f\u001b(vY2$\u0015\r^1)\t\u0005\u001d\u0016q\t\u0005\u0007\u0003_\u0003A\u0011\u00016\u0002kQ,7\u000f\u001e'fMRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001bVdG/[&fs\u001aKW\r\u001c3t/&$\bNT;mY\u0012\u000bG/\u0019\u0015\u0005\u0003[\u000b9\u0005\u0003\u0004\u00026\u0002!\tA[\u0001'i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f\u001f:tU\u000f\u001c7D_:\u001cH/\u00198u\u0017\u0016L\b\u0006BAZ\u0003\u000fBa!a/\u0001\t\u0003Q\u0017\u0001\u000f;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001bVdG/[&fs\u001aKW\r\u001c3t/&$\bNT;mY\u000e{gn\u001d;b]R\\U-\u001f\u0015\u0005\u0003s\u000b9\u0005\u0003\u0004\u0002B\u0002!\tA[\u0001-i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f\u001f:lU\u000f\u001c;j\u0017\u0016Lh)[3mIN<\u0016\u000e\u001e5V\t\u001aCC!a0\u0002H!1\u0011q\u0019\u0001\u0005\u0002)\fq\u0005^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ\u000e{W\u000e];uK\u0012\u001cu\u000e\\;n]\"\"\u0011QYA$\u0011\u0019\ti\r\u0001C\u0001U\u0006\u0011D/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i\u0007>l\u0007/\u001e;fI\u000e{G.^7o\u0003:$\u0007+^:i\t><h\u000e\u000b\u0003\u0002L\u0006\u001d\u0003BBAj\u0001\u0011\u0005!.\u0001\u0010uKN$8)\u001e:sK:$H)\u0019;f\u0013:Tu.\u001b8D_:$\u0017\u000e^5p]\"\"\u0011\u0011[A$\u0011\u0019\tI\u000e\u0001C\u0001U\u0006!C/Z:u\u0019>|7.\u001e9DC\u000eDWm\u00155be&tw-Q2s_N\u001c8+\u001e2uCN\\7\u000f\u000b\u0003\u0002X\u0006\u001d\u0003bBAp\u0001\u0011\u0005\u0011\u0011]\u0001\u0003U&$B!a9\u0002tB!\u0011Q]Ax\u001b\t\t9O\u0003\u0003\u0002j\u0006-\u0018\u0001\u00027b]\u001eT!!!<\u0002\t)\fg/Y\u0005\u0005\u0003c\f9OA\u0004J]R,w-\u001a:\t\u0011\u0005U\u0018Q\u001ca\u0001\u0003O\t\u0011!\u001b\u0005\b\u0003s\u0004A\u0011AA~\u0003\tQG\u000e\u0006\u0003\u0002~\n\r\u0001\u0003BAs\u0003\u007fLAA!\u0001\u0002h\n!Aj\u001c8h\u0011!\u0011)!a>A\u0002\t\u001d\u0011!\u00017\u0011\u0007u\u0011I!C\u0002\u0003\u0002yAaA!\u0004\u0001\t\u0003Q\u0017\u0001\n;fgR\fumZ!oI2+g\r\u001e&pS:<\u0016\u000e\u001e5Uef\u0014Vm]8mm\u0016lu\u000eZ3)\t\t-\u0011q\t\u0005\u0007\u0005'\u0001A\u0011\u00016\u0002eQ,7\u000f^!hO\u0006sG\rT3gi*{\u0017N\\!mY\u000e{gn\u001d;b]R\\U-_,ji\"$&/\u001f*fg>dg/Z'pI\u0016DCA!\u0005\u0002H!1!\u0011\u0004\u0001\u0005\u0002)\fa\u0006^3ti\u0006;w-\u00118e\u0015>Lg.\u00117m\u0007>t7\u000f^1oi.+\u0017pV5uQR\u0013\u0018PU3t_24X-T8eK\"\"!qCA$\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005C\t!cZ3u%\u0016$(/\u001f'p_.,\b\u000fS5oiR1\u0011\u0011\u0001B\u0012\u0005OA\u0001B!\n\u0003\u001e\u0001\u0007\u0011\u0011A\u0001\fY>|7.\u001e9UC\ndW\r\u0003\u0005\u0003*\tu\u0001\u0019AA\u0014\u0003-i\u0017\r_!ui\u0016l\u0007\u000f^:\t\r\t5\u0002\u0001\"\u0001k\u0003y!Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5SKR\u0014\u0018\u0010\u000b\u0003\u0003,\u0005\u001d\u0003B\u0002B\u001a\u0001\u0011\u0005!.A\u001fuKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDGj\\8lkB$\u0006N]3tQ>dGmV5uQ&s7/\u001e4gS\u000eLWM\u001c;SKR\u0014\u0018\u0010\u000b\u0003\u00032\u0005\u001d\u0003B\u0002B\u001d\u0001\u0011\u0005!.A\u001euKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDGj\\8lkB$\u0006N]3tQ>dGmV5uQN+hMZ5dS\u0016tGOU3uefDCAa\u000e\u0002H!1!q\b\u0001\u0005\u0002)\fq\u0007^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ2{wn[;q)\"\u0014Xm\u001d5pY\u0012<\u0016\u000e\u001e5MCJ<WM\u001d*fiJL\b\u0006\u0002B\u001f\u0003\u000fB\u0011B!\u0012\u0001#\u0003%IAa\u0012\u00027\r\u0014X-\u0019;f\u0019>|7.\u001e9UC\ndW\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011IE\u000b\u0003\u0002(\t-3F\u0001B'!\u0011\u0011yE!\u0017\u000e\u0005\tE#\u0002\u0002B*\u0005+\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t]c$\u0001\u0006b]:|G/\u0019;j_:LAAa\u0017\u0003R\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3)\u000f\u0001\u0011yFa\u001b\u0003nA!!\u0011\rB4\u001b\t\u0011\u0019GC\u0002\u0003fE\faA];o]\u0016\u0014\u0018\u0002\u0002B5\u0005G\u0012qAU;o/&$\b.A\u0003wC2,Xm\t\u0002\u0003pA!!\u0011\u000fB<\u001b\t\u0011\u0019HC\u0002\u0003vE\fqA];o]\u0016\u00148/\u0003\u0003\u0003z\tM$!\u0004)be\u0006lW\r^3sSj,GmB\u0004\u0003~\tA\tAa \u0002!1{wn[;q\u0015>Lg.\u0013+DCN,\u0007c\u0001$\u0003\u0002\u001a1\u0011A\u0001E\u0001\u0005\u0007\u001bBA!!\u0003\u0006B\u0019QDa\"\n\u0007\t%eD\u0001\u0004B]f\u0014VM\u001a\u0005\b\u0007\n\u0005E\u0011\u0001BG)\t\u0011y\b\u0003\u0006\u0003\u0012\n\u0005%\u0019!C\u0001\u0005'\u000b1\u0003T#H\u0003\u000eKv\fV!C\u0019\u0016{6kT+S\u0007\u0016+\"A!&\u0011\t\u0005\u0015(qS\u0005\u0004C\u0005\u001d\b\"\u0003BN\u0005\u0003\u0003\u000b\u0011\u0002BK\u0003QaUiR!D3~#\u0016I\u0011'F?N{UKU\"FA!Q!q\u0014BA\u0005\u0004%\tAa%\u0002)\u0011Kf*Q'J\u0007~#\u0016I\u0011'F?N{UKU\"F\u0011%\u0011\u0019K!!!\u0002\u0013\u0011)*A\u000bE3:\u000bU*S\"`)\u0006\u0013E*R0T\u001fV\u00136)\u0012\u0011\t\u0011\t\u001d&\u0011\u0011C\u0001\u0005S\u000b!\u0002]1sC6,G/\u001a:t)\t\u0011Y\u000b\u0005\u0004\u0003.\nM&qW\u0007\u0003\u0005_SAA!-\u0002l\u0006!Q\u000f^5m\u0013\u0011\u0011)La,\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0003\u001e\u0005s\u0013i,C\u0002\u0003<z\u0011Q!\u0011:sCf\u0004B!!:\u0003@&!!\u0011YAt\u0005\u0019y%M[3di\"B!Q\u0015Bc\u0005'\u0014)\u000e\u0005\u0003\u0003H\n5g\u0002\u0002B9\u0005\u0013LAAa3\u0003t\u0005i\u0001+\u0019:b[\u0016$XM]5{K\u0012LAAa4\u0003R\nQ\u0001+\u0019:b[\u0016$XM]:\u000b\t\t-'1O\u0001\u0005]\u0006lW-\t\u0002\u0003X\u0006!C*Z4bGf$\u0016M\u00197f'>,(oY3>wBjH\u0006I2bG\",G+\u001f9f{m\fT\u0010")
public class LookupJoinITCase
extends StreamingTestBase {
    private final boolean legacyTableSource;
    private final LookupOptions.LookupCacheType cacheType;
    private final List<Row> data;
    private final List<Row> dataWithNull;
    private final List<Row> userData;
    private final List<Row> userDataWithNull;

    @Parameterized.Parameters(name="LegacyTableSource={0}, cacheType={1}")
    public static Collection<Object[]> parameters() {
        return LookupJoinITCase$.MODULE$.parameters();
    }

    public static Boolean DYNAMIC_TABLE_SOURCE() {
        return LookupJoinITCase$.MODULE$.DYNAMIC_TABLE_SOURCE();
    }

    public static Boolean LEGACY_TABLE_SOURCE() {
        return LookupJoinITCase$.MODULE$.LEGACY_TABLE_SOURCE();
    }

    public List<Row> data() {
        return this.data;
    }

    public List<Row> dataWithNull() {
        return this.dataWithNull;
    }

    public List<Row> userData() {
        return this.userData;
    }

    public List<Row> userDataWithNull() {
        return this.userDataWithNull;
    }

    @Override
    @Before
    public void before() {
        super.before();
        if (this.legacyTableSource) {
            InMemoryLookupableTableSource$.MODULE$.RESOURCE_COUNTER().set(0);
        } else {
            TestValuesTableFactory.RESOURCE_COUNTER.set(0);
            FullCacheTestInputFormat.OPEN_CLOSED_COUNTER.set(0);
        }
        this.createScanTable("src", this.data());
        this.createScanTable("nullable_src", this.dataWithNull());
        this.createLookupTable("user_table", this.userData(), this.createLookupTable$default$3());
        this.createLookupTable("nullable_user_table", this.userDataWithNull(), this.createLookupTable$default$3());
        this.createLookupTable("user_table_with_lookup_threshold2", this.userData(), 2);
        this.createLookupTable("user_table_with_lookup_threshold3", this.userData(), 3);
        this.createLookupTableWithComputedColumn("userTableWithComputedColumn", this.userData());
    }

    @Override
    @After
    public void after() {
        if (this.legacyTableSource) {
            Assert.assertEquals((long)0L, (long)InMemoryLookupableTableSource$.MODULE$.RESOURCE_COUNTER().get());
        } else {
            Assert.assertEquals((long)0L, (long)TestValuesTableFactory.RESOURCE_COUNTER.get());
            Assert.assertEquals((long)0L, (long)FullCacheTestInputFormat.OPEN_CLOSED_COUNTER.get());
        }
    }

    private void createLookupTable(String tableName, List<Row> data, int lookupThreshold) {
        if (this.legacyTableSource) {
            TableSchema userSchema = TableSchema.builder().field("age", Types.INT()).field("id", Types.LONG()).field("name", Types.STRING()).build();
            InMemoryLookupableTableSource$.MODULE$.createTemporaryTable((TableEnvironment)this.tEnv(), false, data, userSchema, tableName, InMemoryLookupableTableSource$.MODULE$.createTemporaryTable$default$6());
        } else {
            String string;
            String dataId = TestValuesTableFactory.registerData(data);
            LookupOptions.LookupCacheType lookupCacheType = this.cacheType;
            LookupOptions.LookupCacheType lookupCacheType2 = LookupOptions.LookupCacheType.PARTIAL;
            if (!(lookupCacheType != null ? !lookupCacheType.equals(lookupCacheType2) : lookupCacheType2 != null)) {
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.PARTIAL).append("',\n             |  '").append(LookupOptions.PARTIAL_CACHE_MAX_ROWS.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin();
            } else {
                LookupOptions.LookupCacheType lookupCacheType3 = this.cacheType;
                LookupOptions.LookupCacheType lookupCacheType4 = LookupOptions.LookupCacheType.FULL;
                string = !(lookupCacheType3 != null ? !lookupCacheType3.equals(lookupCacheType4) : lookupCacheType4 != null) ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(90).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.FULL).append("',\n             |  '").append(LookupOptions.FULL_CACHE_RELOAD_STRATEGY.key()).append("' = '").append(LookupOptions.ReloadStrategy.PERIODIC).append("',\n             |  '").append(LookupOptions.FULL_CACHE_PERIODIC_RELOAD_INTERVAL.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin() : "";
            }
            String cacheOptions = string;
            String lookupThresholdOption = lookupThreshold > 0 ? new StringBuilder(28).append("'start-lookup-threshold'='").append(lookupThreshold).append("',").toString() : "";
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(407).append("\n                         |CREATE TABLE ").append(tableName).append(" (\n                         |  `age` INT,\n                         |  `id` BIGINT,\n                         |  `name` STRING\n                         |) WITH (\n                         |  ").append(cacheOptions).append("\n                         |  ").append(lookupThresholdOption).append("\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(dataId).append("'\n                         |)\n                         |").toString())).stripMargin());
        }
    }

    private int createLookupTable$default$3() {
        return -1;
    }

    private void createLookupTableWithComputedColumn(String tableName, List<Row> data) {
        block2: {
            String string;
            if (this.legacyTableSource) break block2;
            String dataId = TestValuesTableFactory.registerData(data);
            LookupOptions.LookupCacheType lookupCacheType = this.cacheType;
            LookupOptions.LookupCacheType lookupCacheType2 = LookupOptions.LookupCacheType.PARTIAL;
            if (!(lookupCacheType != null ? !lookupCacheType.equals(lookupCacheType2) : lookupCacheType2 != null)) {
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.PARTIAL).append("',\n             |  '").append(LookupOptions.PARTIAL_CACHE_MAX_ROWS.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin();
            } else {
                LookupOptions.LookupCacheType lookupCacheType3 = this.cacheType;
                LookupOptions.LookupCacheType lookupCacheType4 = LookupOptions.LookupCacheType.FULL;
                string = !(lookupCacheType3 != null ? !lookupCacheType3.equals(lookupCacheType4) : lookupCacheType4 != null) ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(90).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.FULL).append("',\n             |  '").append(LookupOptions.FULL_CACHE_RELOAD_STRATEGY.key()).append("' = '").append(LookupOptions.ReloadStrategy.PERIODIC).append("',\n             |  '").append(LookupOptions.FULL_CACHE_PERIODIC_RELOAD_INTERVAL.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin() : "";
            }
            String cacheOptions = string;
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(432).append("\n                         |CREATE TABLE ").append(tableName).append(" (\n                         |  `age` INT,\n                         |  `id` BIGINT,\n                         |  `name` STRING,\n                         |  `nominal_age` as age + 1\n                         |) WITH (\n                         |  ").append(cacheOptions).append("\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(dataId).append("'\n                         |)\n                         |").toString())).stripMargin());
        }
    }

    private void createScanTable(String tableName, List<Row> data) {
        String dataId = TestValuesTableFactory.registerData(data);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(386).append("\n                       |CREATE TABLE ").append(tableName).append(" (\n                       |  `id` BIGINT,\n                       |  `len` INT,\n                       |  `content` STRING,\n                       |  `proctime` AS PROCTIME()\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
    }

    @Test
    public void testJoinTemporalTable() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableWithUdfFilter() {
        this.tEnv().registerFunction("add", (ScalarFunction)new UserDefinedFunctionTestUtils.TestAddWithOpen());
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id WHERE add(T.id, D.id) > 3 AND add(T.id, 2) > 3 AND add (D.id, 2) > 3";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        Assert.assertEquals((long)0L, (long)UserDefinedFunctionTestUtils$TestAddWithOpen$.MODULE$.aliveCounter().get());
    }

    @Test
    public void testJoinTemporalTableWithUdfEqualFilter() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.id, T.len, T.content, D.name\n        |FROM\n        |  src AS T JOIN user_table for system_time as of T.proctime AS D\n        |ON T.id = D.id\n        |WHERE CONCAT('Hello-', D.name) = 'Hello-Jark'\n        |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnConstantKey() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON D.id = 1";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Julian", "3,15,Fabian,Julian", "8,11,Hello world,Julian", "9,12,Hello world!,Julian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnNullableKey() {
        String sql = "SELECT T.id, T.len, D.name FROM nullable_src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableWithPushDown() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND D.age > 20";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableWithNonEqualFilter() {
        String sql = "SELECT T.id, T.len, T.content, D.name, D.age FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id WHERE T.len <= D.age";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark,22", "3,15,Fabian,Fabian,33"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnMultiFields() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND T.content = D.name";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFields() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFields2() {
        String sql = "SELECT t1.id, t1.len, D.name FROM (select proctime, content, id, len FROM src) t1 JOIN user_table for system_time as of t1.proctime AS D ON t1.content = D.name AND t1.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFieldsWithConstantKey() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.content = D.name AND 3 = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFieldsWithStringConstantKey() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON D.name = 'Fabian' AND T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnMultiConstantKey() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON D.name = 'Fabian' AND 3 = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Fabian", "2,15,Fabian", "3,15,Fabian", "8,11,Fabian", "9,12,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLeftJoinTemporalTable() {
        String sql = "SELECT T.id, T.len, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,11", "2,15,Jark,22", "3,15,Fabian,33", "8,11,null,null", "9,12,null,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLeftJoinTemporalTableOnNullableKey() {
        String sql = "SELECT T.id, T.len, D.name FROM nullable_src AS T LEFT OUTER JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"null,15,null", "3,15,Fabian", "null,11,null", "9,12,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLeftJoinTemporalTableOnMultKeyFields() {
        String sql = "SELECT T.id, T.len, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id and T.content = D.name";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,11", "2,15,null,null", "3,15,Fabian,33", "8,11,null,null", "9,12,null,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = "SELECT T.id, T.len, D.name FROM nullable_src AS T JOIN nullable_user_table for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLeftJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = "SELECT D.id, T.len, D.name FROM nullable_src AS T LEFT JOIN nullable_user_table for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"null,15,null", "3,15,Fabian", "null,11,null", "null,12,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableOnNullConstantKey() {
        String sql = "SELECT T.id, T.len, T.content FROM nullable_src AS T JOIN nullable_user_table for system_time as of T.proctime AS D ON D.id = null";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Assert.assertTrue((boolean)sink.getAppendResults().isEmpty());
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullConstantKey() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.content = D.name AND null = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Assert.assertTrue((boolean)sink.getAppendResults().isEmpty());
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFieldsWithUDF() {
        String sql = "SELECT T.id, T.content, D.age, D.id FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id + 4 AND T.content = concat(D.name, '!') AND D.age = 11";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"9,Hello world!,11,5"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableWithComputedColumn() {
        if (this.legacyTableSource) {
            return;
        }
        String sql = new StringBuilder(159).append("SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age ").append("FROM src AS T JOIN userTableWithComputedColumn ").append("for system_time as of T.proctime AS D ON T.id = D.id").toString();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian,11,12", "2,15,Hello,Jark,22,23", "3,15,Fabian,Fabian,33,34"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableWithComputedColumnAndPushDown() {
        if (this.legacyTableSource) {
            return;
        }
        String sql = new StringBuilder(182).append("SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age ").append("FROM src AS T JOIN userTableWithComputedColumn ").append("for system_time as of T.proctime AS D ON T.id = D.id and D.nominal_age > 12").toString();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark,22,23", "3,15,Fabian,Fabian,33,34"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCurrentDateInJoinCondition() {
        String id1 = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"abc", LocalDateTime.of(2000, 1, 1, 0, 0)})}))));
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(246).append("\n         |CREATE TABLE Ta (\n         |  id VARCHAR,\n         |  ts TIMESTAMP,\n         |  proc AS PROCTIME()\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(id1).append("',\n         |  'bounded' = 'true'\n         |)\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl1);
        String id2 = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"abc", LocalDateTime.of(2000, 1, 2, 0, 0)})}))));
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(214).append("\n         |CREATE TABLE Tb (\n         |  id VARCHAR,\n         |  ts TIMESTAMP\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(id2).append("',\n         |  'bounded' = 'true'\n         |)\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl2);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM Ta AS t1\n        |INNER JOIN Tb FOR SYSTEM_TIME AS OF t1.proc AS t2\n        |ON t1.id = t2.id\n        |WHERE\n        |  CAST(coalesce(t1.ts, t2.ts) AS VARCHAR)\n        |  >=\n        |  CONCAT(CAST(CURRENT_DATE AS VARCHAR), ' 00:00:00')\n        |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), sink.getAppendResults());
    }

    @Test
    public void testLookupCacheSharingAcrossSubtasks() {
        LookupOptions.LookupCacheType lookupCacheType = this.cacheType;
        LookupOptions.LookupCacheType lookupCacheType2 = LookupOptions.LookupCacheType.NONE;
        if (!(lookupCacheType != null ? !lookupCacheType.equals(lookupCacheType2) : lookupCacheType2 != null)) {
            return;
        }
        LookupCacheManager.keepCacheOnRelease((boolean)true);
        try {
            String sourceDdl = new StringOps(Predef$.MODULE$.augmentString("\n           |CREATE TABLE T (\n           |  id BIGINT,\n           |  proc AS PROCTIME()\n           |) WITH (\n           |  'connector' = 'datagen',\n           |  'fields.id.kind' = 'sequence',\n           |  'fields.id.start' = '1',\n           |  'fields.id.end' = '6'\n           |)\n           |")).stripMargin();
            this.tEnv().executeSql(sourceDdl);
            String sql = new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT T.id, D.name, D.age FROM T \n          |LEFT JOIN user_table FOR SYSTEM_TIME AS OF T.proc AS D \n          |ON T.id = D.id\n          |")).stripMargin();
            TestingAppendSink sink = new TestingAppendSink();
            package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
            this.env().execute();
            Map managedCaches = LookupCacheManager.getInstance().getManagedCaches();
            Assertions.assertThat((int)managedCaches.size()).isEqualTo(1);
            LookupOptions.LookupCacheType lookupCacheType3 = this.cacheType;
            LookupOptions.LookupCacheType lookupCacheType4 = LookupOptions.LookupCacheType.PARTIAL;
            int numEntries = !(lookupCacheType3 != null ? !lookupCacheType3.equals(lookupCacheType4) : lookupCacheType4 != null) ? 6 : this.userData().size();
            LookupCache cache = ((LookupCacheManager.RefCountedCache)managedCaches.get(managedCaches.keySet().iterator().next())).getCache();
            Assertions.assertThat((long)cache.size()).isEqualTo((long)numEntries);
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(1L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(11), this.jl(1L), BinaryStringData.fromString((String)"Julian")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(2L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(22), this.jl(2L), BinaryStringData.fromString((String)"Jark")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(3L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(33), this.jl(3L), BinaryStringData.fromString((String)"Fabian")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(4L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(11), this.jl(4L), BinaryStringData.fromString((String)"Hello world")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(5L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(11), this.jl(5L), BinaryStringData.fromString((String)"Hello world")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(6L)}))).isEmpty();
        }
        finally {
            LookupCacheManager.getInstance().checkAllReleased();
            LookupCacheManager.getInstance().clear();
            LookupCacheManager.keepCacheOnRelease((boolean)false);
        }
    }

    public Integer ji(int i) {
        return new Integer(i);
    }

    public Long jl(long l) {
        return new Long(l);
    }

    @Test
    public void testAggAndLeftJoinWithTryResolveMode() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY, (Object)OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE);
        String sql1 = "SELECT max(id) as id, PROCTIME() as proctime FROM src AS T group by len";
        Table table1 = this.tEnv().sqlQuery(sql1);
        this.tEnv().registerTable("t1", table1);
        String sql2 = "SELECT t1.id, D.name, D.age FROM t1 LEFT JOIN user_table for system_time as of t1.proctime AS D ON t1.id = D.id";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql2)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,Fabian,33", "8,null,null", "9,null,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAggAndLeftJoinAllConstantKeyWithTryResolveMode() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY, (Object)OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE);
        String sql1 = "SELECT max(id) as id, PROCTIME() as proctime FROM src AS T group by len";
        Table table1 = this.tEnv().sqlQuery(sql1);
        this.tEnv().registerTable("t1", table1);
        String sql2 = "SELECT t1.id, D.name, D.age FROM t1 LEFT JOIN user_table for system_time as of t1.proctime AS D ON D.id = 3";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql2)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,Fabian,33", "8,Fabian,33", "9,Fabian,33"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAggAndJoinAllConstantKeyWithTryResolveMode() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY, (Object)OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE);
        String sql1 = "SELECT max(id) as id, PROCTIME() as proctime FROM src AS T group by len";
        Table table1 = this.tEnv().sqlQuery(sql1);
        this.tEnv().registerTable("t1", table1);
        String sql2 = "SELECT t1.id FROM t1 LEFT JOIN user_table for system_time as of t1.proctime AS D ON D.id = 3";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql2)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3", "8", "9"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    private String getRetryLookupHint(String lookupTable, int maxAttempts) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(178).append("\n       |/*+ LOOKUP('table'='").append(lookupTable).append("', 'retry-predicate'='lookup_miss',\n       | 'retry-strategy'='fixed_delay',\n       |  'fixed-delay'='5 ms',\n       |   'max-attempts'='").append(maxAttempts).append("')\n       |*/").toString())).stripMargin();
    }

    @Test
    public void testJoinTemporalTableWithRetry() {
        String maxRetryTwiceHint = this.getRetryLookupHint("user_table", 2);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(203).append("\n                   |SELECT ").append(maxRetryTwiceHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testJoinTemporalTableWithLookupThresholdWithInsufficientRetry() {
        maxRetryOnceHint = this.getRetryLookupHint("user_table_with_lookup_threshold3", 1);
        sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(226).append("\n                   |SELECT ").append(maxRetryOnceHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table_with_lookup_threshold3 for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        if (this.legacyTableSource) ** GOTO lbl-1000
        v0 = this.cacheType;
        var4_3 = LookupOptions.LookupCacheType.FULL;
        if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null)) lbl-1000:
        // 2 sources

        {
            v1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        } else {
            v1 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        expected = v1;
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableWithLookupThresholdWithSufficientRetry() {
        String maxRetryTwiceHint = this.getRetryLookupHint("user_table_with_lookup_threshold2", 2);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(226).append("\n                   |SELECT ").append(maxRetryTwiceHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table_with_lookup_threshold2 for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testJoinTemporalTableWithLookupThresholdWithLargerRetry() {
        String largerRetryHint = this.getRetryLookupHint("user_table_with_lookup_threshold2", 10);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(226).append("\n                   |SELECT ").append(largerRetryHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table_with_lookup_threshold2 for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public LookupJoinITCase(boolean legacyTableSource, LookupOptions.LookupCacheType cacheType) {
        this.legacyTableSource = legacyTableSource;
        this.cacheType = cacheType;
        this.data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)12), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToInteger((int)15), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToInteger((int)15), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)8L), BoxesRunTime.boxToInteger((int)11), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToInteger((int)12), "Hello world!"})), (List)Nil$.MODULE$)))));
        this.dataWithNull = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)15), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToInteger((int)15), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)11), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToInteger((int)12), "Hello world!"})), (List)Nil$.MODULE$))));
        this.userData = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToLong((long)2L), "Jark"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)4L), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)5L), "Hello world"})), (List)Nil$.MODULE$)))));
        this.userDataWithNull = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), null, "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)44), null, "Hello world"})), (List)Nil$.MODULE$))));
    }
}

