/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.jsonplan;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.runtime.utils.TestData;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.types.Row;
import org.junit.Test;

public class CalcJsonPlanITCase
extends JsonPlanTestBase {
    @Test
    public void testSimpleCalc() throws Exception {
        List<String> data = Arrays.asList("1,1,hi", "2,1,hello", "3,2,hello world");
        this.createTestCsvSourceTable("MyTable", data, "a bigint", "b int not null", "c varchar");
        File sinkPath = this.createTestCsvSinkTable("MySink", "a bigint", "a1 varchar", "b int", "c1 varchar");
        this.compileSqlAndExecutePlan("insert into MySink select a, cast(a as varchar) as a1, b, substring(c, 1, 8) as c1 from MyTable where b > 1").await();
        this.assertResult(Collections.singletonList("3,3,2,hello wo"), sinkPath);
    }

    @Test
    public void testCalcWithUdf() throws Exception {
        this.tableEnv.createTemporaryFunction("udf1", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.JavaFunc0());
        this.tableEnv.createTemporarySystemFunction("udf2", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.JavaFunc2());
        this.tableEnv.createFunction("udf3", JavaUserDefinedScalarFunctions.UdfWithOpen.class);
        this.createTestValuesSourceTable("MyTable", (List<Row>)JavaScalaConversionUtil.toJava(TestData.smallData3()), "a int", "b bigint", "c varchar");
        File sinkPath = this.createTestCsvSinkTable("MySink", "a int", "a1 varchar", "b bigint", "c1 varchar", "c2 varchar");
        this.compileSqlAndExecutePlan("insert into MySink select a, cast(a as varchar) as a1, b, udf2(c, a) as c1, udf3(substring(c, 1, 8)) as c2 from MyTable where (udf1(a) > 2 or (a * b) > 1) and b > 0").await();
        this.assertResult(Arrays.asList("2,2,2,Hello2,$Hello", "3,3,2,Hello world3,$Hello wo"), sinkPath);
    }
}

