/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.harness;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl$;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.runtime.harness.HarnessTestBase;
import org.apache.flink.table.planner.runtime.harness.RankHarnessTest$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\u0001\u0003\u0001E\u0011qBU1oW\"\u000b'O\\3tgR+7\u000f\u001e\u0006\u0003\u0007\u0011\tq\u0001[1s]\u0016\u001c8O\u0003\u0002\u0006\r\u00059!/\u001e8uS6,'BA\u0004\t\u0003\u001d\u0001H.\u00198oKJT!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u0010\u0011\u0006\u0014h.Z:t)\u0016\u001cHOQ1tK\"Aq\u0003\u0001B\u0001B\u0003%\u0001$\u0001\u0003n_\u0012,\u0007CA\r0\u001d\tQBF\u0004\u0002\u001cU9\u0011A$\u000b\b\u0003;!r!AH\u0014\u000f\u0005}1cB\u0001\u0011&\u001d\t\tC%D\u0001#\u0015\t\u0019\u0003#\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011QBD\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\tYC!A\u0003vi&d7/\u0003\u0002.]\u0005Q2\u000b\u001e:fC6LgnZ,ji\"\u001cF/\u0019;f)\u0016\u001cHOQ1tK*\u00111\u0006B\u0005\u0003aE\u0012\u0001c\u0015;bi\u0016\u0014\u0015mY6f]\u0012lu\u000eZ3\u000b\u00055r\u0003\"B\u001a\u0001\t\u0003!\u0014A\u0002\u001fj]&$h\b\u0006\u00026mA\u00111\u0003\u0001\u0005\u0006/I\u0002\r\u0001\u0007\u0005\u0006q\u0001!\t%O\u0001\u0007E\u00164wN]3\u0015\u0003i\u0002\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012A!\u00168ji\"\u0012q'\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t:\tQA[;oSRL!AR\"\u0003\r\t+gm\u001c:f\u0011\u0015A\u0005\u0001\"\u0001:\u0003q!Xm\u001d;SKR\u0014\u0018m\u0019;SC:\\w+\u001b;i%><h*^7cKJD#a\u0012&\u0011\u0005\t[\u0015B\u0001'D\u0005\u0011!Vm\u001d;\t\u000b9\u0003A\u0011A\u001d\u0002?Q,7\u000f\u001e*fiJ\f7\r\u001e*b].<\u0016\u000e\u001e5pkR\u0014vn\u001e(v[\n,'\u000f\u000b\u0002N\u0015\")\u0011\u000b\u0001C\u0001%\u0006!\u0003O]3qCJ,W\u000b\u001d3bi\u0016\u0014\u0016M\\6XSRD'k\\<Ok6\u0014WM\u001d+fgR,'\u000fF\u0001T!\u0011YDK\u00163\n\u0005Uc$A\u0002+va2,'\u0007E\u0003X9zsf,D\u0001Y\u0015\tI&,\u0001\u0003vi&d'BA.\u000b\u0003%\u0019HO]3b[&tw-\u0003\u0002^1\n13*Z=fI>sW-\u00138qkR\u001cFO]3b[>\u0003XM]1u_J$Vm\u001d;ICJtWm]:\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005D\u0011\u0001\u00023bi\u0006L!a\u00191\u0003\u000fI{w\u000fR1uCB\u0011Q\r[\u0007\u0002M*\u0011\u0011l\u001a\u0006\u0003\u000b!I!!\u001b4\u0003-I{w\u000fR1uC\"\u000b'O\\3tg\u0006\u001b8/\u001a:u_JDQa\u001b\u0001\u0005\u0002e\nQ\u0006^3tiV\u0003H-\u0019;f%\u0006t7nV5uQJ{wOT;nE\u0016\u00148k\u001c:u\u0017\u0016LHI]8qgR{G*Y:uQ\tQ'\nC\u0003o\u0001\u0011\u0005\u0011(\u0001\u001cuKN$X\u000b\u001d3bi\u0016\u0014\u0016M\\6XSRD'k\\<Ok6\u0014WM]*peR\\U-\u001f#s_B\u001c()\u001e;SC:\\WK\\2iC:<W\r\u000b\u0002n\u0015\")\u0011\u000f\u0001C\u0001s\u0005\u0001D/Z:u+B$\u0017\r^3SC:\\w+\u001b;i%><h*^7cKJ\u001cvN\u001d;LKf$%o\u001c9t)>tu\u000e\u001e'bgRD#\u0001\u001d&\t\u000bQ\u0004A\u0011A\u001d\u0002mQ,7\u000f^+qI\u0006$XMU1oW^KG\u000f\u001b*po:+XNY3s\u0007\u0006tG-\u001b3bi\u0016\u001cH*\u0019:hKJ$\u0006.\u00198SC:\\WI\u001c3)\u0005MT\u0005\"B<\u0001\t\u0003I\u0014a\r;fgR,\u0006\u000fZ1uKJ\u000bgn[,ji\"\u0014vn\u001e(v[\n,'oU8si.+\u0017\u0010\u0012:paN|U\u000f^(g%\u0006tG-\u00128eQ\t1(\n\u000b\u0004\u0001u\u0006\u0005\u00111\u0001\t\u0003wzl\u0011\u0001 \u0006\u0003{\u000e\u000baA];o]\u0016\u0014\u0018BA@}\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c#!!\u0002\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003D\u0003\u001d\u0011XO\u001c8feNLA!a\u0004\u0002\n\ti\u0001+\u0019:b[\u0016$XM]5{K\u0012\u0004")
public class RankHarnessTest
extends HarnessTestBase {
    @Override
    @Before
    public void before() {
        super.before();
        EnvironmentSettings setting = EnvironmentSettings.newInstance().inStreamingMode().build();
        this.tEnv_$eq((StreamTableEnvironment)StreamTableEnvironmentImpl$.MODULE$.create(this.env(), setting));
    }

    @Test
    public void testRetractRankWithRowNumber() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.harness.RankHarnessTest$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        this.tEnv().createTemporarySystemFunction("STRING_SPLIT", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c, id, rn1\n        |FROM (\n        |   SELECT a, b, c, t3.id id,\n        |    ROW_NUMBER() OVER (PARTITION BY a, t3.id ORDER BY c DESC) AS rn1\n        |   FROM (\n        |       SELECT a, b, c, rn\n        |       FROM\n        |       (\n        |           -- append rank\n        |           SELECT a, b, c,\n        |               ROW_NUMBER() OVER (PARTITION BY a ORDER BY c DESC) AS rn\n        |           FROM T\n        |       ) t1\n        |       WHERE rn = 1\n        |   ) t2, LATERAL TABLE(STRING_SPLIT(b, '#')) AS t3(id)\n        |) WHERE rn1 <= 2\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)), "Rank(strategy=[RetractStrategy");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        testHarness.open();
        testHarness.setStateTtlProcessingTime(1L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(1L), "1"}));
        testHarness.setStateTtlProcessingTime(1000L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.setStateTtlProcessingTime(1001L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        Collection<Object> result = this.dropWatermarks(testHarness.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1", Predef$.MODULE$.long2Long(2L)}));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness.close();
    }

    @Test
    public void testRetractRankWithoutRowNumber() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.harness.RankHarnessTest$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
        this.tEnv().createTemporarySystemFunction("STRING_SPLIT", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c, id\n        |FROM (\n        |   SELECT a, b, c, t3.id id,\n        |    ROW_NUMBER() OVER (PARTITION BY a, t3.id ORDER BY c DESC) AS rn1\n        |   FROM (\n        |       SELECT a, b, c, rn\n        |       FROM\n        |       (\n        |           -- append rank\n        |           SELECT a, b, c,\n        |               ROW_NUMBER() OVER (PARTITION BY a ORDER BY c DESC) AS rn\n        |           FROM T\n        |       ) t1\n        |       WHERE rn = 1\n        |   ) t2, LATERAL TABLE(STRING_SPLIT(b, '#')) AS t3(id)\n        |) WHERE rn1 = 1\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)), "Rank(strategy=[RetractStrategy");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType()}));
        testHarness.open();
        testHarness.setStateTtlProcessingTime(1L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(1L), "1"}));
        testHarness.setStateTtlProcessingTime(1000L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.setStateTtlProcessingTime(1001L);
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        testHarness.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        Collection<Object> result = this.dropWatermarks(testHarness.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.DELETE, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", "1", Predef$.MODULE$.long2Long(2L), "1"}));
        assertor.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness.close();
    }

    public Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> prepareUpdateRankWithRowNumberTester() {
        MutableList data = new MutableList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Object>>(this, fieldSerializers){

                    public Tuple3<String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.harness.RankHarnessTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "word")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cnt")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "type"))}));
        this.tEnv().createTemporaryView("T", t);
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT word, cnt, rank_num\n        |FROM (\n        |  SELECT word, cnt,\n        |      ROW_NUMBER() OVER (PARTITION BY type ORDER BY cnt DESC) as rank_num\n        |  FROM (\n        |     select word, type, sum(cnt) filter (where cnt > 0) cnt from T group by word, type\n        |   )\n        |  )\n        |WHERE rank_num <= 6\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)), "Rank(strategy=[UpdateFastStrategy");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.INT().getLogicalType(), DataTypes.INT().getLogicalType(), DataTypes.BIGINT().getLogicalType()}));
        return new Tuple2(testHarness, (Object)assertor);
    }

    @Test
    public void testUpdateRankWithRowNumberSortKeyDropsToLast() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareUpdateRankWithRowNumberTester();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple23._2();
        testHarness2.open();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(10)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(10), Predef$.MODULE$.long2Long(6L)}));
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    @Test
    public void testUpdateRankWithRowNumberSortKeyDropsButRankUnchange() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareUpdateRankWithRowNumberTester();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple23._2();
        testHarness2.open();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(88)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(88), Predef$.MODULE$.long2Long(3L)}));
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    @Test
    public void testUpdateRankWithRowNumberSortKeyDropsToNotLast() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareUpdateRankWithRowNumberTester();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple23._2();
        testHarness2.open();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    @Test
    public void testUpdateRankWithRowNumberCandidatesLargerThanRankEnd() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareUpdateRankWithRowNumberTester();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple23._2();
        testHarness2.open();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"g", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(60)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"h", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(50)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    @Test
    public void testUpdateRankWithRowNumberSortKeyDropsOutOfRandEnd() {
        Tuple2<KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData>, RowDataHarnessAssertor> tuple2 = this.prepareUpdateRankWithRowNumberTester();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KeyedOneInputStreamOperatorTestHarness testHarness = (KeyedOneInputStreamOperatorTestHarness)tuple2._1();
        RowDataHarnessAssertor assertor = (RowDataHarnessAssertor)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)testHarness, (Object)assertor);
        Tuple2 tuple23 = tuple22;
        KeyedOneInputStreamOperatorTestHarness testHarness2 = (KeyedOneInputStreamOperatorTestHarness)tuple23._1();
        RowDataHarnessAssertor assertor2 = (RowDataHarnessAssertor)tuple23._2();
        testHarness2.open();
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"g", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(60)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"h", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(50)}));
        testHarness2.processElement(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(55)}));
        Collection<Object> result = this.dropWatermarks(testHarness2.getOutput().toArray());
        ConcurrentLinkedQueue<StreamRecord> expectedOutput = new ConcurrentLinkedQueue<StreamRecord>();
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"a", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(100), Predef$.MODULE$.long2Long(1L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"c", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(90), Predef$.MODULE$.long2Long(2L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"d", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(3L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"e", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(80), Predef$.MODULE$.long2Long(4L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(6L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"f", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(70), Predef$.MODULE$.long2Long(5L)}));
        expectedOutput.add(StreamRecordUtils.binaryRecord((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"b", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(55), Predef$.MODULE$.long2Long(6L)}));
        assertor2.assertOutputEqualsSorted("result mismatch", expectedOutput, result);
        testHarness2.close();
    }

    public RankHarnessTest(StreamingWithStateTestBase.StateBackendMode mode) {
        super(mode);
    }
}

