/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.join;

import java.util.Collection;
import java.util.Map;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.batch.sql.join.LookupJoinITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.InMemoryLookupableTableSource$;
import org.apache.flink.table.runtime.functions.table.fullcache.inputformat.FullCacheTestInputFormat;
import org.apache.flink.table.runtime.functions.table.lookup.LookupCacheManager;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\t\u0005d\u0001B\u0001\u0003\u0001U\u0011\u0001\u0003T8pWV\u0004(j\\5o\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011\u0001\u00026pS:T!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u0005)!-\u0019;dQ*\u0011\u0011BC\u0001\beVtG/[7f\u0015\tYA\"A\u0004qY\u0006tg.\u001a:\u000b\u00055q\u0011!\u0002;bE2,'BA\b\u0011\u0003\u00151G.\u001b8l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00033!\tQ!\u001e;jYNL!a\u0007\r\u0003\u001b\t\u000bGo\u00195UKN$()Y:f\u0011!i\u0002A!A!\u0002\u0013q\u0012!\u00057fO\u0006\u001c\u0017\u0010V1cY\u0016\u001cv.\u001e:dKB\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t9!i\\8mK\u0006t\u0007\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u0017%\u001c\u0018i]=oG6{G-\u001a\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005I1-Y2iKRK\b/\u001a\t\u0003S\rs!A\u000b!\u000f\u0005-jdB\u0001\u0017;\u001d\ti\u0003H\u0004\u0002/o9\u0011qF\u000e\b\u0003aUr!!\r\u001b\u000e\u0003IR!a\r\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0012BA\t\u0013\u0013\ty\u0001#\u0003\u0002\u000e\u001d%\u0011\u0011\bD\u0001\nG>tg.Z2u_JL!a\u000f\u001f\u0002\rM|WO]2f\u0015\tID\"\u0003\u0002?\u007f\u00051An\\8lkBT!a\u000f\u001f\n\u0005\u0005\u0013\u0015!\u0004'p_.,\bo\u00149uS>t7O\u0003\u0002?\u007f%\u0011A)\u0012\u0002\u0010\u0019>|7.\u001e9DC\u000eDW\rV=qK*\u0011\u0011I\u0011\u0005\u0006\u000f\u0002!\t\u0001S\u0001\u0007y%t\u0017\u000e\u001e \u0015\t%[E*\u0014\t\u0003\u0015\u0002i\u0011A\u0001\u0005\u0006;\u0019\u0003\rA\b\u0005\u0006K\u0019\u0003\rA\b\u0005\u0006O\u0019\u0003\r\u0001\u000b\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001Q\u0003\u0011!\u0017\r^1\u0016\u0003E\u00032AU,Z\u001b\u0005\u0019&B\u0001+V\u0003%IW.\\;uC\ndWM\u0003\u0002WA\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005a\u001b&\u0001\u0002'jgR\u0004\"AW/\u000e\u0003mS!\u0001\u0018\b\u0002\u000bQL\b/Z:\n\u0005y[&a\u0001*po\"1\u0001\r\u0001Q\u0001\nE\u000bQ\u0001Z1uC\u0002BqA\u0019\u0001C\u0002\u0013\u0005\u0001+\u0001\u0007eCR\fw+\u001b;i\u001dVdG\u000e\u0003\u0004e\u0001\u0001\u0006I!U\u0001\u000eI\u0006$\u0018mV5uQ:+H\u000e\u001c\u0011\t\u000f\u0019\u0004!\u0019!C\u0001!\u0006AQo]3s\t\u0006$\u0018\r\u0003\u0004i\u0001\u0001\u0006I!U\u0001\nkN,'\u000fR1uC\u0002BqA\u001b\u0001C\u0002\u0013\u0005\u0001+\u0001\tvg\u0016\u0014H)\u0019;b/&$\bNT;mY\"1A\u000e\u0001Q\u0001\nE\u000b\u0011#^:fe\u0012\u000bG/Y,ji\"tU\u000f\u001c7!\u0011\u0015q\u0007\u0001\"\u0011p\u0003\u0019\u0011WMZ8sKR\t\u0001\u000f\u0005\u0002 c&\u0011!\u000f\t\u0002\u0005+:LG\u000f\u000b\u0002niB\u0011Q\u000f_\u0007\u0002m*\u0011qOE\u0001\u0006UVt\u0017\u000e^\u0005\u0003sZ\u0014aAQ3g_J,\u0007\"B>\u0001\t\u0003z\u0017!B1gi\u0016\u0014\bF\u0001>~!\t)h0\u0003\u0002\u0000m\n)\u0011I\u001a;fe\"9\u00111\u0001\u0001\u0005\n\u0005\u0015\u0011!E2sK\u0006$X\rT8pWV\u0004H+\u00192mKR)\u0001/a\u0002\u0002\u001c!A\u0011\u0011BA\u0001\u0001\u0004\tY!A\u0005uC\ndWMT1nKB!\u0011QBA\u000b\u001d\u0011\ty!!\u0005\u0011\u0005E\u0002\u0013bAA\nA\u00051\u0001K]3eK\u001aLA!a\u0006\u0002\u001a\t11\u000b\u001e:j]\u001eT1!a\u0005!\u0011\u001dy\u0015\u0011\u0001a\u0001\u0003;\u0001R!a\b\u0002*esA!!\t\u0002&9\u0019\u0011'a\t\n\u0003\u0005J1!a\n!\u0003\u001d\u0001\u0018mY6bO\u0016L1\u0001WA\u0016\u0015\r\t9\u0003\t\u0005\b\u0003_\u0001A\u0011BA\u0019\u0003\r\u001a'/Z1uK2{wn[;q)\u0006\u0014G.Z,ji\"\u001cu.\u001c9vi\u0016$7i\u001c7v[:$R\u0001]A\u001a\u0003kA\u0001\"!\u0003\u0002.\u0001\u0007\u00111\u0002\u0005\b\u001f\u00065\u0002\u0019AA\u000f\u0011\u001d\tI\u0004\u0001C\u0005\u0003w\tqb\u0019:fCR,7kY1o)\u0006\u0014G.\u001a\u000b\u0006a\u0006u\u0012q\b\u0005\t\u0003\u0013\t9\u00041\u0001\u0002\f!9q*a\u000eA\u0002\u0005u\u0001BBA\"\u0001\u0011\u0005q.A\u0016uKN$H*\u001a4u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i\u0019>\u001c\u0017\r\u001c)sK\u0012L7-\u0019;fQ\u0011\t\t%a\u0012\u0011\u0007U\fI%C\u0002\u0002LY\u0014A\u0001V3ti\"1\u0011q\n\u0001\u0005\u0002=\fQ\u0003^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndW\r\u000b\u0003\u0002N\u0005\u001d\u0003BBA+\u0001\u0011\u0005q.A\u0011uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRD\u0007+^:i\t><h\u000e\u000b\u0003\u0002T\u0005\u001d\u0003BBA.\u0001\u0011\u0005q.A\u0014uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDgj\u001c8FcV\fGNR5mi\u0016\u0014\b\u0006BA-\u0003\u000fBa!!\u0019\u0001\t\u0003y\u0017A\t;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001bVdG/\u001b$jK2$7\u000f\u000b\u0003\u0002`\u0005\u001d\u0003BBA4\u0001\u0011\u0005q.A\u0015uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]6+H\u000e^5GS\u0016dGm],ji\",FM\u001a\u0015\u0005\u0003K\n9\u0005\u0003\u0004\u0002n\u0001!\ta\\\u0001&i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f\u001f:lU\u000f\u001c;j\u0017\u0016Lh)[3mINDC!a\u001b\u0002H!1\u00111\u000f\u0001\u0005\u0002=\f\u0011\u0004^3ti2+g\r\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK\"\"\u0011\u0011OA$\u0011\u0019\tI\b\u0001C\u0001_\u0006\tD/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\\'vYRL7*Z=GS\u0016dGm],ji\"tU\u000f\u001c7ECR\f\u0007\u0006BA<\u0003\u000fBa!a \u0001\t\u0003y\u0017!\u000e;fgRdUM\u001a;K_&tG+Z7q_J\fG\u000eV1cY\u0016|e.T;mi&\\U-\u001f$jK2$7oV5uQ:+H\u000e\u001c#bi\u0006DC!! \u0002H!1\u0011Q\u0011\u0001\u0005\u0002=\fa\u0005^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWm\u00148Ok2d7i\u001c8ti\u0006tGoS3zQ\u0011\t\u0019)a\u0012\t\r\u0005-\u0005\u0001\"\u0001p\u0003a\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016|e.T;mi&\\U-\u001f$jK2$7oV5uQ:+H\u000e\\\"p]N$\u0018M\u001c;LKfDC!!#\u0002H!1\u0011\u0011\u0013\u0001\u0005\u0002=\fq\u0005^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ\u000e{W\u000e];uK\u0012\u001cu\u000e\\;n]\"\"\u0011qRA$\u0011\u0019\t9\n\u0001C\u0001_\u0006\u0011D/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i\u0007>l\u0007/\u001e;fI\u000e{G.^7o\u0003:$\u0007+^:i\t><h\u000e\u000b\u0003\u0002\u0016\u0006\u001d\u0003BBAO\u0001\u0011\u0005q.\u0001\u0013uKN$Hj\\8lkB\u001c\u0015m\u00195f'\"\f'/\u001b8h\u0003\u000e\u0014xn]:Tk\n$\u0018m]6tQ\u0011\tY*a\u0012\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\u0006\u0011!.\u001b\u000b\u0005\u0003O\u000b9\f\u0005\u0003\u0002*\u0006MVBAAV\u0015\u0011\ti+a,\u0002\t1\fgn\u001a\u0006\u0003\u0003c\u000bAA[1wC&!\u0011QWAV\u0005\u001dIe\u000e^3hKJD\u0001\"!/\u0002\"\u0002\u0007\u00111X\u0001\u0002SB\u0019q$!0\n\u0007\u0005}\u0006EA\u0002J]RDq!a1\u0001\t\u0003\t)-\u0001\u0002kYR!\u0011qYAg!\u0011\tI+!3\n\t\u0005-\u00171\u0016\u0002\u0005\u0019>tw\r\u0003\u0005\u0002P\u0006\u0005\u0007\u0019AAi\u0003\u0005a\u0007cA\u0010\u0002T&\u0019\u00111\u001a\u0011)\u000f\u0001\t9.a9\u0002fB!\u0011\u0011\\Ap\u001b\t\tYNC\u0002\u0002^Z\faA];o]\u0016\u0014\u0018\u0002BAq\u00037\u0014qAU;o/&$\b.A\u0003wC2,Xm\t\u0002\u0002hB!\u0011\u0011^Ax\u001b\t\tYOC\u0002\u0002nZ\fqA];o]\u0016\u00148/\u0003\u0003\u0002r\u0006-(!\u0004)be\u0006lW\r^3sSj,GmB\u0004\u0002v\nA\t!a>\u0002!1{wn[;q\u0015>Lg.\u0013+DCN,\u0007c\u0001&\u0002z\u001a1\u0011A\u0001E\u0001\u0003w\u001cB!!?\u0002~B\u0019q$a@\n\u0007\t\u0005\u0001E\u0001\u0004B]f\u0014VM\u001a\u0005\b\u000f\u0006eH\u0011\u0001B\u0003)\t\t9\u0010\u0003\u0006\u0003\n\u0005e(\u0019!C\u0001\u0005\u0017\t1\u0003T#H\u0003\u000eKv\fV!C\u0019\u0016{6kT+S\u0007\u0016+\"A!\u0004\u0011\t\u0005%&qB\u0005\u0004G\u0005-\u0006\"\u0003B\n\u0003s\u0004\u000b\u0011\u0002B\u0007\u0003QaUiR!D3~#\u0016I\u0011'F?N{UKU\"FA!Q!qCA}\u0005\u0004%\tAa\u0003\u0002)\u0011Kf*Q'J\u0007~#\u0016I\u0011'F?N{UKU\"F\u0011%\u0011Y\"!?!\u0002\u0013\u0011i!A\u000bE3:\u000bU*S\"`)\u0006\u0013E*R0T\u001fV\u00136)\u0012\u0011\t\u0015\t}\u0011\u0011 b\u0001\n\u0003\u0011Y!\u0001\u0006B'fs5iX'P\t\u0016C\u0011Ba\t\u0002z\u0002\u0006IA!\u0004\u0002\u0017\u0005\u001b\u0016LT\"`\u001b>#U\t\t\u0005\u000b\u0005O\tIP1A\u0005\u0002\t-\u0011!C*Z\u001d\u000e{Vj\u0014#F\u0011%\u0011Y#!?!\u0002\u0013\u0011i!\u0001\u0006T3:\u001bu,T(E\u000b\u0002B\u0001Ba\f\u0002z\u0012\u0005!\u0011G\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cHC\u0001B\u001a!\u0019\u0011)Da\u000f\u0003@5\u0011!q\u0007\u0006\u0005\u0005s\ty+\u0001\u0003vi&d\u0017\u0002\u0002B\u001f\u0005o\u0011!bQ8mY\u0016\u001cG/[8o!\u0015y\"\u0011\tB#\u0013\r\u0011\u0019\u0005\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003S\u00139%\u0003\u0003\u0003J\u0005-&AB(cU\u0016\u001cG\u000f\u000b\u0005\u0003.\t5#1\fB/!\u0011\u0011yE!\u0016\u000f\t\u0005%(\u0011K\u0005\u0005\u0005'\nY/A\u0007QCJ\fW.\u001a;fe&TX\rZ\u0005\u0005\u0005/\u0012IF\u0001\u0006QCJ\fW.\u001a;feNTAAa\u0015\u0002l\u0006!a.Y7fC\t\u0011y&A\u001dMK\u001e\f7-\u001f+bE2,7k\\;sG\u0016l4\u0010M?-A%\u001c\u0018i]=oG6{G-\u001a\u0011>Am\fT\u0010\f\u0011dC\u000eDW\rV=qK\u0002j\u0004e\u001f\u001a~\u0001")
public class LookupJoinITCase
extends BatchTestBase {
    private final boolean legacyTableSource;
    private final boolean isAsyncMode;
    private final LookupOptions.LookupCacheType cacheType;
    private final List<Row> data;
    private final List<Row> dataWithNull;
    private final List<Row> userData;
    private final List<Row> userDataWithNull;

    @Parameterized.Parameters(name="LegacyTableSource={0}, isAsyncMode = {1}, cacheType = {2}")
    public static Collection<Object[]> parameters() {
        return LookupJoinITCase$.MODULE$.parameters();
    }

    public static Boolean SYNC_MODE() {
        return LookupJoinITCase$.MODULE$.SYNC_MODE();
    }

    public static Boolean ASYNC_MODE() {
        return LookupJoinITCase$.MODULE$.ASYNC_MODE();
    }

    public static Boolean DYNAMIC_TABLE_SOURCE() {
        return LookupJoinITCase$.MODULE$.DYNAMIC_TABLE_SOURCE();
    }

    public static Boolean LEGACY_TABLE_SOURCE() {
        return LookupJoinITCase$.MODULE$.LEGACY_TABLE_SOURCE();
    }

    public List<Row> data() {
        return this.data;
    }

    public List<Row> dataWithNull() {
        return this.dataWithNull;
    }

    public List<Row> userData() {
        return this.userData;
    }

    public List<Row> userDataWithNull() {
        return this.userDataWithNull;
    }

    @Override
    @Before
    public void before() {
        super.before();
        if (this.legacyTableSource) {
            InMemoryLookupableTableSource$.MODULE$.RESOURCE_COUNTER().set(0);
        } else {
            TestValuesTableFactory.RESOURCE_COUNTER.set(0);
            FullCacheTestInputFormat.OPEN_CLOSED_COUNTER.set(0);
        }
        this.createScanTable("T", this.data());
        this.createScanTable("nullableT", this.dataWithNull());
        this.createLookupTable("userTable", this.userData());
        this.createLookupTable("userTableWithNull", this.userDataWithNull());
        this.createLookupTableWithComputedColumn("userTableWithComputedColumn", this.userData());
        this.env().getConfig().disableObjectReuse();
    }

    @Override
    @After
    public void after() {
        if (this.legacyTableSource) {
            Assert.assertEquals((long)0L, (long)InMemoryLookupableTableSource$.MODULE$.RESOURCE_COUNTER().get());
        } else {
            Assert.assertEquals((long)0L, (long)TestValuesTableFactory.RESOURCE_COUNTER.get());
            Assert.assertEquals((long)0L, (long)FullCacheTestInputFormat.OPEN_CLOSED_COUNTER.get());
        }
    }

    private void createLookupTable(String tableName, List<Row> data) {
        if (this.legacyTableSource) {
            TableSchema userSchema = TableSchema.builder().field("age", Types.INT()).field("id", Types.LONG()).field("name", Types.STRING()).build();
            InMemoryLookupableTableSource$.MODULE$.createTemporaryTable(this.tEnv(), this.isAsyncMode, data, userSchema, tableName, true);
        } else {
            String string;
            String dataId = TestValuesTableFactory.registerData(data);
            LookupOptions.LookupCacheType lookupCacheType = this.cacheType;
            LookupOptions.LookupCacheType lookupCacheType2 = LookupOptions.LookupCacheType.PARTIAL;
            if (!(lookupCacheType != null ? !lookupCacheType.equals(lookupCacheType2) : lookupCacheType2 != null)) {
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.PARTIAL).append("',\n             |  '").append(LookupOptions.PARTIAL_CACHE_MAX_ROWS.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin();
            } else {
                LookupOptions.LookupCacheType lookupCacheType3 = this.cacheType;
                LookupOptions.LookupCacheType lookupCacheType4 = LookupOptions.LookupCacheType.FULL;
                string = !(lookupCacheType3 != null ? !lookupCacheType3.equals(lookupCacheType4) : lookupCacheType4 != null) ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(90).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.FULL).append("',\n             |  '").append(LookupOptions.FULL_CACHE_RELOAD_STRATEGY.key()).append("' = '").append(LookupOptions.ReloadStrategy.PERIODIC).append("',\n             |  '").append(LookupOptions.FULL_CACHE_PERIODIC_RELOAD_INTERVAL.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin() : "";
            }
            String cacheOptions = string;
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(468).append("\n                         |CREATE TABLE ").append(tableName).append(" (\n                         |  `age` INT,\n                         |  `id` BIGINT,\n                         |  `name` STRING\n                         |) WITH (\n                         |  ").append(cacheOptions).append("\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(dataId).append("',\n                         |  'async' = '").append(this.isAsyncMode).append("',\n                         |  'bounded' = 'true'\n                         |)\n                         |").toString())).stripMargin());
        }
    }

    private void createLookupTableWithComputedColumn(String tableName, List<Row> data) {
        block2: {
            String string;
            if (this.legacyTableSource) break block2;
            String dataId = TestValuesTableFactory.registerData(data);
            LookupOptions.LookupCacheType lookupCacheType = this.cacheType;
            LookupOptions.LookupCacheType lookupCacheType2 = LookupOptions.LookupCacheType.PARTIAL;
            if (!(lookupCacheType != null ? !lookupCacheType.equals(lookupCacheType2) : lookupCacheType2 != null)) {
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.PARTIAL).append("',\n             |  '").append(LookupOptions.PARTIAL_CACHE_MAX_ROWS.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin();
            } else {
                LookupOptions.LookupCacheType lookupCacheType3 = this.cacheType;
                LookupOptions.LookupCacheType lookupCacheType4 = LookupOptions.LookupCacheType.FULL;
                string = !(lookupCacheType3 != null ? !lookupCacheType3.equals(lookupCacheType4) : lookupCacheType4 != null) ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(90).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.FULL).append("',\n             |  '").append(LookupOptions.FULL_CACHE_RELOAD_STRATEGY.key()).append("' = '").append(LookupOptions.ReloadStrategy.PERIODIC).append("',\n             |  '").append(LookupOptions.FULL_CACHE_PERIODIC_RELOAD_INTERVAL.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin() : "";
            }
            String cacheOptions = string;
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(522).append("\n                         |CREATE TABLE ").append(tableName).append(" (\n                         |  `age` INT,\n                         |  `id` BIGINT,\n                         |  `name` STRING,\n                         |  `nominal_age` as age + 1\n                         |) WITH (\n                         |  ").append(cacheOptions).append("\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(dataId).append("',\n                         |  'async' = '").append(this.isAsyncMode).append("',\n                         |  'bounded' = 'true'\n                         |)\n                         |").toString())).stripMargin());
        }
    }

    private void createScanTable(String tableName, List<Row> data) {
        String dataId = TestValuesTableFactory.registerData(data);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(435).append("\n                       |CREATE TABLE ").append(tableName).append(" (\n                       |  `id` BIGINT,\n                       |  `len` BIGINT,\n                       |  `content` STRING,\n                       |  `proctime` AS PROCTIME()\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(dataId).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
    }

    @Test
    public void testLeftJoinTemporalTableWithLocalPredicate() {
        String sql = new StringBuilder(190).append("SELECT T.id, T.len, T.content, D.name, D.age FROM T LEFT JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id ").append("AND T.len > 1 AND D.age > 20 AND D.name = 'Fabian' ").append("WHERE T.id > 1").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), BoxesRunTime.boxToInteger((int)11), "Hello world", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)12), "Hello world!", null, null}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTable() {
        String sql = new StringBuilder(112).append("SELECT T.id, T.len, T.content, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian", "Julian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableWithPushDown() {
        String sql = new StringBuilder(127).append("SELECT T.id, T.len, T.content, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id AND D.age > 20").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableWithNonEqualFilter() {
        String sql = new StringBuilder(140).append("SELECT T.id, T.len, T.content, D.name, D.age FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id WHERE T.len <= D.age").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark", BoxesRunTime.boxToInteger((int)22)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33)}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnMultiFields() {
        String sql = new StringBuilder(124).append("SELECT T.id, T.len, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id AND T.content = D.name").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnMultiFieldsWithUdf() {
        String sql = new StringBuilder(132).append("SELECT T.id, T.len, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON mod(T.id, 4) = D.id AND T.content = D.name").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFields() {
        String sql = new StringBuilder(124).append("SELECT T.id, T.len, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testLeftJoinTemporalTable() {
        String sql = new StringBuilder(113).append("SELECT T.id, T.len, D.name, D.age FROM T LEFT JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian", BoxesRunTime.boxToInteger((int)11)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Jark", BoxesRunTime.boxToInteger((int)22)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", BoxesRunTime.boxToInteger((int)33)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), BoxesRunTime.boxToInteger((int)11), null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)12), null, null}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = new StringBuilder(142).append("SELECT T.id, T.len, D.name FROM nullableT T JOIN userTableWithNull ").append("for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testLeftJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = new StringBuilder(147).append("SELECT D.id, T.len, D.name FROM nullableT T LEFT JOIN userTableWithNull ").append("for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)15), null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)11), null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)12), null}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnNullConstantKey() {
        String sql = new StringBuilder(104).append("SELECT T.id, T.len, T.content FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON D.id = null").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullConstantKey() {
        String sql = new StringBuilder(124).append("SELECT T.id, T.len, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.content = D.name AND null = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableWithComputedColumn() {
        Assume.assumeFalse((boolean)this.legacyTableSource);
        String sql = new StringBuilder(152).append("SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age ").append("FROM T JOIN userTableWithComputedColumn ").append("for system_time as of T.proctime AS D ON T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian", "Julian", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)12)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark", BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToInteger((int)23)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToInteger((int)34)}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableWithComputedColumnAndPushDown() {
        Assume.assumeFalse((boolean)this.legacyTableSource);
        String sql = new StringBuilder(175).append("SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age ").append("FROM T JOIN userTableWithComputedColumn ").append("for system_time as of T.proctime AS D ON T.id = D.id and D.nominal_age > 12").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark", BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToInteger((int)23)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToInteger((int)34)}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testLookupCacheSharingAcrossSubtasks() {
        LookupOptions.LookupCacheType lookupCacheType = this.cacheType;
        LookupOptions.LookupCacheType lookupCacheType2 = LookupOptions.LookupCacheType.NONE;
        if (!(lookupCacheType != null ? !lookupCacheType.equals(lookupCacheType2) : lookupCacheType2 != null)) {
            return;
        }
        LookupCacheManager.keepCacheOnRelease((boolean)true);
        try {
            String sourceDdl = new StringOps(Predef$.MODULE$.augmentString("\n           |CREATE TABLE datagen_source (\n           |  id BIGINT,\n           |  proc AS PROCTIME()\n           |) WITH (\n           |  'connector' = 'datagen',\n           |  'fields.id.kind' = 'sequence',\n           |  'fields.id.start' = '1',\n           |  'fields.id.end' = '6',\n           |  'number-of-rows' = '6'\n           |)\n           |")).stripMargin();
            this.tEnv().executeSql(sourceDdl);
            String sql = new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT T.id, D.name, D.age FROM datagen_source as T \n          |LEFT JOIN userTable FOR SYSTEM_TIME AS OF T.proc AS D \n          |ON T.id = D.id\n          |")).stripMargin();
            this.executeQuery(this.parseQuery(sql));
            Map managedCaches = LookupCacheManager.getInstance().getManagedCaches();
            Assertions.assertThat((int)managedCaches.size()).isEqualTo(1);
            LookupOptions.LookupCacheType lookupCacheType3 = this.cacheType;
            LookupOptions.LookupCacheType lookupCacheType4 = LookupOptions.LookupCacheType.PARTIAL;
            int numEntries = !(lookupCacheType3 != null ? !lookupCacheType3.equals(lookupCacheType4) : lookupCacheType4 != null) ? 6 : this.userData().size();
            LookupCache cache = ((LookupCacheManager.RefCountedCache)managedCaches.get(managedCaches.keySet().iterator().next())).getCache();
            Assertions.assertThat((long)cache.size()).isEqualTo((long)numEntries);
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(1L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(11), this.jl(1L), BinaryStringData.fromString((String)"Julian")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(2L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(22), this.jl(2L), BinaryStringData.fromString((String)"Jark")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(3L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(33), this.jl(3L), BinaryStringData.fromString((String)"Fabian")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(4L)}))).isEmpty();
        }
        finally {
            LookupCacheManager.getInstance().checkAllReleased();
            LookupCacheManager.getInstance().clear();
            LookupCacheManager.keepCacheOnRelease((boolean)false);
        }
    }

    public Integer ji(int i) {
        return new Integer(i);
    }

    public Long jl(long l) {
        return new Long(l);
    }

    public LookupJoinITCase(boolean legacyTableSource, boolean isAsyncMode, LookupOptions.LookupCacheType cacheType) {
        this.legacyTableSource = legacyTableSource;
        this.isAsyncMode = isAsyncMode;
        this.cacheType = cacheType;
        this.data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToLong((long)12L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)15L), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToLong((long)15L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)8L), BoxesRunTime.boxToLong((long)11L), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToLong((long)12L), "Hello world!"})), (List)Nil$.MODULE$)))));
        this.dataWithNull = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)15L), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToLong((long)15L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)11L), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToLong((long)12L), "Hello world!"})), (List)Nil$.MODULE$))));
        this.userData = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToLong((long)2L), "Jark"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), (List)Nil$.MODULE$)));
        this.userDataWithNull = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), null, "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)44), null, "Hello world"})), (List)Nil$.MODULE$))));
    }
}

