/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.collection.Seq;

public class DynamicFilteringITCase
extends BatchTestBase {
    private TableEnvironment tEnv;
    private Catalog catalog;

    static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{BatchShuffleMode.ALL_EXCHANGES_BLOCKING}), Arguments.of((Object[])new Object[]{BatchShuffleMode.ALL_EXCHANGES_PIPELINED}));
    }

    @Override
    @BeforeEach
    public void before() throws Exception {
        super.before();
        this.tEnv = this.tEnv();
        this.catalog = (Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get();
        this.tEnv.getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)2);
        this.tEnv.getConfig().getConfiguration().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DYNAMIC_FILTERING_ENABLED, (Object)true);
        String dataId1 = TestValuesTableFactory.registerData(TestData.data7());
        this.tEnv.executeSql(String.format("CREATE TABLE dim (\n  x INT,\n  y INT,\n  z BIGINT\n)  WITH (\n 'connector' = 'values',\n 'disable-lookup' = 'true',\n 'data-id' = '%s',\n 'bounded' = 'true'\n)", dataId1));
        String dataId2 = TestValuesTableFactory.registerData(TestData.data5());
        this.tEnv.executeSql(String.format("CREATE TABLE fact1 (\n  `a` INT,\n  `b` BIGINT,\n  `c` INT,\n  `d` VARCHAR,\n  `e` BIGINT\n) partitioned by (a)\n WITH (\n  'connector' = 'values',\n  'runtime-source' = 'NewSource',\n  'partition-list' = 'a:1;a:2;a:3;a:4;a:5;',\n  'dynamic-filtering-fields' = 'a',\n  'data-id' = '%s',\n  'disable-lookup' = 'true',\n  'bounded' = 'true'\n)", dataId2));
        String dataId3 = TestValuesTableFactory.registerData(TestData.data5());
        this.tEnv.executeSql(String.format("CREATE TABLE fact2 (\n  `a` INT,\n  `b` BIGINT,\n  `c` INT,\n  `d` VARCHAR,\n  `e` BIGINT\n) partitioned by (e, a)\n WITH (\n  'connector' = 'values',\n  'runtime-source' = 'NewSource',\n  'partition-list' = 'e:1,a:1;e:1,a:2;e:1,a:4;e:1,a:5;e:2,a:2;e:2,a:3;e:2,a:4;e:2,a:5;e:3,a:3;e:3,a:5;',\n  'dynamic-filtering-fields' = 'a;e',\n  'data-id' = '%s',\n  'disable-lookup' = 'true',\n  'bounded' = 'true'\n)", dataId3));
    }

    @ParameterizedTest(name="mode = {0}")
    @MethodSource(value={"parameters"})
    public void testSimpleDynamicFiltering(BatchShuffleMode shuffleMode) {
        this.tEnv.getConfig().getConfiguration().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)shuffleMode);
        this.checkResult("SELECT * FROM fact1, dim WHERE x = a AND z = 2", (Seq<Row>)JavaScalaConversionUtil.toScala(Arrays.asList(Row.of((Object[])new Object[]{2, 2, 1, "Hallo Welt", 2, 2, 2, 2}), Row.of((Object[])new Object[]{2, 3, 2, "Hallo Welt wie", 1, 2, 2, 2}), Row.of((Object[])new Object[]{3, 4, 3, "Hallo Welt wie gehts?", 2, 3, 3, 2}), Row.of((Object[])new Object[]{3, 5, 4, "ABC", 2, 3, 3, 2}), Row.of((Object[])new Object[]{3, 6, 5, "BCD", 3, 3, 3, 2}), Row.of((Object[])new Object[]{4, 10, 9, "FGH", 2, 4, 5, 2}), Row.of((Object[])new Object[]{4, 10, 9, "FGH", 2, 4, 7, 2}), Row.of((Object[])new Object[]{4, 7, 6, "CDE", 2, 4, 5, 2}), Row.of((Object[])new Object[]{4, 7, 6, "CDE", 2, 4, 7, 2}), Row.of((Object[])new Object[]{4, 8, 7, "DEF", 1, 4, 5, 2}), Row.of((Object[])new Object[]{4, 8, 7, "DEF", 1, 4, 7, 2}), Row.of((Object[])new Object[]{4, 9, 8, "EFG", 1, 4, 5, 2}), Row.of((Object[])new Object[]{4, 9, 8, "EFG", 1, 4, 7, 2}), Row.of((Object[])new Object[]{5, 11, 10, "GHI", 1, 5, 9, 2}), Row.of((Object[])new Object[]{5, 12, 11, "HIJ", 3, 5, 9, 2}), Row.of((Object[])new Object[]{5, 13, 12, "IJK", 3, 5, 9, 2}), Row.of((Object[])new Object[]{5, 14, 13, "JKL", 2, 5, 9, 2}), Row.of((Object[])new Object[]{5, 15, 14, "KLM", 2, 5, 9, 2}))), false);
    }

    @ParameterizedTest(name="mode = {0}")
    @MethodSource(value={"parameters"})
    public void testDynamicFilteringChainWithMultipleInput(BatchShuffleMode shuffleMode) throws Exception {
        this.tEnv.getConfig().getConfiguration().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)shuffleMode);
        String dataId1 = TestValuesTableFactory.registerData(TestData.data7());
        this.tEnv.executeSql(String.format("CREATE TABLE dim2 (\n  x INT,\n  y INT,\n  z BIGINT\n)  WITH (\n 'connector' = 'values',\n 'disable-lookup' = 'true',\n 'data-id' = '%s',\n 'bounded' = 'true'\n)", dataId1));
        this.catalog.alterTableStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "dim"), new CatalogTableStatistics(1L, 1, 1L, 1L), false);
        this.catalog.alterTableStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "dim2"), new CatalogTableStatistics(100L, 1, 1L, 1L), false);
        this.checkResult("SELECT * FROM fact1, dim, dim2 WHERE dim.x = fact1.a and dim2.y = fact1.a AND dim.z = 1", (Seq<Row>)JavaScalaConversionUtil.toScala(Arrays.asList(Row.of((Object[])new Object[]{1, 1, 0, "Hallo", 1, 1, 0, 1, 2, 1, 1}), Row.of((Object[])new Object[]{2, 2, 1, "Hallo Welt", 2, 2, 1, 1, 2, 2, 2}), Row.of((Object[])new Object[]{2, 3, 2, "Hallo Welt wie", 1, 2, 1, 1, 2, 2, 2}), Row.of((Object[])new Object[]{4, 10, 9, "FGH", 2, 4, 6, 1, 3, 4, 3}), Row.of((Object[])new Object[]{4, 7, 6, "CDE", 2, 4, 6, 1, 3, 4, 3}), Row.of((Object[])new Object[]{4, 8, 7, "DEF", 1, 4, 6, 1, 3, 4, 3}), Row.of((Object[])new Object[]{4, 9, 8, "EFG", 1, 4, 6, 1, 3, 4, 3}), Row.of((Object[])new Object[]{5, 11, 10, "GHI", 1, 5, 8, 1, 4, 5, 2}), Row.of((Object[])new Object[]{5, 12, 11, "HIJ", 3, 5, 8, 1, 4, 5, 2}), Row.of((Object[])new Object[]{5, 13, 12, "IJK", 3, 5, 8, 1, 4, 5, 2}), Row.of((Object[])new Object[]{5, 14, 13, "JKL", 2, 5, 8, 1, 4, 5, 2}), Row.of((Object[])new Object[]{5, 15, 14, "KLM", 2, 5, 8, 1, 4, 5, 2}))), false);
    }

    @ParameterizedTest(name="mode = {0}")
    @MethodSource(value={"parameters"})
    public void testDynamicFilteringCannotChainWithMultipleInput(BatchShuffleMode shuffleMode) {
        this.tEnv.getConfig().getConfiguration().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)shuffleMode);
        this.checkResult("SELECT * FROM fact1, dim, fact2 WHERE x = fact1.a and fact2.a = fact1.a AND z = 1 and fact1.e = 2 and fact2.e = 1", (Seq<Row>)JavaScalaConversionUtil.toScala(Arrays.asList(Row.of((Object[])new Object[]{2, 2, 1, "Hallo Welt", 2, 2, 1, 1, 2, 3, 2, "Hallo Welt wie", 1}), Row.of((Object[])new Object[]{4, 10, 9, "FGH", 2, 4, 6, 1, 4, 8, 7, "DEF", 1}), Row.of((Object[])new Object[]{4, 10, 9, "FGH", 2, 4, 6, 1, 4, 9, 8, "EFG", 1}), Row.of((Object[])new Object[]{4, 7, 6, "CDE", 2, 4, 6, 1, 4, 8, 7, "DEF", 1}), Row.of((Object[])new Object[]{4, 7, 6, "CDE", 2, 4, 6, 1, 4, 9, 8, "EFG", 1}), Row.of((Object[])new Object[]{5, 14, 13, "JKL", 2, 5, 8, 1, 5, 11, 10, "GHI", 1}), Row.of((Object[])new Object[]{5, 15, 14, "KLM", 2, 5, 8, 1, 5, 11, 10, "GHI", 1}))), false);
    }

    @ParameterizedTest(name="mode = {0}")
    @MethodSource(value={"parameters"})
    public void testReuseDimSide(BatchShuffleMode shuffleMode) {
        this.tEnv.getConfig().getConfiguration().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)shuffleMode);
        this.checkResult("SELECT * FROM fact1, dim WHERE x = a AND z = 1 and b = 3UNION ALL SELECT * FROM fact2, dim WHERE x = a AND z = 1 and b = 2", (Seq<Row>)JavaScalaConversionUtil.toScala(Arrays.asList(Row.of((Object[])new Object[]{2, 2, 1, "Hallo Welt", 2, 2, 1, 1}), Row.of((Object[])new Object[]{2, 3, 2, "Hallo Welt wie", 1, 2, 1, 1}))), false);
    }

    @ParameterizedTest(name="mode = {0}")
    @MethodSource(value={"parameters"})
    public void testDynamicFilteringWithStaticPartitionPruning(BatchShuffleMode shuffleMode) {
        this.tEnv.getConfig().getConfiguration().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)shuffleMode);
        this.checkResult("SELECT * FROM fact2, dim WHERE x = a and e = z AND y < 5 and a = 3", (Seq<Row>)JavaScalaConversionUtil.toScala(Arrays.asList(Row.of((Object[])new Object[]{3, 4, 3, "Hallo Welt wie gehts?", 2, 3, 3, 2}), Row.of((Object[])new Object[]{3, 5, 4, "ABC", 2, 3, 3, 2}), Row.of((Object[])new Object[]{3, 6, 5, "BCD", 3, 3, 4, 3}))), false);
    }

    @ParameterizedTest(name="mode = {0}")
    @MethodSource(value={"parameters"})
    public void testMultiplePartitionKeysWithFullKey(BatchShuffleMode shuffleMode) {
        this.tEnv.getConfig().getConfiguration().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)shuffleMode);
        this.checkResult("SELECT * FROM fact2, dim WHERE x = a AND z = e and y = 1", (Seq<Row>)JavaScalaConversionUtil.toScala(Collections.singletonList(Row.of((Object[])new Object[]{2, 3, 2, "Hallo Welt wie", 1, 2, 1, 1}))), false);
    }

    @ParameterizedTest(name="mode = {0}")
    @MethodSource(value={"parameters"})
    public void testMultiplePartitionKeysWithPartialKey(BatchShuffleMode shuffleMode) {
        this.tEnv.getConfig().getConfiguration().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)shuffleMode);
        this.checkResult("SELECT * FROM fact2, dim WHERE z = e and y = 1", (Seq<Row>)JavaScalaConversionUtil.toScala(Arrays.asList(Row.of((Object[])new Object[]{1, 1, 0, "Hallo", 1, 2, 1, 1}), Row.of((Object[])new Object[]{2, 3, 2, "Hallo Welt wie", 1, 2, 1, 1}), Row.of((Object[])new Object[]{4, 8, 7, "DEF", 1, 2, 1, 1}), Row.of((Object[])new Object[]{4, 9, 8, "EFG", 1, 2, 1, 1}), Row.of((Object[])new Object[]{5, 11, 10, "GHI", 1, 2, 1, 1}))), false);
    }
}

