/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.util.HashMap;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBoolean;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDate;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDouble;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataLong;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataString;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.catalog.stats.Date;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AnalyzeTableITCase
extends BatchTestBase {
    private TableEnvironment tEnv;

    @Override
    @BeforeEach
    public void before() throws Exception {
        super.before();
        this.tEnv = this.tEnv();
        TestValuesCatalog catalog = new TestValuesCatalog("cat", "db", true);
        this.tEnv.registerCatalog("cat", (Catalog)catalog);
        this.tEnv.useCatalog("cat");
        this.tEnv.useDatabase("db");
        String dataId1 = TestValuesTableFactory.registerData(TestData.fullDataTypesData());
        this.tEnv.executeSql(String.format("CREATE TABLE NonPartitionTable (\n  `a` BOOLEAN,\n  `b` TINYINT,\n  `c` SMALLINT,\n  `d` INT,\n  `e` BIGINT,\n  `f` FLOAT,\n  `g` DOUBLE,\n  `h` DECIMAL(5, 2),\n  `x` DECIMAL(30, 10),\n  `i` VARCHAR(5),\n  `j` CHAR(5),\n  `k` DATE,\n  `l` TIME(0),\n  `m` TIMESTAMP(9),\n  `n` TIMESTAMP(9) WITH LOCAL TIME ZONE,\n  `o` ARRAY<BIGINT>,\n  `p` ROW<f1 BIGINT, f2 STRING, f3 DOUBLE>,\n  `q` MAP<STRING, INT>\n) WITH (\n  'connector' = 'values',\n  'data-id' = '%s',\n  'bounded' = 'true'\n)", dataId1));
        String dataId2 = TestValuesTableFactory.registerData(TestData.data5());
        this.tEnv.executeSql(String.format("CREATE TABLE PartitionTable (\n  `a` INT,\n  `b` BIGINT,\n  `c` INT,\n  `d` VARCHAR,\n  `e` BIGINT\n) partitioned by (e, a)\n WITH (\n  'connector' = 'values',\n  'partition-list' = 'e:1,a:1;e:1,a:2;e:1,a:4;e:1,a:5;e:2,a:2;e:2,a:3;e:2,a:4;e:2,a:5;e:3,a:3;e:3,a:5;',\n  'data-id' = '%s',\n  'disable-lookup' = 'true',\n  'bounded' = 'true'\n)", dataId2));
        this.createPartition((Catalog)catalog, "db", "PartitionTable", "e=1,a=1");
        this.createPartition((Catalog)catalog, "db", "PartitionTable", "e=1,a=2");
        this.createPartition((Catalog)catalog, "db", "PartitionTable", "e=1,a=4");
        this.createPartition((Catalog)catalog, "db", "PartitionTable", "e=1,a=5");
        this.createPartition((Catalog)catalog, "db", "PartitionTable", "e=2,a=2");
        this.createPartition((Catalog)catalog, "db", "PartitionTable", "e=2,a=3");
        this.createPartition((Catalog)catalog, "db", "PartitionTable", "e=2,a=4");
        this.createPartition((Catalog)catalog, "db", "PartitionTable", "e=2,a=5");
        this.createPartition((Catalog)catalog, "db", "PartitionTable", "e=3,a=3");
        this.createPartition((Catalog)catalog, "db", "PartitionTable", "e=3,a=5");
        String dataId3 = TestValuesTableFactory.registerData(TestData.smallData5());
        this.tEnv.executeSql(String.format("CREATE TABLE NonPartitionTable2 (\n  `a` INT,\n  `b` BIGINT,\n  `c` INT,\n  `d` VARCHAR METADATA VIRTUAL,\n  `e` BIGINT METADATA,  `f` as a + 1\n) WITH (\n  'connector' = 'values',\n  'data-id' = '%s',\n  'disable-lookup' = 'true',\n  'readable-metadata'='d:varchar,e:bigint',\n  'bounded' = 'true'\n)", dataId3));
        String dataId4 = TestValuesTableFactory.registerData(TestData.smallData5());
        this.tEnv.executeSql(String.format("CREATE TABLE PartitionTable2 (\n  `a` INT,\n  `b` BIGINT,\n  `c` INT,\n  `d` VARCHAR METADATA VIRTUAL,\n  `e` BIGINT METADATA,  `f` as a + 1\n) partitioned by (a)\n WITH (\n  'connector' = 'values',\n  'partition-list' = 'a:1;a:2;',\n  'data-id' = '%s',\n  'disable-lookup' = 'true',\n  'readable-metadata'='d:varchar,e:bigint',\n  'bounded' = 'true'\n)", dataId4));
        this.createPartition((Catalog)catalog, "db", "PartitionTable2", "a=1");
        this.createPartition((Catalog)catalog, "db", "PartitionTable2", "a=2");
    }

    private void createPartition(Catalog catalog, String db, String table, String partitionSpecs) throws Exception {
        catalog.createPartition(new ObjectPath(db, table), this.createCatalogPartitionSpec(partitionSpecs), (CatalogPartition)new CatalogPartitionImpl(new HashMap(), ""), false);
    }

    private CatalogPartitionSpec createCatalogPartitionSpec(String partitionSpecs) {
        HashMap<String, String> partitionSpec = new HashMap<String, String>();
        for (String partition : partitionSpecs.split(",")) {
            String[] items = partition.split("=");
            Preconditions.checkArgument((items.length == 2 ? 1 : 0) != 0, (Object)"Partition key value should be joined with '='");
            partitionSpec.put(items[0], items[1]);
        }
        return new CatalogPartitionSpec(partitionSpec);
    }

    @Test
    public void testNonPartitionTableWithoutTableNotExisted() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("analyze table not_exist_table compute statistics")).isInstanceOf(ValidationException.class)).hasMessageContaining("Table `cat`.`db`.`not_exist_table` doesn't exist");
    }

    @Test
    public void testNonPartitionTableWithoutColumns() throws Exception {
        this.tEnv.executeSql("analyze table NonPartitionTable compute statistics");
        ObjectPath path = new ObjectPath(this.tEnv.getCurrentDatabase(), "NonPartitionTable");
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableStatistics(path)).isEqualTo((Object)new CatalogTableStatistics(5L, -1, -1L, -1L));
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableColumnStatistics(path)).isEqualTo((Object)new CatalogColumnStatistics(new HashMap()));
    }

    @Test
    public void testNonPartitionTableWithColumnsNotExisted() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("analyze table NonPartitionTable compute statistics for columns not_existed_column")).isInstanceOf(ValidationException.class)).hasMessageContaining("Column: not_existed_column does not exist in the table: `cat`.`db`.`NonPartitionTable`");
    }

    @Test
    public void testNonPartitionTableWithComputeColumn() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("analyze table NonPartitionTable2 compute statistics for columns f")).isInstanceOf(ValidationException.class)).hasMessageContaining("Column: f is a computed column, ANALYZE TABLE does not support computed column");
    }

    @Test
    public void testNonPartitionTableWithVirtualMetadataColumn() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("analyze table NonPartitionTable2 compute statistics for columns d")).isInstanceOf(ValidationException.class)).hasMessageContaining("Column: d is a metadata column, ANALYZE TABLE does not support metadata column");
    }

    @Test
    public void testNonPartitionTableWithMetadataColumn() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("analyze table NonPartitionTable2 compute statistics for columns e")).isInstanceOf(ValidationException.class)).hasMessageContaining("Column: e is a metadata column, ANALYZE TABLE does not support metadata column");
    }

    @Test
    public void testNonPartitionTableWithPartition() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("analyze table NonPartitionTable PARTITION(a) compute statistics")).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid ANALYZE TABLE statement. Table: `cat`.`db`.`NonPartitionTable` is not a partition table, while partition values are given");
    }

    @Test
    public void testNonPartitionTableWithPartialColumns() throws Exception {
        this.tEnv.executeSql("analyze table NonPartitionTable compute statistics for columns f, a, d");
        ObjectPath path1 = new ObjectPath(this.tEnv.getCurrentDatabase(), "NonPartitionTable");
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableStatistics(path1)).isEqualTo((Object)new CatalogTableStatistics(5L, -1, -1L, -1L));
        HashMap<String, Object> columnStatisticsData1 = new HashMap<String, Object>();
        columnStatisticsData1.put("a", new CatalogColumnStatisticsDataBoolean(Long.valueOf(2L), Long.valueOf(2L), Long.valueOf(1L)));
        columnStatisticsData1.put("f", new CatalogColumnStatisticsDataDouble(Double.valueOf(-1.123), Double.valueOf(3.4), Long.valueOf(4L), Long.valueOf(1L)));
        columnStatisticsData1.put("d", new CatalogColumnStatisticsDataLong(Long.valueOf(Integer.MIN_VALUE), Long.valueOf(Integer.MAX_VALUE), Long.valueOf(4L), Long.valueOf(1L)));
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableColumnStatistics(path1)).isEqualTo((Object)new CatalogColumnStatistics(columnStatisticsData1));
        this.tEnv.executeSql("analyze table NonPartitionTable2 compute statistics for columns a, b, c");
        ObjectPath path2 = new ObjectPath(this.tEnv.getCurrentDatabase(), "NonPartitionTable2");
        HashMap<String, CatalogColumnStatisticsDataLong> columnStatisticsData2 = new HashMap<String, CatalogColumnStatisticsDataLong>();
        columnStatisticsData2.put("a", new CatalogColumnStatisticsDataLong(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(2L), Long.valueOf(0L)));
        columnStatisticsData2.put("b", new CatalogColumnStatisticsDataLong(Long.valueOf(1L), Long.valueOf(3L), Long.valueOf(3L), Long.valueOf(0L)));
        columnStatisticsData2.put("c", new CatalogColumnStatisticsDataLong(Long.valueOf(0L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(0L)));
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableColumnStatistics(path2)).isEqualTo((Object)new CatalogColumnStatistics(columnStatisticsData2));
    }

    @Test
    public void testNonPartitionTableWithAllColumns() throws Exception {
        this.tEnv.executeSql("analyze table NonPartitionTable compute statistics for all columns");
        ObjectPath path1 = new ObjectPath(this.tEnv.getCurrentDatabase(), "NonPartitionTable");
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableStatistics(path1)).isEqualTo((Object)new CatalogTableStatistics(5L, -1, -1L, -1L));
        HashMap<String, Object> columnStatisticsData1 = new HashMap<String, Object>();
        columnStatisticsData1.put("a", new CatalogColumnStatisticsDataBoolean(Long.valueOf(2L), Long.valueOf(2L), Long.valueOf(1L)));
        columnStatisticsData1.put("b", new CatalogColumnStatisticsDataLong(Long.valueOf(-128L), Long.valueOf(127L), Long.valueOf(4L), Long.valueOf(1L)));
        columnStatisticsData1.put("c", new CatalogColumnStatisticsDataLong(Long.valueOf(-32768L), Long.valueOf(32767L), Long.valueOf(4L), Long.valueOf(1L)));
        columnStatisticsData1.put("d", new CatalogColumnStatisticsDataLong(Long.valueOf(Integer.MIN_VALUE), Long.valueOf(Integer.MAX_VALUE), Long.valueOf(4L), Long.valueOf(1L)));
        columnStatisticsData1.put("e", new CatalogColumnStatisticsDataLong(Long.valueOf(Long.MIN_VALUE), Long.valueOf(Long.MAX_VALUE), Long.valueOf(4L), Long.valueOf(1L)));
        columnStatisticsData1.put("f", new CatalogColumnStatisticsDataDouble(Double.valueOf(-1.123), Double.valueOf(3.4), Long.valueOf(4L), Long.valueOf(1L)));
        columnStatisticsData1.put("g", new CatalogColumnStatisticsDataDouble(Double.valueOf(-1.123), Double.valueOf(3.4), Long.valueOf(4L), Long.valueOf(1L)));
        columnStatisticsData1.put("h", new CatalogColumnStatisticsDataDouble(Double.valueOf(5.1), Double.valueOf(8.12), Long.valueOf(4L), Long.valueOf(1L)));
        columnStatisticsData1.put("x", new CatalogColumnStatisticsDataDouble(Double.valueOf(1.234567891012345E15), Double.valueOf(8.123456789101234E17), Long.valueOf(4L), Long.valueOf(1L)));
        columnStatisticsData1.put("i", new CatalogColumnStatisticsDataString(Long.valueOf(4L), Double.valueOf(2.5), Long.valueOf(4L), Long.valueOf(1L)));
        columnStatisticsData1.put("j", new CatalogColumnStatisticsDataString(Long.valueOf(4L), Double.valueOf(2.5), Long.valueOf(4L), Long.valueOf(1L)));
        columnStatisticsData1.put("k", new CatalogColumnStatisticsDataDate(new Date(-365L), new Date(18383L), Long.valueOf(4L), Long.valueOf(1L)));
        columnStatisticsData1.put("l", new CatalogColumnStatisticsDataLong(Long.valueOf(123000000L), Long.valueOf(84203000000000L), Long.valueOf(4L), Long.valueOf(1L)));
        columnStatisticsData1.put("m", new CatalogColumnStatisticsDataLong(Long.valueOf(-31536000L), Long.valueOf(1588375403L), Long.valueOf(4L), Long.valueOf(1L)));
        columnStatisticsData1.put("n", new CatalogColumnStatisticsDataLong(Long.valueOf(-31535999877L), Long.valueOf(1588375403000L), Long.valueOf(4L), Long.valueOf(1L)));
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableColumnStatistics(path1)).isEqualTo((Object)new CatalogColumnStatistics(columnStatisticsData1));
        this.tEnv.executeSql("analyze table NonPartitionTable2 compute statistics for all columns");
        ObjectPath path2 = new ObjectPath(this.tEnv.getCurrentDatabase(), "NonPartitionTable2");
        HashMap<String, CatalogColumnStatisticsDataLong> columnStatisticsData2 = new HashMap<String, CatalogColumnStatisticsDataLong>();
        columnStatisticsData2.put("a", new CatalogColumnStatisticsDataLong(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(2L), Long.valueOf(0L)));
        columnStatisticsData2.put("b", new CatalogColumnStatisticsDataLong(Long.valueOf(1L), Long.valueOf(3L), Long.valueOf(3L), Long.valueOf(0L)));
        columnStatisticsData2.put("c", new CatalogColumnStatisticsDataLong(Long.valueOf(0L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(0L)));
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableColumnStatistics(path2)).isEqualTo((Object)new CatalogColumnStatistics(columnStatisticsData2));
    }

    @Test
    public void testNonPartitionTableAnalyzePartialColumnsWithSomeColumnsHaveColumnStats() throws TableNotExistException {
        this.tEnv.executeSql("analyze table NonPartitionTable compute statistics for columns f, a, d");
        ObjectPath path = new ObjectPath(this.tEnv.getCurrentDatabase(), "NonPartitionTable");
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableStatistics(path)).isEqualTo((Object)new CatalogTableStatistics(5L, -1, -1L, -1L));
        HashMap<String, Object> columnStatisticsData = new HashMap<String, Object>();
        columnStatisticsData.put("a", new CatalogColumnStatisticsDataBoolean(Long.valueOf(2L), Long.valueOf(2L), Long.valueOf(1L)));
        columnStatisticsData.put("f", new CatalogColumnStatisticsDataDouble(Double.valueOf(-1.123), Double.valueOf(3.4), Long.valueOf(4L), Long.valueOf(1L)));
        columnStatisticsData.put("d", new CatalogColumnStatisticsDataLong(Long.valueOf(Integer.MIN_VALUE), Long.valueOf(Integer.MAX_VALUE), Long.valueOf(4L), Long.valueOf(1L)));
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableColumnStatistics(path)).isEqualTo((Object)new CatalogColumnStatistics(columnStatisticsData));
        this.tEnv.executeSql("analyze table NonPartitionTable compute statistics for columns d, e");
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableStatistics(path)).isEqualTo((Object)new CatalogTableStatistics(5L, -1, -1L, -1L));
        columnStatisticsData.put("e", new CatalogColumnStatisticsDataLong(Long.valueOf(Long.MIN_VALUE), Long.valueOf(Long.MAX_VALUE), Long.valueOf(4L), Long.valueOf(1L)));
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableColumnStatistics(path)).isEqualTo((Object)new CatalogColumnStatistics(columnStatisticsData));
    }

    @Test
    public void testPartitionTableWithoutPartition() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("analyze table PartitionTable compute statistics")).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid ANALYZE TABLE statement. For partition table, all partition keys should be specified explicitly. The given partition keys: [] are not match the target partition keys: [e,a]");
    }

    @Test
    public void testPartitionTableWithPartitionKeyNotExisted() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("analyze table PartitionTable PARTITION(d) compute statistics")).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid ANALYZE TABLE statement. For partition table, all partition keys should be specified explicitly. The given partition keys: [d] are not match the target partition keys: [e,a]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("analyze table PartitionTable PARTITION(e=1) compute statistics")).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid ANALYZE TABLE statement. For partition table, all partition keys should be specified explicitly. The given partition keys: [e] are not match the target partition keys: [e,a]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("analyze table PartitionTable PARTITION(e=1,d) compute statistics")).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid ANALYZE TABLE statement. For partition table, all partition keys should be specified explicitly. The given partition keys: [e,d] are not match the target partition keys: [e,a]");
    }

    @Test
    public void testPartitionTableWithPartitionValueNotExisted() throws Exception {
        this.tEnv.executeSql("analyze table PartitionTable partition(e=10,a) compute statistics");
        ObjectPath path = new ObjectPath(this.tEnv.getCurrentDatabase(), "PartitionTable");
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableStatistics(path)).isEqualTo((Object)new CatalogTableStatistics(-1L, -1, -1L, -1L));
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableColumnStatistics(path)).isEqualTo((Object)new CatalogColumnStatistics(new HashMap()));
    }

    @Test
    public void testPartitionTableWithColumnsNotExisted() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("analyze table PartitionTable partition(e, a) compute statistics for columns not_existed_column")).isInstanceOf(ValidationException.class)).hasMessageContaining("Column: not_existed_column does not exist in the table: `cat`.`db`.`PartitionTable`");
    }

    @Test
    public void testPartitionTableWithVirtualMetadataColumn() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("analyze table PartitionTable2 PARTITION(a) compute statistics for columns d")).isInstanceOf(ValidationException.class)).hasMessageContaining("Column: d is a metadata column, ANALYZE TABLE does not support metadata column");
    }

    @Test
    public void testPartitionTableWithMetadataColumn() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("analyze table PartitionTable2 PARTITION(a) compute statistics for columns e")).isInstanceOf(ValidationException.class)).hasMessageContaining("Column: e is a metadata column, ANALYZE TABLE does not support metadata column");
    }

    @Test
    public void testPartitionTableWithComputeColumn() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("analyze table PartitionTable2 PARTITION(a) compute statistics for columns f")).isInstanceOf(ValidationException.class)).hasMessageContaining("Column: f is a computed column, ANALYZE TABLE does not support computed column");
    }

    @Test
    public void testPartitionTableWithPartition() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("analyze table NonPartitionTable PARTITION(a) compute statistics")).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid ANALYZE TABLE statement. Table: `cat`.`db`.`NonPartitionTable` is not a partition table, while partition values are given");
    }

    @Test
    public void testPartitionTableWithoutColumns() throws Exception {
        this.tEnv.executeSql("analyze table PartitionTable partition(a, e) compute statistics");
        ObjectPath path = new ObjectPath(this.tEnv.getCurrentDatabase(), "PartitionTable");
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableStatistics(path)).isEqualTo((Object)new CatalogTableStatistics(-1L, -1, -1L, -1L));
        this.assertPartitionStatistics(path, "e=1,a=1", 1L);
        this.assertPartitionStatistics(path, "e=1,a=2", 1L);
        this.assertPartitionStatistics(path, "e=1,a=4", 2L);
        this.assertPartitionStatistics(path, "e=1,a=5", 1L);
        this.assertPartitionStatistics(path, "e=2,a=2", 1L);
        this.assertPartitionStatistics(path, "e=2,a=3", 2L);
        this.assertPartitionStatistics(path, "e=2,a=4", 2L);
        this.assertPartitionStatistics(path, "e=2,a=5", 2L);
        this.assertPartitionStatistics(path, "e=3,a=3", 1L);
        this.assertPartitionStatistics(path, "e=3,a=5", 2L);
        this.tEnv.executeSql("analyze table PartitionTable2 partition(a) compute statistics for all columns");
        ObjectPath path2 = new ObjectPath(this.tEnv.getCurrentDatabase(), "PartitionTable2");
        HashMap<String, CatalogColumnStatisticsDataLong> columnStatisticsData2 = new HashMap<String, CatalogColumnStatisticsDataLong>();
        columnStatisticsData2.put("a", new CatalogColumnStatisticsDataLong(Long.valueOf(1L), Long.valueOf(1L), Long.valueOf(1L), Long.valueOf(0L)));
        columnStatisticsData2.put("b", new CatalogColumnStatisticsDataLong(Long.valueOf(1L), Long.valueOf(1L), Long.valueOf(1L), Long.valueOf(0L)));
        columnStatisticsData2.put("c", new CatalogColumnStatisticsDataLong(Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(1L), Long.valueOf(0L)));
        this.assertPartitionStatistics(path2, "a=1", 1L, new CatalogColumnStatistics(columnStatisticsData2));
        HashMap<String, CatalogColumnStatisticsDataLong> columnStatisticsData3 = new HashMap<String, CatalogColumnStatisticsDataLong>();
        columnStatisticsData3.put("a", new CatalogColumnStatisticsDataLong(Long.valueOf(2L), Long.valueOf(2L), Long.valueOf(1L), Long.valueOf(0L)));
        columnStatisticsData3.put("b", new CatalogColumnStatisticsDataLong(Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(2L), Long.valueOf(0L)));
        columnStatisticsData3.put("c", new CatalogColumnStatisticsDataLong(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(2L), Long.valueOf(0L)));
        this.assertPartitionStatistics(path2, "a=2", 2L, new CatalogColumnStatistics(columnStatisticsData3));
    }

    @Test
    public void testPartitionTableWithFullPartitionPath() throws Exception {
        this.tEnv.executeSql("analyze table PartitionTable partition(e=2, a=5) compute statistics for all columns");
        ObjectPath path = new ObjectPath(this.tEnv.getCurrentDatabase(), "PartitionTable");
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableStatistics(path)).isEqualTo((Object)new CatalogTableStatistics(-1L, -1, -1L, -1L));
        this.assertPartitionStatistics(path, "e=1,a=1", -1L);
        this.assertPartitionStatistics(path, "e=1,a=2", -1L);
        this.assertPartitionStatistics(path, "e=1,a=4", -1L);
        this.assertPartitionStatistics(path, "e=1,a=5", -1L);
        this.assertPartitionStatistics(path, "e=2,a=2", -1L);
        this.assertPartitionStatistics(path, "e=2,a=3", -1L);
        this.assertPartitionStatistics(path, "e=2,a=4", -1L);
        this.assertPartitionStatistics(path, "e=3,a=3", -1L);
        this.assertPartitionStatistics(path, "e=3,a=5", -1L);
        HashMap<String, Object> columnStatisticsData = new HashMap<String, Object>();
        columnStatisticsData.put("a", new CatalogColumnStatisticsDataLong(Long.valueOf(5L), Long.valueOf(5L), Long.valueOf(1L), Long.valueOf(0L)));
        columnStatisticsData.put("b", new CatalogColumnStatisticsDataLong(Long.valueOf(14L), Long.valueOf(15L), Long.valueOf(2L), Long.valueOf(0L)));
        columnStatisticsData.put("c", new CatalogColumnStatisticsDataLong(Long.valueOf(13L), Long.valueOf(14L), Long.valueOf(2L), Long.valueOf(0L)));
        columnStatisticsData.put("d", new CatalogColumnStatisticsDataString(Long.valueOf(3L), Double.valueOf(3.0), Long.valueOf(2L), Long.valueOf(0L)));
        columnStatisticsData.put("e", new CatalogColumnStatisticsDataLong(Long.valueOf(2L), Long.valueOf(2L), Long.valueOf(1L), Long.valueOf(0L)));
        this.assertPartitionStatistics(path, "e=2,a=5", 2L, new CatalogColumnStatistics(columnStatisticsData));
    }

    @Test
    public void testPartitionTableWithPartialPartitionPath() throws Exception {
        this.tEnv.executeSql("analyze table PartitionTable partition(e=2, a) compute statistics");
        ObjectPath path = new ObjectPath(this.tEnv.getCurrentDatabase(), "PartitionTable");
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableStatistics(path)).isEqualTo((Object)new CatalogTableStatistics(-1L, -1, -1L, -1L));
        this.assertPartitionStatistics(path, "e=1,a=1", -1L);
        this.assertPartitionStatistics(path, "e=1,a=2", -1L);
        this.assertPartitionStatistics(path, "e=1,a=4", -1L);
        this.assertPartitionStatistics(path, "e=1,a=5", -1L);
        this.assertPartitionStatistics(path, "e=2,a=2", 1L);
        this.assertPartitionStatistics(path, "e=2,a=3", 2L);
        this.assertPartitionStatistics(path, "e=2,a=4", 2L);
        this.assertPartitionStatistics(path, "e=2,a=5", 2L);
        this.assertPartitionStatistics(path, "e=3,a=3", -1L);
        this.assertPartitionStatistics(path, "e=3,a=5", -1L);
    }

    @Test
    public void testPartitionTableAnalyzePartialColumnsWithSomeColumnsHaveColumnStats() throws Exception {
        this.tEnv.executeSql("analyze table PartitionTable partition(e=2, a=5) compute statistics for columns a, b, c");
        ObjectPath path = new ObjectPath(this.tEnv.getCurrentDatabase(), "PartitionTable");
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableStatistics(path)).isEqualTo((Object)new CatalogTableStatistics(-1L, -1, -1L, -1L));
        HashMap<String, Object> columnStatisticsData = new HashMap<String, Object>();
        columnStatisticsData.put("a", new CatalogColumnStatisticsDataLong(Long.valueOf(5L), Long.valueOf(5L), Long.valueOf(1L), Long.valueOf(0L)));
        columnStatisticsData.put("b", new CatalogColumnStatisticsDataLong(Long.valueOf(14L), Long.valueOf(15L), Long.valueOf(2L), Long.valueOf(0L)));
        columnStatisticsData.put("c", new CatalogColumnStatisticsDataLong(Long.valueOf(13L), Long.valueOf(14L), Long.valueOf(2L), Long.valueOf(0L)));
        this.assertPartitionStatistics(path, "e=2,a=5", 2L, new CatalogColumnStatistics(columnStatisticsData));
        this.tEnv.executeSql("analyze table PartitionTable partition(e=2, a=5) compute statistics for columns c, d");
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableStatistics(path)).isEqualTo((Object)new CatalogTableStatistics(-1L, -1, -1L, -1L));
        columnStatisticsData.put("d", new CatalogColumnStatisticsDataString(Long.valueOf(3L), Double.valueOf(3.0), Long.valueOf(2L), Long.valueOf(0L)));
        this.assertPartitionStatistics(path, "e=2,a=5", 2L, new CatalogColumnStatistics(columnStatisticsData));
    }

    @Test
    public void testPartitionTableAnalyzePartialPartitionWithSomePartitionHaveColumnStats() throws Exception {
        this.tEnv.executeSql("analyze table PartitionTable partition(e=2, a=5) compute statistics for columns a, b, c");
        ObjectPath path = new ObjectPath(this.tEnv.getCurrentDatabase(), "PartitionTable");
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableStatistics(path)).isEqualTo((Object)new CatalogTableStatistics(-1L, -1, -1L, -1L));
        HashMap<String, CatalogColumnStatisticsDataLong> columnStatisticsData1 = new HashMap<String, CatalogColumnStatisticsDataLong>();
        columnStatisticsData1.put("a", new CatalogColumnStatisticsDataLong(Long.valueOf(5L), Long.valueOf(5L), Long.valueOf(1L), Long.valueOf(0L)));
        columnStatisticsData1.put("b", new CatalogColumnStatisticsDataLong(Long.valueOf(14L), Long.valueOf(15L), Long.valueOf(2L), Long.valueOf(0L)));
        columnStatisticsData1.put("c", new CatalogColumnStatisticsDataLong(Long.valueOf(13L), Long.valueOf(14L), Long.valueOf(2L), Long.valueOf(0L)));
        this.assertPartitionStatistics(path, "e=2,a=5", 2L, new CatalogColumnStatistics(columnStatisticsData1));
        this.tEnv.executeSql("analyze table PartitionTable partition(e=2, a=4) compute statistics for columns a, d");
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableStatistics(path)).isEqualTo((Object)new CatalogTableStatistics(-1L, -1, -1L, -1L));
        this.assertPartitionStatistics(path, "e=2,a=5", 2L, new CatalogColumnStatistics(columnStatisticsData1));
        HashMap<String, Object> columnStatisticsData2 = new HashMap<String, Object>();
        columnStatisticsData2.put("a", new CatalogColumnStatisticsDataLong(Long.valueOf(4L), Long.valueOf(4L), Long.valueOf(1L), Long.valueOf(0L)));
        columnStatisticsData2.put("d", new CatalogColumnStatisticsDataString(Long.valueOf(3L), Double.valueOf(3.0), Long.valueOf(2L), Long.valueOf(0L)));
        this.assertPartitionStatistics(path, "e=2,a=4", 2L, new CatalogColumnStatistics(columnStatisticsData2));
    }

    private void assertPartitionStatistics(ObjectPath path, String partitionSpec, long rowCount) throws Exception {
        CatalogPartitionSpec spec = this.createCatalogPartitionSpec(partitionSpec);
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getPartitionStatistics(path, spec)).isEqualTo((Object)new CatalogTableStatistics(rowCount, -1, -1L, -1L));
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableColumnStatistics(path)).isEqualTo((Object)new CatalogColumnStatistics(new HashMap()));
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getPartitionColumnStatistics(path, spec)).isEqualTo((Object)new CatalogColumnStatistics(new HashMap()));
    }

    private void assertPartitionStatistics(ObjectPath path, String partitionSpec, long rowCount, CatalogColumnStatistics columnStats) throws Exception {
        CatalogPartitionSpec spec = this.createCatalogPartitionSpec(partitionSpec);
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getPartitionStatistics(path, spec)).isEqualTo((Object)new CatalogTableStatistics(rowCount, -1, -1L, -1L));
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTableColumnStatistics(path)).isEqualTo((Object)new CatalogColumnStatistics(new HashMap()));
        Assertions.assertThat((Object)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getPartitionColumnStatistics(path, spec)).isEqualTo((Object)columnStats);
    }
}

