/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.flink.table.planner.calcite.FlinkRexBuilder;
import org.apache.flink.table.planner.plan.utils.NestedProjectionUtil$;
import org.apache.flink.table.planner.plan.utils.NestedSchema;
import org.apache.flink.table.planner.plan.utils.RexNodeTestBase;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0001\u0002\u0001#\tAb*Z:uK\u0012\u0004&o\u001c6fGRLwN\\+uS2$Vm\u001d;\u000b\u0005\r!\u0011!B;uS2\u001c(BA\u0003\u0007\u0003\u0011\u0001H.\u00198\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\ty!+\u001a=O_\u0012,G+Z:u\u0005\u0006\u001cX\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u00111\u0003\u0001\u0005\u00067\u0001!I\u0001H\u0001\fCN\u001cXM\u001d;BeJ\f\u0017\u0010F\u0002\u001eG1\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011A!\u00168ji\")AE\u0007a\u0001K\u00051\u0011m\u0019;vC2\u00042A\b\u0014)\u0013\t9sDA\u0003BeJ\f\u0017\u0010E\u0002\u001fM%\u0002\"A\b\u0016\n\u0005-z\"aA%oi\")QF\u0007a\u0001K\u0005AQ\r\u001f9fGR,G\rC\u00030\u0001\u0011\u0005\u0001'A\ruKN$X\t\u001f;sC\u000e$(+\u001a4J]B,HOR5fY\u0012\u001cH#A\u000f)\u00059\u0012\u0004CA\u001a7\u001b\u0005!$BA\u001b\u000f\u0003\u0015QWO\\5u\u0013\t9DG\u0001\u0003UKN$\b\"B\u001d\u0001\t\u0003\u0001\u0014a\b;fgR,\u0005\u0010\u001e:bGR\u0014VM\u001a(fgR,G-\u00138qkR4\u0015.\u001a7eg\"\u0012\u0001H\r\u0005\u0006y\u0001!\t\u0001M\u00014i\u0016\u001cH/\u0012=ue\u0006\u001cG\u000fR3faJ+gMT3ti\u0016$\u0017J\u001c9vi\u001aKW\r\u001c3t+NLgn\u001a(fgR,GMR5fY\u0012D#a\u000f\u001a\t\u000b}\u0002A\u0011\u0001\u0019\u0002+Q,7\u000f\u001e*foJLG/\u001a*fqB\u0013xn\u001a:b[\"\u0012aH\r\u0005\u0006\u0005\u0002!\t\u0001M\u0001'i\u0016\u001cHOU3xe&$XMU#y!J|wM]1n/&$\bNT3ti\u0016$\u0007K]8kK\u000e$\bFA!3\u0011\u0015)\u0005\u0001\"\u00011\u0003)\"Xm\u001d;SK^\u0014\u0018\u000e^3SKb\u0004&o\\4sC6<\u0016\u000e\u001e5EK\u0016\u0004h*Z:uK\u0012\u0004&o\u001c6fGRD#\u0001\u0012\u001a")
public class NestedProjectionUtilTest
extends RexNodeTestBase {
    private void assertArray(int[][] actual, int[][] expected) {
        Assert.assertEquals((long)expected.length, (long)actual.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])actual)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])expected), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            NestedProjectionUtilTest.$anonfun$assertArray$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testExtractRefInputFields() {
        Tuple2<List<RexNode>, RelDataType> tuple2 = this.buildExprs();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List exprs = (List)tuple2._1();
        RelDataType rowType = (RelDataType)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)exprs, (Object)rowType);
        Tuple2 tuple23 = tuple22;
        List exprs2 = (List)tuple23._1();
        RelDataType rowType2 = (RelDataType)tuple23._2();
        NestedSchema nestedFields = NestedProjectionUtil$.MODULE$.build(exprs2, rowType2);
        int[][] actual = NestedProjectionUtil$.MODULE$.convertToIndexArray(nestedFields);
        int[][] expected = (int[][])((Object[])new int[][]{{2}, {3}, {1}});
        this.assertArray(actual, expected);
    }

    @Test
    public void testExtractRefNestedInputFields() {
        Tuple2<List<RexNode>, RelDataType> tuple2 = this.buildExprsWithNesting();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List rexProgram = (List)tuple2._1();
        RelDataType rowType = (RelDataType)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)rexProgram, (Object)rowType);
        Tuple2 tuple23 = tuple22;
        List rexProgram2 = (List)tuple23._1();
        RelDataType rowType2 = (RelDataType)tuple23._2();
        NestedSchema nestedFields = NestedProjectionUtil$.MODULE$.build(rexProgram2, rowType2);
        int[][] actual = NestedProjectionUtil$.MODULE$.convertToIndexArray(nestedFields);
        int[][] expected = (int[][])((Object[])new int[][]{{1, 1}, {0}});
        this.assertArray(actual, expected);
    }

    @Test
    public void testExtractDeepRefNestedInputFieldsUsingNestedField() {
        Tuple2<List<RexNode>, RelDataType> tuple2 = this.buildExprsWithDeepNesting();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List rexProgram = (List)tuple2._1();
        RelDataType rowType = (RelDataType)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)rexProgram, (Object)rowType);
        Tuple2 tuple23 = tuple22;
        List rexProgram2 = (List)tuple23._1();
        RelDataType rowType2 = (RelDataType)tuple23._2();
        NestedSchema nestedFields = NestedProjectionUtil$.MODULE$.build(rexProgram2, rowType2);
        int[][] actual = NestedProjectionUtil$.MODULE$.convertToIndexArray(nestedFields);
        int[][] expected = (int[][])((Object[])new int[][]{{1, 1}, {0}, {2, 0, 0, 0}, {2, 0, 1, 0}, {3, 1, 0}, {3, 0}});
        this.assertArray(actual, expected);
    }

    @Test
    public void testRewriteRexProgram() {
        RexProgram rexProgram = this.buildSimpleRexProgram();
        List exprs = rexProgram.getExprList();
        Object object = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(exprs).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString(), Buffer$.MODULE$.canBuildFrom());
        WrappedArray wrappedArray = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"$0", "$1", "$2", "$3", "$4", "*($t2, $t3)", "100", "<($t5, $t6)", "6", ">($t1, $t8)", "AND($t7, $t9)"});
        Assert.assertTrue((!(object != null ? !object.equals(wrappedArray) : wrappedArray != null) ? 1 : 0) != 0);
        NestedSchema nestedField = NestedProjectionUtil$.MODULE$.build(exprs, rexProgram.getInputRowType());
        int[][] paths = NestedProjectionUtil$.MODULE$.convertToIndexArray(nestedField);
        int[][] orderedPaths = (int[][])((Object[])new int[][]{{0}, {1}, {2}, {3}, {4}});
        this.assertArray(paths, orderedPaths);
        FlinkRexBuilder builder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Buffer projectExprs = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexProgram.getProjectList()).map((Function1 & Serializable & scala.Serializable)expr -> rexProgram.expandLocalRef(expr), Buffer$.MODULE$.canBuildFrom());
        List newProjectExprs = NestedProjectionUtil$.MODULE$.rewrite(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(projectExprs), nestedField, (RexBuilder)builder);
        RexNode conditionExprs = rexProgram.expandLocalRef(rexProgram.getCondition());
        List newConditionExprs = NestedProjectionUtil$.MODULE$.rewrite(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{conditionExprs}))), nestedField, (RexBuilder)builder);
        Object object2 = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newProjectExprs).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toString(), Buffer$.MODULE$.canBuildFrom());
        WrappedArray wrappedArray2 = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"$2", "*($2, $3)"});
        Assert.assertTrue((!(object2 != null ? !object2.equals(wrappedArray2) : wrappedArray2 != null) ? 1 : 0) != 0);
        Object object3 = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newConditionExprs).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString(), Buffer$.MODULE$.canBuildFrom());
        WrappedArray wrappedArray3 = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AND(<(*($2, $3), 100), >($1, 6))"});
        Assert.assertTrue((!(object3 != null ? !object3.equals(wrappedArray3) : wrappedArray3 != null) ? 1 : 0) != 0);
    }

    @Test
    public void testRewriteRExProgramWithNestedProject() {
        Tuple2<List<RexNode>, RelDataType> tuple2 = this.buildExprsWithNesting();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List exprs = (List)tuple2._1();
        RelDataType rowType = (RelDataType)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)exprs, (Object)rowType);
        Tuple2 tuple23 = tuple22;
        List exprs2 = (List)tuple23._1();
        RelDataType rowType2 = (RelDataType)tuple23._2();
        Object object = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(exprs2).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toString(), Buffer$.MODULE$.canBuildFrom());
        WrappedArray wrappedArray = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"$1.amount", "$0", "100"});
        Assert.assertTrue((!(object != null ? !object.equals(wrappedArray) : wrappedArray != null) ? 1 : 0) != 0);
        NestedSchema nestedField = NestedProjectionUtil$.MODULE$.build(exprs2, rowType2);
        int[][] paths = NestedProjectionUtil$.MODULE$.convertToIndexArray(nestedField);
        int[][] orderedPaths = (int[][])((Object[])new int[][]{{1, 1}, {0}});
        this.assertArray(paths, orderedPaths);
        List newExprs = NestedProjectionUtil$.MODULE$.rewrite(exprs2, nestedField, (RexBuilder)new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory()));
        Object object2 = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newExprs).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toString(), Buffer$.MODULE$.canBuildFrom());
        WrappedArray wrappedArray2 = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"$0", "$1", "100"});
        Assert.assertTrue((!(object2 != null ? !object2.equals(wrappedArray2) : wrappedArray2 != null) ? 1 : 0) != 0);
    }

    @Test
    public void testRewriteRexProgramWithDeepNestedProject() {
        Tuple2<List<RexNode>, RelDataType> tuple2 = this.buildExprsWithDeepNesting();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List exprs = (List)tuple2._1();
        RelDataType rowType = (RelDataType)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)exprs, (Object)rowType);
        Tuple2 tuple23 = tuple22;
        List exprs2 = (List)tuple23._1();
        RelDataType rowType2 = (RelDataType)tuple23._2();
        Object object = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(exprs2).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toString(), Buffer$.MODULE$.canBuildFrom());
        WrappedArray wrappedArray = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*($1.amount, 10)", "$0.passport.status", "$2.with.deep.entry", "$2.with.deeper.entry.inside.entry", "$2.with.deeper.entry", "$0", "ITEM(ITEM($3.inner.deep_array, $3.outer).deep_map, _UTF-16LE'item')"});
        Assert.assertTrue((!(object != null ? !object.equals(wrappedArray) : wrappedArray != null) ? 1 : 0) != 0);
        NestedSchema nestedFields = NestedProjectionUtil$.MODULE$.build(exprs2, rowType2);
        int[][] paths = NestedProjectionUtil$.MODULE$.convertToIndexArray(nestedFields);
        int[][] orderedPaths = (int[][])((Object[])new int[][]{{1, 1}, {0}, {2, 0, 0, 0}, {2, 0, 1, 0}, {3, 1, 0}, {3, 0}});
        this.assertArray(paths, orderedPaths);
        List newExprs = NestedProjectionUtil$.MODULE$.rewrite(exprs2, nestedFields, (RexBuilder)new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory()));
        Object object2 = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newExprs).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toString(), Buffer$.MODULE$.canBuildFrom());
        WrappedArray wrappedArray2 = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*($0, 10)", "$1.passport.status", "$2", "$3.inside.entry", "$3", "$1", "ITEM(ITEM($4, $5).deep_map, _UTF-16LE'item')"});
        Assert.assertTrue((!(object2 != null ? !object2.equals(wrappedArray2) : wrappedArray2 != null) ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$assertArray$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] result = (int[])tuple2._1();
        int[] expect = (int[])tuple2._2();
        Predef$.MODULE$.assert(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(result)).sameElements((GenIterable)Predef$.MODULE$.wrapIntArray(expect)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }
}

