/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.join;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$;
import org.apache.flink.table.planner.plan.stream.sql.join.TestInvalidTemporalTable$;
import org.apache.flink.table.planner.plan.stream.sql.join.TestTemporalTable$;
import org.apache.flink.table.planner.plan.utils.AsyncTableFunctionWithRow;
import org.apache.flink.table.planner.plan.utils.AsyncTableFunctionWithRowDataVarArg;
import org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature1;
import org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature2;
import org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature3;
import org.apache.flink.table.planner.plan.utils.InvalidTableFunctionEvalSignature;
import org.apache.flink.table.planner.plan.utils.InvalidTableFunctionResultType;
import org.apache.flink.table.planner.plan.utils.TableFunctionWithRow;
import org.apache.flink.table.planner.plan.utils.TableFunctionWithRowDataVarArg;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\tUc\u0001B\u0001\u0003\u0001U\u0011a\u0002T8pWV\u0004(j\\5o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005!!n\\5o\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\rM$(/Z1n\u0015\tI!\"\u0001\u0003qY\u0006t'BA\u0006\r\u0003\u001d\u0001H.\u00198oKJT!!\u0004\b\u0002\u000bQ\f'\r\\3\u000b\u0005=\u0001\u0012!\u00024mS:\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001-q\u0001\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0006\u0002\u000bU$\u0018\u000e\\:\n\u0005mA\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\r\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003EaWmZ1dsR\u000b'\r\\3T_V\u00148-\u001a\t\u0003;\u0015J!A\n\u0010\u0003\u000f\t{w\u000e\\3b]\")\u0001\u0006\u0001C\u0001S\u00051A(\u001b8jiz\"\"A\u000b\u0017\u0011\u0005-\u0002Q\"\u0001\u0002\t\u000b\r:\u0003\u0019\u0001\u0013\t\u000f9\u0002!\u0019!C\u0005_\u0005!Q\u000f^5m+\u0005\u0001\u0004CA\f2\u0013\t\u0011\u0004DA\nTiJ,\u0017-\u001c+bE2,G+Z:u+RLG\u000e\u0003\u00045\u0001\u0001\u0006I\u0001M\u0001\u0006kRLG\u000e\t\u0005\u0006m\u0001!\taN\u0001\u0007E\u00164wN]3\u0015\u0003a\u0002\"!H\u001d\n\u0005ir\"\u0001B+oSRD#!\u000e\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\u0012\u0012!\u00026v]&$\u0018BA!?\u0005\u0019\u0011UMZ8sK\")1\t\u0001C\u0001o\u0005\u0001C/Z:u\u0015>Lg.\u00138wC2LGMS8j]R+W\u000e]8sC2$\u0016M\u00197fQ\t\u0011U\t\u0005\u0002>\r&\u0011qI\u0010\u0002\u0005)\u0016\u001cH\u000fC\u0003J\u0001\u0011\u0005q'\u0001\u0012uKN$hj\u001c;ESN$\u0018N\\2u\rJ|W.\u00138K_&t7i\u001c8eSRLwN\u001c\u0015\u0003\u0011\u0016CQ\u0001\u0014\u0001\u0005\u0002]\na\u0004^3ti&sg/\u00197jI2{wn[;q)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8)\u0005-+\u0005\"B(\u0001\t\u00039\u0014a\u0007;fgRTu.\u001b8P]\u0012KgMZ3sK:$8*Z=UsB,7\u000f\u000b\u0002O\u000b\")!\u000b\u0001C\u0001o\u0005)B/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,\u0007FA)F\u0011\u0015)\u0006\u0001\"\u00018\u0003e!Xm\u001d;MK\u001a$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3)\u0005Q+\u0005\"\u0002-\u0001\t\u00039\u0014\u0001\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"tUm\u001d;fIF+XM]=)\u0005]+\u0005\"B.\u0001\t\u00039\u0014a\u000b;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"\u0004&o\u001c6fGRLwN\u001c)vg\"$un\u001e8)\u0005i+\u0005\"\u00020\u0001\t\u00039\u0014a\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"4\u0015\u000e\u001c;feB+8\u000f\u001b#po:D#!X#\t\u000b\u0005\u0004A\u0011A\u001c\u0002KQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f[\"bY\u000e\u0004Vo\u001d5E_^t\u0007F\u00011F\u0011\u0015!\u0007\u0001\"\u00018\u0003%\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5Nk2$\u0018.\u00138eKb\u001cu\u000e\\;n]\"\u00121-\u0012\u0005\u0006O\u0002!\taN\u0001\u001bi\u0016\u001cH/\u0011<pS\u0012\fum\u001a:fO\u0006$X\rU;tQ\u0012{wO\u001c\u0015\u0003M\u0016CQA\u001b\u0001\u0005\u0002]\na\u0005^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQR\u0013X/Z\"p]\u0012LG/[8oQ\tIW\tC\u0003n\u0001\u0011\u0005q'A\u001buKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDg)\u001e8di&|g.\u00118e\u0007>t7\u000f^1oi\u000e{g\u000eZ5uS>t\u0007F\u00017F\u0011\u0015\u0001\b\u0001\"\u00018\u0003i\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5Nk2$\u0018NR;oGRLwN\\!oI\u000e{gn\u001d;b]R\u001cuN\u001c3ji&|g\u000e\u000b\u0002p\u000b\")1\u000f\u0001C\u0001o\u00051D/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i\rVt7\r^5p]\u0006sGMU3gKJ,gnY3D_:$\u0017\u000e^5p]\"\u0012!/\u0012\u0005\u0006m\u0002!\taN\u0001(i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b.\u00163g\u000bF,\u0018\r\u001c$jYR,'\u000f\u000b\u0002v\u000b\")\u0011\u0010\u0001C\u0001o\u00059C/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i\u0007>l\u0007/\u001e;fI\u000e{G.^7oQ\tAX\tC\u0003}\u0001\u0011\u0005q'\u0001\u001auKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRD7i\\7qkR,GmQ8mk6t\u0017I\u001c3QkNDGi\\<oQ\tYX\tC\u0003\u0000\u0001\u0011\u0005q'A\u001buKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDW*\u001e7uS\u000e{g\u000eZ5uS>twJ\\*b[\u0016$\u0015.\u001c$jK2$\u0007F\u0001@F\u0011\u0019\t)\u0001\u0001C\u0001o\u0005QC/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i\u0007\u0006\u001cHo\u00148M_>\\W\u000f\u001d+bE2,\u0007fAA\u0002\u000b\"1\u00111\u0002\u0001\u0005\u0002]\nq\u0007^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ&sG/\u001a:pa\u0016\u0014\u0018M\u00197f\u0007\u0006\u001cHo\u00148M_>\\W\u000f\u001d+bE2,\u0007fAA\u0005\u000b\"1\u0011\u0011\u0003\u0001\u0005\u0002]\nA\u0004^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ\u000e#V\tK\u0002\u0002\u0010\u0015Ca!a\u0006\u0001\t\u00039\u0014\u0001\r;fgR\fumZ!oI\u0006cGnQ8ogR\fg\u000e\u001e'p_.,\boS3z/&$\b\u000e\u0016:z%\u0016\u001cx\u000e\u001c<f\u001b>$W\rK\u0002\u0002\u0016\u0015Ca!!\b\u0001\t\u00039\u0014a\u0005;fgRLeN^1mS\u0012Tu.\u001b8IS:$\bfAA\u000e\u000b\"1\u00111\u0005\u0001\u0005\u0002]\n!\u0004^3ti*{\u0017N\u001c%j]R<\u0016\u000e\u001e5UC\ndW-\u00117jCND3!!\tF\u0011\u0019\tI\u0003\u0001C\u0001o\u0005iB/Z:u\u0015>Lg\u000eS5oi^KG\u000f\u001b+bE2,g*Y7f\u001f:d\u0017\u0010K\u0002\u0002(\u0015Ca!a\f\u0001\t\u00039\u0014A\b;fgRTu.\u001b8Ts:\u001cG+\u00192mK^KG\u000f[!ts:\u001c\u0007*\u001b8uQ\r\ti#\u0012\u0005\u0007\u0003k\u0001A\u0011A\u001c\u0002?Q,7\u000f\u001e&pS:\f5/\u001f8d)\u0006\u0014G.Z,ji\"\f5/\u001f8d\u0011&tG\u000fK\u0002\u00024\u0015Ca!a\u000f\u0001\t\u00039\u0014A\b;fgRTu.\u001b8Bgft7\rV1cY\u0016<\u0016\u000e\u001e5Ts:\u001c\u0007*\u001b8uQ\r\tI$\u0012\u0005\u0007\u0003\u0003\u0002A\u0011A\u001c\u0002AQ,7\u000f^!hO\u0006sG\rT3gi*{\u0017N\\!mY><XK\\8sI\u0016\u0014X\r\u001a\u0015\u0004\u0003\u007f)\u0005BBA$\u0001\u0011\u0005q'\u0001\u0013uKN$\u0018iZ4B]\u0012dUM\u001a;K_&tw+\u001b;i)JL(+Z:pYZ,Wj\u001c3f\u0011\u0019\tY\u0005\u0001C\u0001o\u0005qB/Z:u\u0003NLhn\u0019&pS:<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;QCJ\fWn\u001d\u0015\u0004\u0003\u0013*\u0005BBA)\u0001\u0011\u0005q'A\u000buKN$(j\\5o/&$\b.Q:z]\u000eD\u0015N\u001c;)\u0007\u0005=S\t\u0003\u0004\u0002X\u0001!\taN\u0001\u0016i\u0016\u001cHOS8j]^KG\u000f\u001b*fiJL\b*\u001b8uQ\r\t)&\u0012\u0005\u0007\u0003;\u0002A\u0011A\u001c\u0002;Q,7\u000f\u001e&pS:<\u0016\u000e\u001e5Bgft7-\u00118e%\u0016$(/\u001f%j]RD3!a\u0017F\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003K\n\u0011c\u0019:fCR,Gj\\8lkB$\u0016M\u00197f)\u0015A\u0014qMAA\u0011!\tI'!\u0019A\u0002\u0005-\u0014!\u0003;bE2,g*Y7f!\u0011\ti'a\u001f\u000f\t\u0005=\u0014q\u000f\t\u0004\u0003crRBAA:\u0015\r\t)\bF\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005ed$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003{\nyH\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003sr\u0002\u0002CAB\u0003C\u0002\r!!\"\u0002\u001d1|wn[;q\rVt7\r^5p]B!\u0011qQAG\u001b\t\tIIC\u0002\u0002\f2\t\u0011BZ;oGRLwN\\:\n\t\u0005=\u0015\u0011\u0012\u0002\u0014+N,'\u000fR3gS:,GMR;oGRLwN\u001c\u0005\b\u0003'\u0003A\u0011BAK\u0003U)\u0007\u0010]3di\u0016C8-\u001a9uS>tG\u000b\u001b:po:$r\u0001OAL\u00033\u000bi\nC\u0004\u0006\u0003#\u0003\r!a\u001b\t\u0011\u0005m\u0015\u0011\u0013a\u0001\u0003W\nq!\\3tg\u0006<W\r\u0003\u0006\u0002 \u0006E\u0005\u0013!a\u0001\u0003C\u000bQa\u00197buj\u0004D!a)\u0002.B1\u0011QNAS\u0003SKA!a*\u0002\u0000\t)1\t\\1tgB!\u00111VAW\u0019\u0001!A\"a,\u0002\u001e\u0006\u0005\t\u0011!B\u0001\u0003c\u00131a\u0018\u00132#\u0011\t\u0019,!/\u0011\u0007u\t),C\u0002\u00028z\u0011qAT8uQ&tw\r\u0005\u0003\u0002<\u0006\u0015g\u0002BA_\u0003\u0003tA!!\u001d\u0002@&\tq$C\u0002\u0002Dz\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002H\u0006%'!\u0003+ie><\u0018M\u00197f\u0015\r\t\u0019M\b\u0005\b\u0003\u001b\u0004A\u0011BAh\u0003a1XM]5gsR\u0013\u0018M\\:mCRLwN\\*vG\u000e,7o\u001d\u000b\u0004q\u0005E\u0007bB\u0003\u0002L\u0002\u0007\u00111\u000e\u0005\n\u0003+\u0004\u0011\u0013!C\u0005\u0003/\fq$\u001a=qK\u000e$X\t_2faRLwN\u001c+ie><h\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\tI\u000e\r\u0003\u0002\\\u0006}\u0007CBA7\u0003K\u000bi\u000e\u0005\u0003\u0002,\u0006}G\u0001DAX\u0003'\f\t\u0011!A\u0003\u0002\u0005E\u0006f\u0002\u0001\u0002d\u0006=\u0018\u0011\u001f\t\u0005\u0003K\fY/\u0004\u0002\u0002h*\u0019\u0011\u0011\u001e \u0002\rI,hN\\3s\u0013\u0011\ti/a:\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\u0012\u00111\u001f\t\u0005\u0003k\fY0\u0004\u0002\u0002x*\u0019\u0011\u0011  \u0002\u000fI,hN\\3sg&!\u0011Q`A|\u00055\u0001\u0016M]1nKR,'/\u001b>fI\u001e9!\u0011\u0001\u0002\t\u0002\t\r\u0011A\u0004'p_.,\bOS8j]R+7\u000f\u001e\t\u0004W\t\u0015aAB\u0001\u0003\u0011\u0003\u00119aE\u0003\u0003\u0006\t%A\u0004E\u0002\u001e\u0005\u0017I1A!\u0004\u001f\u0005\u0019\te.\u001f*fM\"9\u0001F!\u0002\u0005\u0002\tEAC\u0001B\u0002\u0011!\u0011)B!\u0002\u0005\u0002\t]\u0011A\u00039be\u0006lW\r^3sgR\u0011!\u0011\u0004\t\u0007\u00057\u0011\u0019Ca\n\u000e\u0005\tu!b\u0001\u0018\u0003 )\u0011!\u0011E\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003&\tu!AC\"pY2,7\r^5p]B)QD!\u000b\u0003.%\u0019!1\u0006\u0010\u0003\u000b\u0005\u0013(/Y=\u0011\t\t=\"QG\u0007\u0003\u0005cQAAa\r\u0003 \u0005!A.\u00198h\u0013\u0011\u00119D!\r\u0003\r=\u0013'.Z2uQ!\u0011\u0019Ba\u000f\u0003J\t-\u0003\u0003\u0002B\u001f\u0005\u0007rA!!>\u0003@%!!\u0011IA|\u00035\u0001\u0016M]1nKR,'/\u001b>fI&!!Q\tB$\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0005\u0005\u0003\n90\u0001\u0003oC6,\u0017E\u0001B'\u0003UaUmZ1dsR\u000b'\r\\3T_V\u00148-Z\u001f|auD!B!\u0015\u0003\u0006\u0005\u0005I\u0011\u0002B*\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t5\u0002")
public class LookupJoinTest
extends TableTestBase
implements scala.Serializable {
    private final boolean legacyTableSource;
    private final StreamTableTestUtil util;

    @Parameterized.Parameters(name="LegacyTableSource={0}")
    public static Collection<Object[]> parameters() {
        return LookupJoinTest$.MODULE$.parameters();
    }

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Before
    public void before() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("T1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>>(this, fieldSerializers){

                    public Tuple4<Object, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("nonTemporal", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$$anon$7 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        if (this.legacyTableSource) {
            TestTemporalTable$.MODULE$.createTemporaryTable(this.util().tableEnv(), "LookupTable", TestTemporalTable$.MODULE$.createTemporaryTable$default$3(), TestTemporalTable$.MODULE$.createTemporaryTable$default$4());
            TableEnvironment x$1 = this.util().tableEnv();
            String x$2 = "AsyncLookupTable";
            boolean x$3 = true;
            boolean x$4 = TestTemporalTable$.MODULE$.createTemporaryTable$default$3();
            TestTemporalTable$.MODULE$.createTemporaryTable(x$1, x$2, x$4, x$3);
        } else {
            this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE TABLE LookupTable (\n                      |  `id` INT,\n                      |  `name` STRING,\n                      |  `age` INT\n                      |) WITH (\n                      |  'connector' = 'values'\n                      |)\n                      |")).stripMargin());
            this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE TABLE AsyncLookupTable (\n                      |  `id` INT,\n                      |  `name` STRING,\n                      |  `age` INT\n                      |) WITH (\n                      |  'connector' = 'values',\n                      |  'async' = 'true'\n                      |)\n                      |")).stripMargin());
            this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE TABLE LookupTableWithComputedColumn (\n                      |  `id` INT,\n                      |  `name` STRING,\n                      |  `age` INT,\n                      |  `nominal_age` as age + 1\n                      |) WITH (\n                      |  'connector' = 'values',\n                      |  'bounded' = 'true'\n                      |)\n                      |")).stripMargin());
        }
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE Sink1 (\n                    |  a int,\n                    |  name varchar,\n                    |  age int\n                    |) with (\n                    |  'connector' = 'values',\n                    |  'sink-insert-only' = 'false'\n                    |)")).stripMargin());
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)4));
    }

    @Test
    public void testJoinInvalidJoinTemporalTable() {
        this.expectExceptionThrown("SELECT * FROM MyTable AS T JOIN LookupTable T.proctime AS D ON T.a = D.id", "SQL parse failed", SqlParserException.class);
        this.expectExceptionThrown("SELECT * FROM LookupTable FOR SYSTEM_TIME AS OF TIMESTAMP '2017-08-09 14:36:11'", "Temporal table can only be used in temporal join and only supports 'FOR SYSTEM_TIME AS OF' left table's time attribute field.\nQuerying a temporal table using 'FOR SYSTEM TIME AS OF' syntax with a constant timestamp '2017-08-09 14:36:11' is not supported yet", AssertionError.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T RIGHT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id", "Correlate has invalid join type RIGHT", AssertionError.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a + 1 = D.id + 2", "Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable].", TableException.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF PROCTIME() AS D ON T.a = D.id", "Temporal table can only be used in temporal join and only supports 'FOR SYSTEM_TIME AS OF' left table's time attribute field.\nQuerying a temporal table using 'FOR SYSTEM TIME AS OF' syntax with an expression call 'PROCTIME()' is not supported yet.", AssertionError.class);
    }

    @Test
    public void testNotDistinctFromInJoinCondition() {
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a IS NOT  DISTINCT FROM D.id", "LookupJoin doesn't support join condition contains 'a IS NOT DISTINCT FROM b' (or alternative '(a = b) or (a IS NULL AND b IS NULL)')", TableException.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id OR (T.a IS NULL AND D.id IS NULL)", "LookupJoin doesn't support join condition contains 'a IS NOT DISTINCT FROM b' (or alternative '(a = b) or (a IS NULL AND b IS NULL)')", TableException.class);
    }

    @Test
    public void testInvalidLookupTableFunction() {
        if (this.legacyTableSource) {
            return;
        }
        this.util().addDataStream("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple4<Object, String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple4<Object, String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)((Timestamp)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.createLookupTable("LookupTable1", (UserDefinedFunction)new InvalidTableFunctionResultType());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable1 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "output class can simply be a Row or RowData class", ValidationException.class);
        this.createLookupTable("LookupTable2", (UserDefinedFunction)new InvalidTableFunctionEvalSignature());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable2 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidTableFunctionEvalSignature' for function 'default_catalog.default_database.LookupTable2' that matches the following signature:\nvoid eval(java.lang.Integer, org.apache.flink.table.data.StringData, org.apache.flink.table.data.TimestampData)", ValidationException.class);
        this.createLookupTable("LookupTable3", (UserDefinedFunction)new TableFunctionWithRowDataVarArg());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable3 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable4", (UserDefinedFunction)new TableFunctionWithRow());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable4 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable5", (UserDefinedFunction)new AsyncTableFunctionWithRowDataVarArg());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable5 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable6", (UserDefinedFunction)new AsyncTableFunctionWithRow());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable6 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable7", (UserDefinedFunction)new InvalidAsyncTableFunctionEvalSignature1());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable7 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature1' for function 'default_catalog.default_database.LookupTable7' that matches the following signature:\nvoid eval(java.util.concurrent.CompletableFuture, java.lang.Integer, org.apache.flink.table.data.StringData, org.apache.flink.table.data.TimestampData)", ValidationException.class);
        this.createLookupTable("LookupTable8", (UserDefinedFunction)new InvalidAsyncTableFunctionEvalSignature2());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable8 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature2' for function 'default_catalog.default_database.LookupTable8' that matches the following signature:\nvoid eval(java.util.concurrent.CompletableFuture, java.lang.Integer, java.lang.String, java.time.LocalDateTime)", ValidationException.class);
        this.createLookupTable("LookupTable9", (UserDefinedFunction)new AsyncTableFunctionWithRowDataVarArg());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable9 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable10", (UserDefinedFunction)new InvalidAsyncTableFunctionEvalSignature3());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable10 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature3' for function 'default_catalog.default_database.LookupTable10' that matches the following signature:\nvoid eval(java.util.concurrent.CompletableFuture, java.lang.Integer, org.apache.flink.table.data.StringData, org.apache.flink.table.data.TimestampData)", ValidationException.class);
    }

    @Test
    public void testJoinOnDifferentKeyTypes() {
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("implicit type conversion between VARCHAR(2147483647) and INTEGER is not supported on join's condition now");
        this.util().verifyExecPlan("SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.b = D.id");
    }

    @Test
    public void testJoinTemporalTable() {
        String sql = "SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testLeftJoinTemporalTable() {
        String sql = "SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithNestedQuery() {
        String sql = "SELECT * FROM (SELECT a, b, proctime FROM MyTable WHERE c > 1000) AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithProjectionPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT T.*, D.id\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithFilterPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10\n        |WHERE T.c > 1000\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithCalcPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10\n        |WHERE cast(D.name as bigint) > 1000\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithMultiIndexColumn() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10 AND D.name = 'AAA'\n        |WHERE T.c > 1000\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAvoidAggregatePushDown() {
        String sql1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, a, sum(c) c, sum(d) d, PROCTIME() as proc\n        |FROM T1\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(153).append("\n         |SELECT T.* FROM (").append(sql1).append(") AS T\n         |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proc AS D\n         |ON T.a = D.id\n         |WHERE D.age > 10\n      ").toString())).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(96).append("\n         |SELECT b, count(a), sum(c), sum(d)\n         |FROM (").append(sql2).append(") AS T\n         |GROUP BY b\n      ").toString())).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithTrueCondition() {
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable]");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON true\n        |WHERE T.c > 1000\n      ")).stripMargin();
        this.util().verifyExplain(sql);
    }

    @Test
    public void testJoinTemporalTableWithFunctionAndConstantCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.b = concat(D.name, '!') AND D.age = 11\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithMultiFunctionAndConstantCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id + 1 AND T.b = concat(D.name, '!') AND D.age = 11\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithFunctionAndReferenceCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND T.b = concat(D.name, '!')\n        |WHERE D.name LIKE 'Jack%'\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithUdfEqualFilter() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name\n        |FROM\n        |  MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |WHERE CONCAT('Hello-', D.name) = 'Hello-Jark'\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithComputedColumn() {
        Assume.assumeFalse((boolean)this.legacyTableSource);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name, D.age, D.nominal_age\n        |FROM\n        |  MyTable AS T JOIN LookupTableWithComputedColumn FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON T.a = D.id\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithComputedColumnAndPushDown() {
        Assume.assumeFalse((boolean)this.legacyTableSource);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name, D.age, D.nominal_age\n        |FROM\n        |  MyTable AS T JOIN LookupTableWithComputedColumn FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON T.a = D.id and D.nominal_age > 12\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithMultiConditionOnSameDimField() {
        String sql = "SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id and CAST(T.c as INT) = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithCastOnLookupTable() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE LookupTable2 (\n                    |  `id` decimal(38, 18),\n                    |  `name` STRING,\n                    |  `age` INT\n                    |) WITH (\n                    |  'connector' = 'values'\n                    |)\n                    |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MyTable.b, LookupTable2.id\n        |FROM MyTable\n        |LEFT JOIN LookupTable2 FOR SYSTEM_TIME AS OF MyTable.`proctime`\n        |ON MyTable.a = CAST(LookupTable2.`id` as INT)\n        |")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable2]");
        this.verifyTranslationSuccess(sql);
    }

    @Test
    public void testJoinTemporalTableWithInteroperableCastOnLookupTable() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE LookupTable2 (\n                    |  `id` INT,\n                    |  `name` char(10),\n                    |  `age` INT\n                    |) WITH (\n                    |  'connector' = 'values'\n                    |)\n                    |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MyTable.b, LookupTable2.id\n        |FROM MyTable\n        |LEFT JOIN LookupTable2 FOR SYSTEM_TIME AS OF MyTable.`proctime`\n        |ON MyTable.b = CAST(LookupTable2.`name` as String)\n        |")).stripMargin();
        this.verifyTranslationSuccess(sql);
    }

    @Test
    public void testJoinTemporalTableWithCTE() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH MyLookupTable AS (SELECT * FROM MyTable),\n        |OtherLookupTable AS (SELECT * FROM LookupTable)\n        |SELECT MyLookupTable.b FROM MyLookupTable\n        |JOIN OtherLookupTable FOR SYSTEM_TIME AS OF MyLookupTable.proctime AS D\n        |ON MyLookupTable.a = D.id AND D.age = 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAggAndAllConstantLookupKeyWithTryResolveMode() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY, (Object)OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT T.a, D.name, D.age\n        |FROM (SELECT max(a) a, count(c) c, PROCTIME() proctime FROM MyTable GROUP BY b) T\n        | LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON D.id = 100\n      ")).stripMargin();
        String actual = this.util().tableEnv().explainSql(sql, new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN});
        String expected = this.legacyTableSource ? TableTestUtil$.MODULE$.readFromResource("explain/stream/join/lookup/testAggAndAllConstantLookupKeyWithTryResolveMode.out") : TableTestUtil$.MODULE$.readFromResource("explain/stream/join/lookup/testAggAndAllConstantLookupKeyWithTryResolveMode_newSource.out");
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceNodeIdInOperator(TableTestUtil$.MODULE$.replaceStreamNodeId(TableTestUtil$.MODULE$.replaceStageId(expected))), (Object)TableTestUtil$.MODULE$.replaceNodeIdInOperator(TableTestUtil$.MODULE$.replaceStreamNodeId(TableTestUtil$.MODULE$.replaceStageId(actual))));
    }

    @Test
    public void testInvalidJoinHint() {
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('tableName'='LookupTable') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint: incomplete required option(s): [Key: 'table' , default: null (fallback keys: [])]", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'async'='yes') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value 'yes' for key 'async'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'async'='true', 'output-mode'='allow-unordered') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value 'allow-unordered' for key 'output-mode'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'async'='true', 'timeout'='300 si') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value '300 si' for key 'timeout'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-strategy'='fixed-delay') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value 'fixed-delay' for key 'retry-strategy'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'fixed-delay'='100 nano sec') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value '100 nano sec' for key 'fixed-delay'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'max-attempts'='100.0') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value '100.0' for key 'max-attempts'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'max-attempts'='100') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint: retry options can be both null or all not null", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-predicate'='exception', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='-3') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint option: unsupported retry-predicate 'exception', only 'lookup_miss' is supported currently", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='-3') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint option: max-attempts value should be positive integer but was -3", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='-10s', 'max-attempts'='3') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value '-10s' for key 'fixed-delay'", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-predicate'='lookup-miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='3') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint option: unsupported retry-predicate 'lookup-miss', only 'lookup_miss' is supported currently", AssertionError.class);
        this.expectExceptionThrown(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed-delay', 'fixed-delay'='10s', 'max-attempts'='3') */ *\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        | ON T.a = D.id\n        |")).stripMargin(), "Invalid LOOKUP hint options: Could not parse value 'fixed-delay' for key 'retry-strategy'", AssertionError.class);
    }

    @Test
    public void testJoinHintWithTableAlias() {
        this.thrown().expectMessage("The options of following hints cannot match the name of input tables or views: \n`D` in `LOOKUP`");
        this.thrown().expect(ValidationException.class);
        String sql = "SELECT /*+ LOOKUP('table'='D') */ * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinHintWithTableNameOnly() {
        String sql = "SELECT /*+ LOOKUP('table'='LookupTable') */ * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinSyncTableWithAsyncHint() {
        String sql = "SELECT /*+ LOOKUP('table'='LookupTable', 'async'='true') */ * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinAsyncTableWithAsyncHint() {
        String sql = "SELECT /*+ LOOKUP('table'='AsyncLookupTable', 'async'='true') */ * FROM MyTable AS T JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinAsyncTableWithSyncHint() {
        String sql = "SELECT /*+ LOOKUP('table'='AsyncLookupTable', 'async'='false') */ * FROM MyTable AS T JOIN AsyncLookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAggAndLeftJoinAllowUnordered() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_OUTPUT_MODE, (Object)ExecutionConfigOptions.AsyncOutputMode.ALLOW_UNORDERED);
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT T.a, D.name, D.age\n        |FROM (SELECT max(a) a, count(c) c, PROCTIME() proctime FROM MyTable GROUP BY b) T\n        |LEFT JOIN AsyncLookupTable\n        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |")).stripMargin());
        this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    public void testAggAndLeftJoinWithTryResolveMode() {
        this.thrown().expectMessage("Required sync lookup function by planner, but table");
        this.thrown().expect(TableException.class);
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY, (Object)OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE);
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT T.a, D.name, D.age\n        |FROM (SELECT max(a) a, count(c) c, PROCTIME() proctime FROM MyTable GROUP BY b) T\n        |LEFT JOIN AsyncLookupTable\n        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |")).stripMargin());
        this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testAsyncJoinWithDefaultParams() {
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                        |INSERT INTO Sink1\n                        |SELECT T.a, D.name, D.age\n                        |FROM MyTable T\n                        |JOIN AsyncLookupTable\n                        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n                        |")).stripMargin());
        this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testJoinWithAsyncHint() {
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT /*+ LOOKUP('table'='AsyncLookupTable', 'output-mode'='allow_unordered', 'time-out'='600s', 'capacity'='300') */\n        | T.a, D.name, D.age\n        |FROM MyTable T\n        |JOIN AsyncLookupTable\n        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |")).stripMargin());
        this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testJoinWithRetryHint() {
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT /*+ LOOKUP('table'='LookupTable', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='3') */\n        | T.a, D.name, D.age\n        |FROM MyTable T\n        |JOIN LookupTable\n        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |")).stripMargin());
        this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testJoinWithAsyncAndRetryHint() {
        StatementSet stmt = ((TestingTableEnvironment)this.util().tableEnv()).createStatementSet();
        stmt.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO Sink1\n        |SELECT /*+ LOOKUP('table'='AsyncLookupTable', 'output-mode'='allow_unordered', 'time-out'='600s', 'capacity'='300', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='3') */\n        | T.a, D.name, D.age\n        |FROM MyTable T\n        |JOIN AsyncLookupTable\n        |FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |")).stripMargin());
        this.util().verifyExplain(stmt, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createLookupTable(String tableName, UserDefinedFunction lookupFunction) {
        if (this.legacyTableSource) {
            UserDefinedFunction userDefinedFunction = lookupFunction;
            if (userDefinedFunction instanceof TableFunction) {
                TableFunction tableFunction = (TableFunction)userDefinedFunction;
                TestInvalidTemporalTable$.MODULE$.createTemporaryTable(this.util().tableEnv(), tableName, tableFunction);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                if (!(userDefinedFunction instanceof AsyncTableFunction)) throw new MatchError((Object)userDefinedFunction);
                AsyncTableFunction asyncTableFunction = (AsyncTableFunction)userDefinedFunction;
                TestInvalidTemporalTable$.MODULE$.createTemporaryTable(this.util().tableEnv(), tableName, asyncTableFunction);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        } else {
            this.util().addTable(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(387).append("\n                       |CREATE TABLE ").append(tableName).append(" (\n                       |  `id` INT,\n                       |  `name` STRING,\n                       |  `age` INT,\n                       |  `ts` TIMESTAMP(3)\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'lookup-function-class' = '").append(lookupFunction.getClass().getName()).append("'\n                       |)\n                       |").toString())).stripMargin());
        }
    }

    private void expectExceptionThrown(String sql, String message, Class<? extends Throwable> clazz) {
        try {
            this.verifyTranslationSuccess(sql);
            Assert.fail((String)new StringBuilder(40).append("Expected a ").append(clazz).append(", but no exception is thrown.").toString());
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)clazz.isAssignableFrom(e.getClass()));
            Assert.assertThat((Object)e, (Matcher)FlinkMatchers.containsMessage((String)message));
        }
    }

    private Class<? extends Throwable> expectExceptionThrown$default$3() {
        return ValidationException.class;
    }

    private void verifyTranslationSuccess(String sql) {
        this.util().tableEnv().sqlQuery(sql).explain(new ExplainDetail[0]);
    }

    public LookupJoinTest(boolean legacyTableSource) {
        this.legacyTableSource = legacyTableSource;
        this.util = this.streamTestUtil(this.streamTestUtil$default$1());
    }
}

